/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import epicsquid.mysticalworld.entity.SproutEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class IsColor
implements ILootCondition {
    private final boolean inverse;
    private final int variant;

    public IsColor(boolean inverseIn, String color) {
        this.inverse = inverseIn;
        this.variant = SproutEntity.StringToVariant(color);
    }

    public boolean test(LootContext lootContext) {
        int variant;
        Entity looted = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        if (looted instanceof SproutEntity) {
            SproutEntity sprout = (SproutEntity)looted;
            variant = (Integer)sprout.func_184212_Q().func_187225_a(SproutEntity.variant);
        } else {
            variant = 0;
        }
        boolean flag = variant == this.variant;
        return flag == !this.inverse;
    }

    public static ILootCondition.IBuilder builder(String variant) {
        return () -> new IsColor(false, variant);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<IsColor> {
        public Serializer() {
            super(new ResourceLocation("mysticalworld", "is_color"), IsColor.class);
        }

        public void serialize(JsonObject json, IsColor value, JsonSerializationContext context) {
            json.addProperty("inverse", Boolean.valueOf(value.inverse));
            json.addProperty("color", SproutEntity.VariantToString(value.variant));
        }

        public IsColor deserialize(JsonObject json, JsonDeserializationContext context) {
            return new IsColor(JSONUtils.func_151209_a((JsonObject)json, (String)"inverse", (boolean)false), JSONUtils.func_151219_a((JsonObject)json, (String)"color", (String)"green"));
        }
    }
}

