/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import epicsquid.mysticalworld.init.ModModifiers;
import epicsquid.mysticalworld.loot.Serendipity;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ApplyBonusModified
extends LootFunction {
    private static final Map<ResourceLocation, IFormulaDeserializer> field_215875_a = Maps.newHashMap();
    private final Enchantment enchantment;
    private final IFormula field_215877_d;

    private ApplyBonusModified(ILootCondition[] conditionsIn, Enchantment enchantmentIn, IFormula p_i51246_3_) {
        super(conditionsIn);
        this.enchantment = enchantmentIn;
        this.field_215877_d = p_i51246_3_;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216289_i);
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        ItemStack itemstack = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (itemstack != null) {
            Entity entity;
            int i = EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)itemstack);
            if (this.enchantment == Enchantments.field_185308_t && (entity = (Entity)context.func_216031_c(LootParameters.field_216281_a)) instanceof PlayerEntity) {
                IAttributeInstance serendipity = ((PlayerEntity)entity).func_110148_a(ModModifiers.SERENDIPITY);
                i += Serendipity.calculateAdditional(serendipity);
            }
            int j = this.field_215877_d.func_216204_a(context.func_216032_b(), stack.func_190916_E(), i);
            stack.func_190920_e(j);
        }
        return stack;
    }

    public static LootFunction.Builder<?> binomialWithBonusCount(Enchantment p_215870_0_, float p_215870_1_, int p_215870_2_) {
        return ApplyBonusModified.func_215860_a(p_215864_3_ -> new ApplyBonusModified((ILootCondition[])p_215864_3_, p_215870_0_, new BinomialWithBonusCountFormula(p_215870_2_, p_215870_1_)));
    }

    public static LootFunction.Builder<?> oreDrops(Enchantment p_215869_0_) {
        return ApplyBonusModified.func_215860_a(p_215866_1_ -> new ApplyBonusModified((ILootCondition[])p_215866_1_, p_215869_0_, new OreDropsFormula()));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215871_0_) {
        return ApplyBonusModified.func_215860_a(p_215872_1_ -> new ApplyBonusModified((ILootCondition[])p_215872_1_, p_215871_0_, new UniformBonusCountFormula(1)));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215865_0_, int p_215865_1_) {
        return ApplyBonusModified.func_215860_a(p_215868_2_ -> new ApplyBonusModified((ILootCondition[])p_215868_2_, p_215865_0_, new UniformBonusCountFormula(p_215865_1_)));
    }

    static {
        field_215875_a.put(BinomialWithBonusCountFormula.field_216211_a, BinomialWithBonusCountFormula::func_216210_a);
        field_215875_a.put(OreDropsFormula.field_216206_a, OreDropsFormula::func_216205_a);
        field_215875_a.put(UniformBonusCountFormula.field_216208_a, UniformBonusCountFormula::func_216207_a);
    }

    static final class UniformBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216208_a = new ResourceLocation("uniform_bonus_count");
        private final int bonusMultiplier;

        public UniformBonusCountFormula(int bonusMultiplier) {
            this.bonusMultiplier = bonusMultiplier;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            return p_216204_2_ + p_216204_1_.nextInt(this.bonusMultiplier * p_216204_3_ + 1);
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("bonusMultiplier", (Number)this.bonusMultiplier);
        }

        public static IFormula func_216207_a(JsonObject p_216207_0_, JsonDeserializationContext p_216207_1_) {
            int i = JSONUtils.func_151203_m((JsonObject)p_216207_0_, (String)"bonusMultiplier");
            return new UniformBonusCountFormula(i);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216208_a;
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyBonusModified> {
        public Serializer() {
            super(new ResourceLocation("apply_bonus"), ApplyBonusModified.class);
        }

        public void serialize(JsonObject object, ApplyBonusModified functionClazz, JsonSerializationContext serializationContext) {
            super.func_186532_a(object, (LootFunction)functionClazz, serializationContext);
            object.addProperty("enchantment", Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)functionClazz.enchantment)).toString());
            object.addProperty("formula", functionClazz.field_215877_d.func_216203_a().toString());
            JsonObject jsonobject = new JsonObject();
            functionClazz.field_215877_d.func_216202_a(jsonobject, serializationContext);
            if (jsonobject.size() > 0) {
                object.add("parameters", (JsonElement)jsonobject);
            }
        }

        public ApplyBonusModified deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"enchantment"));
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourcelocation);
            if (enchantment == null) {
                throw new JsonParseException("Invalid enchantment id: " + resourcelocation);
            }
            ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"formula"));
            IFormulaDeserializer applybonus$iformuladeserializer = (IFormulaDeserializer)field_215875_a.get(resourcelocation1);
            if (applybonus$iformuladeserializer == null) {
                throw new JsonParseException("Invalid formula id: " + resourcelocation1);
            }
            IFormula applybonus$iformula = object.has("parameters") ? applybonus$iformuladeserializer.deserialize(JSONUtils.func_152754_s((JsonObject)object, (String)"parameters"), deserializationContext) : applybonus$iformuladeserializer.deserialize(new JsonObject(), deserializationContext);
            return new ApplyBonusModified(conditionsIn, enchantment, applybonus$iformula);
        }
    }

    static final class OreDropsFormula
    implements IFormula {
        public static final ResourceLocation field_216206_a = new ResourceLocation("ore_drops");

        private OreDropsFormula() {
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            if (p_216204_3_ > 0) {
                int i = p_216204_1_.nextInt(p_216204_3_ + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return p_216204_2_ * (i + 1);
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
        }

        public static IFormula func_216205_a(JsonObject p_216205_0_, JsonDeserializationContext p_216205_1_) {
            return new OreDropsFormula();
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216206_a;
        }
    }

    static interface IFormulaDeserializer {
        public IFormula deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    static interface IFormula {
        public int func_216204_a(Random var1, int var2, int var3);

        public void func_216202_a(JsonObject var1, JsonSerializationContext var2);

        public ResourceLocation func_216203_a();
    }

    static final class BinomialWithBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216211_a = new ResourceLocation("binomial_with_bonus_count");
        private final int extra;
        private final float probability;

        public BinomialWithBonusCountFormula(int extra, float probability) {
            this.extra = extra;
            this.probability = probability;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            for (int i = 0; i < p_216204_3_ + this.extra; ++i) {
                if (!(p_216204_1_.nextFloat() < this.probability)) continue;
                ++p_216204_2_;
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("extra", (Number)this.extra);
            p_216202_1_.addProperty("probability", (Number)Float.valueOf(this.probability));
        }

        public static IFormula func_216210_a(JsonObject p_216210_0_, JsonDeserializationContext p_216210_1_) {
            int i = JSONUtils.func_151203_m((JsonObject)p_216210_0_, (String)"extra");
            float f = JSONUtils.func_151217_k((JsonObject)p_216210_0_, (String)"probability");
            return new BinomialWithBonusCountFormula(i, f);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216211_a;
        }
    }
}

