/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.network;

import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.api.Capabilities;
import epicsquid.mysticalworld.api.IPlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ShoulderRide {
    private CompoundNBT tag;
    private UUID id;

    public ShoulderRide(PacketBuffer buffer) {
        long uuid1 = buffer.readLong();
        long uuid2 = buffer.readLong();
        this.id = new UUID(uuid1, uuid2);
        this.tag = buffer.func_150793_b();
    }

    public ShoulderRide(PlayerEntity player, IPlayerShoulderCapability cap) {
        this.tag = cap.writeNBT();
        this.id = player.func_110124_au();
    }

    public CompoundNBT getTag() {
        return this.tag;
    }

    public UUID getId() {
        return this.id;
    }

    public void encode(PacketBuffer buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.func_150786_a(this.tag);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ShoulderRide.handle(this, context));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(ShoulderRide message, Supplier<NetworkEvent.Context> context) {
        ClientPlayerEntity target = Minecraft.func_71410_x().field_71439_g;
        World world = target.field_70170_p;
        if (!target.func_110124_au().equals(message.getId())) {
            target = world.func_217371_b(message.getId());
        }
        if (target == null) {
            return;
        }
        ClientPlayerEntity player = target;
        target.getCapability(Capabilities.SHOULDER_CAPABILITY).ifPresent(arg_0 -> ShoulderRide.lambda$handle$1(message, (PlayerEntity)player, arg_0));
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(ShoulderRide message, PlayerEntity player, IPlayerShoulderCapability cap) {
        cap.readNBT(message.getTag());
        try {
            PlayerShoulderCapability.setRightShoulder.invokeExact(player, cap.generateShoulderNBT());
        }
        catch (Throwable throwable) {
            MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
        }
    }
}

