/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import epicsquid.mysticalworld.recipe.IDamageRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessDamageRecipe
extends ShapelessRecipe
implements IDamageRecipe {
    private Ingredient damageItem;
    private Ingredient damageIngredient;
    private int damageAmount;

    public ShapelessDamageRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, Ingredient damageItem, int damageAmount) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.damageItem = damageItem;
        this.damageAmount = damageAmount;
        this.damageIngredient = this.createDamageIngredient(damageItem);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.getRemainingItems(inv, this.damageIngredient, this.damageAmount);
    }

    public static ShapelessDamageRecipe create(ShapelessRecipe recipe, Ingredient damageItem, int damageAmount) {
        return new ShapelessDamageRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c(), damageItem, damageAmount);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessDamageRecipe> {
        public ShapelessDamageRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe result = (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199425_a_(recipeId, json);
            Ingredient damageItem = Ingredient.func_199802_a((JsonElement)json.get("damage_item"));
            int damageAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"damage_amount", (int)-1);
            if (damageAmount == -1) {
                throw new JsonSyntaxException("Invalid damage_amount for ShapelessDamageRecipe.");
            }
            return ShapelessDamageRecipe.create(result, damageItem, damageAmount);
        }

        public ShapelessDamageRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe result = (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199426_a_(recipeId, buffer);
            Ingredient damageItem = Ingredient.func_199566_b((PacketBuffer)buffer);
            int damageAmount = buffer.readInt();
            return ShapelessDamageRecipe.create(result, damageItem, damageAmount);
        }

        public void write(PacketBuffer buffer, ShapelessDamageRecipe recipe) {
            IRecipeSerializer.field_222158_b.func_199427_a_(buffer, (IRecipe)recipe);
            recipe.damageItem.func_199564_a(buffer);
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

