/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import epicsquid.mysticalworld.repack.registrate.AbstractRegistrate;
import epicsquid.mysticalworld.repack.registrate.builders.AbstractBuilder;
import epicsquid.mysticalworld.repack.registrate.builders.BuilderCallback;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullConsumer;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullUnaryOperator;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.EmptyCarverConfig;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeBuilder<T extends Biome, P>
extends AbstractBuilder<Biome, T, P, BiomeBuilder<T, P>> {
    private final NonNullFunction<Biome.Builder, T> factory;
    private NonNullSupplier<Biome.Builder> initialProperties = Biome.Builder::new;
    private NonNullFunction<Biome.Builder, Biome.Builder> propertiesCallback = NonNullUnaryOperator.identity();
    private final Multimap<GenerationStage.Decoration, NonNullSupplier<ConfiguredFeature<?, ?>>> features = HashMultimap.create();
    private final Multimap<GenerationStage.Carving, NonNullSupplier<ConfiguredCarver<?>>> carvers = HashMultimap.create();
    private final Multimap<EntityClassification, NonNullSupplier<Biome.SpawnListEntry>> spawns = HashMultimap.create();
    private final EnumSet<BiomeManager.BiomeType> configuredTypes = EnumSet.noneOf(BiomeManager.BiomeType.class);

    public static <T extends Biome, P> BiomeBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Biome.Builder, T> factory) {
        return new BiomeBuilder<T, P>(owner, parent, name, callback, factory).defaultLang();
    }

    protected BiomeBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Biome.Builder, T> factory) {
        super(owner, parent, name, callback, Biome.class);
        this.factory = factory;
    }

    public BiomeBuilder<T, P> properties(NonNullUnaryOperator<Biome.Builder> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BiomeBuilder<T, P> initialProperties(NonNullSupplier<Biome.Builder> properties) {
        this.initialProperties = properties;
        return this;
    }

    public BiomeBuilder<T, P> typeWeight(BiomeManager.BiomeType type, int weight) {
        if (!this.configuredTypes.add(type)) {
            throw new IllegalArgumentException("Cannot set a type weight more than once.");
        }
        this.onRegister(b -> BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(b, weight)));
        return this;
    }

    public BiomeBuilder<T, P> addDictionaryTypes(BiomeDictionary.Type ... types) {
        this.onRegister(b -> BiomeDictionary.addTypes((Biome)b, (BiomeDictionary.Type[])types));
        return this;
    }

    public BiomeBuilder<T, P> forceAutomaticDictionaryTypes() {
        this.onRegister(BiomeDictionary::makeBestGuess);
        return this;
    }

    public BiomeBuilder<T, P> copyFeatures(NonNullSupplier<Biome> biome) {
        this.addFeatures(b -> Arrays.stream(GenerationStage.Decoration.values()).forEach(d -> ((Biome)biome.get()).func_203607_a(d).stream().forEach(f -> b.func_203611_a(d, f))));
        return this;
    }

    public BiomeBuilder<T, P> addFeature(GenerationStage.Decoration stage, NonNullSupplier<Feature<NoFeatureConfig>> feature, NonNullSupplier<Placement<NoPlacementConfig>> placement) {
        return this.addFeature(stage, feature, IFeatureConfig.field_202429_e, placement);
    }

    public <FC extends IFeatureConfig> BiomeBuilder<T, P> addFeature(GenerationStage.Decoration stage, NonNullSupplier<Feature<FC>> feature, FC featureConfig, NonNullSupplier<Placement<NoPlacementConfig>> placement) {
        return this.addFeature(stage, feature, featureConfig, placement, IPlacementConfig.field_202468_e);
    }

    public <PC extends IPlacementConfig> BiomeBuilder<T, P> addFeature(GenerationStage.Decoration stage, NonNullSupplier<Feature<NoFeatureConfig>> feature, NonNullSupplier<Placement<PC>> placement, PC placementConfig) {
        return this.addFeature(stage, feature, IFeatureConfig.field_202429_e, placement, placementConfig);
    }

    public <FC extends IFeatureConfig, PC extends IPlacementConfig> BiomeBuilder<T, P> addFeature(GenerationStage.Decoration stage, NonNullSupplier<Feature<FC>> feature, FC featureConfig, NonNullSupplier<Placement<PC>> placement, PC placementConfig) {
        return this.addConfiguredFeature(stage, () -> ((Feature)feature.get()).func_225566_b_(featureConfig).func_227228_a_(((Placement)placement.get()).func_227446_a_(placementConfig)));
    }

    public BiomeBuilder<T, P> addConfiguredFeature(GenerationStage.Decoration stage, NonNullSupplier<ConfiguredFeature<?, ?>> feature) {
        if (this.features.isEmpty()) {
            this.addFeatures(b -> this.features.forEach((d, f) -> b.func_203611_a(d, (ConfiguredFeature)f.get())));
        }
        this.features.put((Object)stage, feature);
        return this;
    }

    public BiomeBuilder<T, P> addFeatures(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(Feature.class, action);
        return this;
    }

    public BiomeBuilder<T, P> copyCarvers(NonNullSupplier<Biome> biome) {
        this.addCarvers(b -> Arrays.stream(GenerationStage.Carving.values()).forEach(s -> ((Biome)biome.get()).func_203603_a(s).stream().forEach(c -> b.func_203609_a(s, c))));
        return this;
    }

    public BiomeBuilder<T, P> addCarver(GenerationStage.Carving type, NonNullSupplier<WorldCarver<EmptyCarverConfig>> carver) {
        return this.addCarver(type, carver, ICarverConfig.field_214644_a);
    }

    public <CC extends ICarverConfig> BiomeBuilder<T, P> addCarver(GenerationStage.Carving type, NonNullSupplier<WorldCarver<CC>> carver, CC carverConfig) {
        return this.addConfiguredCarver(type, () -> Biome.func_203606_a((WorldCarver)((WorldCarver)carver.get()), (ICarverConfig)carverConfig));
    }

    public BiomeBuilder<T, P> addConfiguredCarver(GenerationStage.Carving type, NonNullSupplier<ConfiguredCarver<?>> carver) {
        if (this.features.isEmpty()) {
            this.addCarvers(b -> this.carvers.forEach((s, f) -> b.func_203609_a(s, (ConfiguredCarver)f.get())));
        }
        this.carvers.put((Object)type, carver);
        return this;
    }

    public BiomeBuilder<T, P> addCarvers(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(WorldCarver.class, action);
        return this;
    }

    public BiomeBuilder<T, P> copySpawns(NonNullSupplier<Biome> biome) {
        this.addSpawns(b -> Arrays.stream(EntityClassification.values()).forEach(ec -> ((Biome)biome.get()).func_76747_a(ec).stream().forEach(s -> b.func_76747_a(ec).add(s))));
        return this;
    }

    public BiomeBuilder<T, P> addSpawn(EntityClassification type, NonNullSupplier<? extends EntityType<?>> entity, int weight, int minGroupSize, int maxGroupSize) {
        return this.addSpawn(type, () -> new Biome.SpawnListEntry((EntityType)entity.get(), weight, minGroupSize, maxGroupSize));
    }

    public BiomeBuilder<T, P> addSpawn(EntityClassification type, NonNullSupplier<Biome.SpawnListEntry> spawn) {
        if (this.spawns.isEmpty()) {
            this.addSpawns(b -> this.spawns.forEach((c, s) -> b.func_76747_a(c).add(s.get())));
        }
        this.spawns.put((Object)type, spawn);
        return this;
    }

    public BiomeBuilder<T, P> addSpawns(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(EntityType.class, action);
        return this;
    }

    public BiomeBuilder<T, P> defaultLang() {
        return (BiomeBuilder)this.lang(Biome::func_210773_k);
    }

    public BiomeBuilder<T, P> lang(String name) {
        return (BiomeBuilder)this.lang(Biome::func_210773_k, name);
    }

    @Override
    @NonnullType
    protected T createEntry() {
        Biome.Builder properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Biome)this.factory.apply(properties));
    }
}

