/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption;

import fathertoast.naturalabsorption.NaturalAbsorptionMod;
import fathertoast.naturalabsorption.client.ClientProxy;
import fathertoast.naturalabsorption.health.HealthData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCapacity
implements IMessage {
    private float absorptionCapacity;

    public static void sendFor(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NaturalAbsorptionMod.network().sendTo((IMessage)new MessageCapacity(player), (EntityPlayerMP)player);
        }
    }

    public MessageCapacity() {
        this.absorptionCapacity = -1.0f;
    }

    private MessageCapacity(EntityPlayer player) {
        this.absorptionCapacity = HealthData.get(player).getAbsorptionCapacity();
    }

    public void fromBytes(ByteBuf buf) {
        this.absorptionCapacity = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.absorptionCapacity);
    }

    public static class Handler
    implements IMessageHandler<MessageCapacity, IMessage> {
        public IMessage onMessage(MessageCapacity message, MessageContext ctx) {
            ClientProxy.clientAbsorptionCapacity = message.absorptionCapacity;
            return null;
        }
    }
}

