/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption;

import fathertoast.naturalabsorption.NaturalAbsorptionMod;
import fathertoast.naturalabsorption.config.Config;
import fathertoast.naturalabsorption.item.EnchantmentAbsorption;
import fathertoast.naturalabsorption.item.ItemAbsorptionBook;
import fathertoast.naturalabsorption.item.RecipeStyle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModObjects {
    public static final Item BOOK_ABSORPTION = ModObjects.addInfo("book_absorption", CreativeTabs.field_78037_j, new ItemAbsorptionBook());
    public static final Enchantment ENCHANTMENT_ABSORPTION = ModObjects.addInfo("absorption", new EnchantmentAbsorption());
    private static final ResourceLocation ADV_BOOK_RECIPE = new ResourceLocation("naturalabsorption", "recipes/" + BOOK_ABSORPTION.getRegistryName().func_110623_a());

    private static <T extends Item> T addInfo(String name, CreativeTabs tab, T item) {
        ((Item)item.setRegistryName("naturalabsorption", name)).func_77655_b("naturalabsorption." + name).func_77637_a(tab);
        return item;
    }

    private static <T extends Enchantment> T addInfo(String name, T enchant) {
        ((Enchantment)enchant.setRegistryName("naturalabsorption", name)).func_77322_b("naturalabsorption." + name);
        return enchant;
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_UPGRADES.ENABLED) {
            event.getRegistry().register((IForgeRegistryEntry)BOOK_ABSORPTION);
        }
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ENCHANTMENT.ENABLED) {
            event.getRegistry().register((IForgeRegistryEntry)ENCHANTMENT_ABSORPTION);
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_UPGRADES.ENABLED) {
            NaturalAbsorptionMod.sidedProxy.registerRenderers();
        }
    }

    @SubscribeEvent
    public void onAdvancement(AdvancementEvent event) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_UPGRADES.ENABLED && Config.get().ABSORPTION_UPGRADES.RECIPE != RecipeStyle.Type.NONE && event.getAdvancement().func_192067_g().equals((Object)ADV_BOOK_RECIPE)) {
            ResourceLocation recipe = new ResourceLocation(BOOK_ABSORPTION.getRegistryName().toString() + "_" + Config.get().ABSORPTION_UPGRADES.RECIPE.name().toLowerCase());
            event.getEntityPlayer().func_193102_a(new ResourceLocation[]{recipe});
        }
    }

    public static enum EnchantRarity {
        COMMON(Enchantment.Rarity.COMMON),
        UNCOMMON(Enchantment.Rarity.UNCOMMON),
        RARE(Enchantment.Rarity.RARE),
        VERY_RARE(Enchantment.Rarity.VERY_RARE);

        public final Enchantment.Rarity parentValue;

        private EnchantRarity(Enchantment.Rarity parent) {
            this.parentValue = parent;
        }
    }

    public static enum EnchantArmorType {
        ALL(EnumEnchantmentType.ARMOR),
        HEAD(EnumEnchantmentType.ARMOR_HEAD),
        CHEST(EnumEnchantmentType.ARMOR_CHEST),
        LEGS(EnumEnchantmentType.ARMOR_LEGS),
        FEET(EnumEnchantmentType.ARMOR_FEET);

        public final EnumEnchantmentType parentValue;

        private EnchantArmorType(EnumEnchantmentType parent) {
            this.parentValue = parent;
        }
    }
}

