/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.config;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class EntryEntity {
    public final Class<? extends Entity> CLASS;
    public final boolean EXTEND;
    public final float[] VALUES;

    public EntryEntity(Class<? extends Entity> entityClass) {
        this(entityClass, false, (float[])null);
    }

    public EntryEntity(Class<? extends Entity> entityClass, float ... vals) {
        this(entityClass, true, vals);
    }

    public EntryEntity(Class<? extends Entity> entityClass, boolean extend, float ... vals) {
        this.CLASS = entityClass;
        this.EXTEND = extend;
        this.VALUES = vals;
    }

    public EntryEntity(Class<? extends Entity> entityClass, boolean extend, String[] vals) {
        this.CLASS = entityClass;
        this.EXTEND = extend;
        this.VALUES = new float[vals.length - 1];
        for (int i = 0; i < this.VALUES.length; ++i) {
            float val;
            try {
                val = Float.parseFloat(vals[i + 1].trim());
            }
            catch (NumberFormatException ex) {
                val = -1.0f;
            }
            if (!(val >= 0.0f) || !(val <= 1.0f)) continue;
            this.VALUES[i] = val;
        }
    }

    public boolean contains(EntryEntity entry) {
        if (this.CLASS == entry.CLASS) {
            return !entry.EXTEND;
        }
        if (this.EXTEND) {
            return this.CLASS.isAssignableFrom(entry.CLASS);
        }
        return false;
    }

    public String toString() {
        ResourceLocation resource = EntityList.func_191306_a(this.CLASS);
        StringBuilder str = new StringBuilder(resource == null ? "null" : resource.toString());
        if (!this.EXTEND) {
            str.insert(0, '~');
        }
        if (this.VALUES != null && this.VALUES.length > 0) {
            for (float val : this.VALUES) {
                str.append(' ').append(val);
            }
        }
        return str.toString();
    }
}

