/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.config;

import fathertoast.naturalabsorption.config.TargetEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EnvironmentListConfig {
    final List<TargetEnvironment> ENTRIES = new ArrayList<TargetEnvironment>();

    public EnvironmentListConfig(TargetEnvironment ... targets) {
        this.ENTRIES.addAll(Arrays.asList(targets));
        Collections.sort(this.ENTRIES);
    }

    EnvironmentListConfig(String line) {
        this(line.split(","));
    }

    EnvironmentListConfig(String[] list) {
        for (String item : list) {
            TargetEnvironment target = TargetEnvironment.read(item);
            if (target == null) continue;
            this.ENTRIES.add(target);
        }
        Collections.sort(this.ENTRIES);
    }

    public float getValueForLocation(World world, BlockPos pos, float defaultValue) {
        if (!this.ENTRIES.isEmpty()) {
            LocationInfo location = new LocationInfo(world, pos);
            for (TargetEnvironment target : this.ENTRIES) {
                if (!target.applies(location)) continue;
                return target.getValue();
            }
        }
        return defaultValue;
    }

    static class LocationInfo {
        final World theWorld;
        final BlockPos worldPos;
        final int dimId;
        final DimensionType dimType;
        final Biome exactBiome;
        final Biome biome;
        final ResourceLocation biomeName;

        LocationInfo(World world, BlockPos pos) {
            this.theWorld = world;
            this.worldPos = pos;
            this.dimId = world.field_73011_w.getDimension();
            this.dimType = world.field_73011_w.func_186058_p();
            this.exactBiome = world.func_180494_b(this.worldPos);
            Biome baseMutation = Biome.func_185356_b((Biome)this.exactBiome);
            this.biome = baseMutation != null ? baseMutation : this.exactBiome;
            this.biomeName = this.biome.getRegistryName();
        }
    }
}

