/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.health;

import fathertoast.naturalabsorption.MessageCapacity;
import fathertoast.naturalabsorption.config.Config;
import fathertoast.naturalabsorption.health.HealthManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class HealthData {
    private static final int NBT_TAG_PRIMITIVE = 99;
    private static final String TAG_BASE = "NaturalAbsorption";
    private static final String TAG_CAPACITY_ABSORPTION = "AbspCapacity";
    private static final String TAG_DELAY_ABSORPTION = "AbspDelay";
    private static final String TAG_DELAY_NORMAL = "NormDelay";
    private static final Map<UUID, HealthData> PLAYER_CACHE = new HashMap<UUID, HealthData>();
    public final EntityPlayer owner;
    private final NBTTagCompound saveTag;
    private float capacityAbsp;
    private int delayAbsp;
    private int delayNorm;

    public static void clearCache() {
        PLAYER_CACHE.clear();
    }

    public static HealthData get(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalArgumentException("Health data is only stored on the server side!");
        }
        UUID uuid = player.func_110124_au();
        HealthData data = PLAYER_CACHE.get(uuid);
        if (data == null || player != data.owner) {
            data = new HealthData(player);
            PLAYER_CACHE.put(uuid, data);
        }
        return data;
    }

    public float getAbsorptionCapacity() {
        return this.capacityAbsp;
    }

    public void setAbsorptionCapacity(float value) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED && this.capacityAbsp != (value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)Config.get().ABSORPTION_UPGRADES.MAXIMUM))) {
            this.saveTag.func_74776_a(TAG_CAPACITY_ABSORPTION, value);
            this.capacityAbsp = value;
            MessageCapacity.sendFor(this.owner);
        }
    }

    public int getAbsorptionDelay() {
        return this.delayAbsp;
    }

    public void setAbsorptionDelay(int value) {
        this.saveTag.func_74776_a(TAG_DELAY_ABSORPTION, (float)value);
        this.delayAbsp = value;
    }

    public void reduceAbsorptionDelay(int value) {
        this.setAbsorptionDelay(this.delayAbsp - value);
    }

    public int getNormalDelay() {
        return this.delayNorm;
    }

    public void setNormalDelay(int value) {
        this.saveTag.func_74776_a(TAG_DELAY_NORMAL, (float)value);
        this.delayNorm = value;
    }

    public void reduceNormalDelay(int val) {
        this.setNormalDelay(this.delayNorm - val);
    }

    public void startRecoveryDelay() {
        if (Config.get().NORMAL_HEALTH.ENABLED && Config.get().NORMAL_HEALTH.RECOVER_DELAY > 0) {
            this.setNormalDelay(Config.get().NORMAL_HEALTH.RECOVER_DELAY);
        }
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_HEALTH.RECOVER_DELAY > 0) {
            this.setAbsorptionDelay(Config.get().ABSORPTION_HEALTH.RECOVER_DELAY);
        }
    }

    public float getGlobalCapacity() {
        return Math.min(this.getAbsorptionCapacity() + HealthManager.getArmorAbsorption(this.owner), Config.get().ABSORPTION_HEALTH.GLOBAL_MAXIMUM);
    }

    public float getEffectiveCapacity() {
        return this.getGlobalCapacity() + HealthManager.getPotionAbsorption(this.owner);
    }

    public void setAbsorptionHealth(float value) {
        this.owner.func_110149_m(MathHelper.func_76131_a((float)value, (float)0.0f, (float)this.getEffectiveCapacity()));
    }

    void update() {
        if (Config.get().NORMAL_HEALTH.ENABLED && Config.get().NORMAL_HEALTH.RECOVER_DELAY >= 0) {
            this.updateNormalHealth();
        }
        if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_HEALTH.RECOVER_DELAY >= 0) {
            this.updateAbsorptionHealth();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAbsorptionHealth() {
        float recovered;
        if (this.getAbsorptionDelay() > 0) {
            if (this.getAbsorptionDelay() >= Config.get().GENERAL.UPDATE_TIME) {
                this.reduceAbsorptionDelay(Config.get().GENERAL.UPDATE_TIME);
                return;
            }
            int ticksPastZero = Config.get().GENERAL.UPDATE_TIME - this.getAbsorptionDelay();
            recovered = Config.get().ABSORPTION_HEALTH.RECOVER_RATE * (float)ticksPastZero;
            this.setAbsorptionDelay(0);
        } else {
            recovered = Config.get().ABSORPTION_HEALTH.RECOVER_RATE * (float)Config.get().GENERAL.UPDATE_TIME;
        }
        float effectiveCapacity = this.getEffectiveCapacity();
        float currentAbsorption = this.owner.func_110139_bj();
        if (recovered > 0.0f && currentAbsorption < effectiveCapacity) {
            float toughness;
            if (Config.get().ARMOR.REPLACE_ARMOR && Config.get().ARMOR.ARMOR_TOUGHNESS_RECOVERY > 0.0f && (toughness = Math.min(20.0f, (float)this.owner.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e())) > 0.0f) {
                recovered *= 1.0f + toughness * Config.get().ARMOR.ARMOR_TOUGHNESS_RECOVERY;
            }
            this.owner.func_110149_m(Math.min(effectiveCapacity, currentAbsorption + recovered));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateNormalHealth() {
        float recovered;
        if (this.getNormalDelay() > 0) {
            if (this.getNormalDelay() >= Config.get().GENERAL.UPDATE_TIME) {
                this.reduceNormalDelay(Config.get().GENERAL.UPDATE_TIME);
                return;
            }
            int ticksPastZero = Config.get().GENERAL.UPDATE_TIME - this.getNormalDelay();
            recovered = Config.get().NORMAL_HEALTH.RECOVER_RATE * (float)ticksPastZero;
            this.setNormalDelay(0);
        } else {
            recovered = Config.get().NORMAL_HEALTH.RECOVER_RATE * (float)Config.get().GENERAL.UPDATE_TIME;
        }
        if (this.owner.func_71024_bL().func_75116_a() < Config.get().NORMAL_HEALTH.HUNGER_REQUIRED) {
            return;
        }
        float effectiveCapacity = Math.min(Config.get().NORMAL_HEALTH.MAXIMUM, this.owner.func_110138_aP());
        float oldHealthAmount = this.owner.func_110143_aJ();
        if (!(recovered > 0.0f)) return;
        if (!(oldHealthAmount < effectiveCapacity)) return;
        float newHealthAmount = oldHealthAmount + recovered;
        if (newHealthAmount > effectiveCapacity) {
            this.owner.func_70606_j(effectiveCapacity);
            this.owner.func_71024_bL().func_75113_a((effectiveCapacity - oldHealthAmount) * Config.get().NORMAL_HEALTH.HUNGER_COST);
            return;
        }
        this.owner.func_70606_j(newHealthAmount);
        this.owner.func_71024_bL().func_75113_a(recovered * Config.get().NORMAL_HEALTH.HUNGER_COST);
    }

    private HealthData(EntityPlayer player) {
        this.owner = player;
        this.saveTag = this.getHealthNBTTag();
        if (this.saveTag.func_150297_b(TAG_CAPACITY_ABSORPTION, 99)) {
            this.capacityAbsp = Math.min(this.saveTag.func_74760_g(TAG_CAPACITY_ABSORPTION), Config.get().ABSORPTION_UPGRADES.MAXIMUM);
        } else if (Config.get().ABSORPTION_HEALTH.ENABLED) {
            this.setAbsorptionCapacity(Config.get().ABSORPTION_HEALTH.STARTING_AMOUNT);
            this.setAbsorptionHealth(this.getAbsorptionCapacity());
        }
        if (this.saveTag.func_150297_b(TAG_DELAY_ABSORPTION, 99)) {
            this.delayAbsp = this.saveTag.func_74762_e(TAG_DELAY_ABSORPTION);
        } else {
            this.setAbsorptionDelay(0);
        }
        if (this.saveTag.func_150297_b(TAG_DELAY_NORMAL, 99)) {
            this.delayNorm = this.saveTag.func_74762_e(TAG_DELAY_NORMAL);
        } else {
            this.setNormalDelay(0);
        }
    }

    private NBTTagCompound getHealthNBTTag() {
        NBTTagCompound tag = this.owner.getEntityData();
        if (!tag.func_150297_b("PlayerPersisted", (int)tag.func_74732_a())) {
            tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(tag = tag.func_74775_l("PlayerPersisted")).func_150297_b(TAG_BASE, (int)tag.func_74732_a())) {
            tag.func_74782_a(TAG_BASE, (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l(TAG_BASE);
    }
}

