/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.item;

import fathertoast.naturalabsorption.NaturalAbsorptionMod;
import fathertoast.naturalabsorption.client.ClientProxy;
import fathertoast.naturalabsorption.config.Config;
import fathertoast.naturalabsorption.health.HealthData;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAbsorptionBook
extends Item {
    public ItemAbsorptionBook() {
        this.func_77625_d(1);
    }

    public static int getLevelCost(float capacity) {
        return MathHelper.func_76125_a((int)((int)(Config.get().ABSORPTION_UPGRADES.LEVEL_COST + Config.get().ABSORPTION_UPGRADES.LEVEL_COST_PER_POINT * capacity)), (int)0, (int)Config.get().ABSORPTION_UPGRADES.LEVEL_COST_MAX);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!Config.get().ABSORPTION_HEALTH.ENABLED || !Config.get().ABSORPTION_UPGRADES.ENABLED) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack book = player.func_184586_b(hand);
        float currentCap = NaturalAbsorptionMod.sidedProxy.getAbsorptionCapacity(player);
        int levelCost = ItemAbsorptionBook.getLevelCost(currentCap);
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (currentCap < Config.get().ABSORPTION_UPGRADES.MAXIMUM && (isCreative || player.field_71068_ca >= levelCost)) {
            if (!isCreative) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                player.func_82242_a(-levelCost);
            }
            if (!world.field_72995_K) {
                HealthData data = HealthData.get(player);
                data.setAbsorptionCapacity(currentCap + Config.get().ABSORPTION_UPGRADES.CAPACITY_GAIN);
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)book);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)book);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        float capacity = ClientProxy.clientAbsorptionCapacity;
        if (capacity >= 0.0f) {
            EntityPlayer player = NaturalAbsorptionMod.sidedProxy.getPlayer();
            float gainOnUse = Config.get().ABSORPTION_UPGRADES.CAPACITY_GAIN;
            float maxCapacity = Config.get().ABSORPTION_UPGRADES.MAXIMUM;
            if (gainOnUse > maxCapacity - capacity) {
                gainOnUse = maxCapacity - capacity;
            }
            if (Config.get().ABSORPTION_UPGRADES.SHOW_INFO_IN_TOOLTIP) {
                tooltip.add(this.translate("current", new Object[0]));
                tooltip.add(TextFormatting.YELLOW.toString() + " " + this.prettyToString(capacity) + " / " + this.prettyToString(maxCapacity));
            }
            if (gainOnUse > 0.0f) {
                tooltip.add("");
                tooltip.add(this.translate("gain", new Object[0]));
                tooltip.add(TextFormatting.BLUE.toString() + " +" + this.prettyToString(gainOnUse) + " " + this.translate("max", new Object[0]));
                if (player != null) {
                    int levelCost = ItemAbsorptionBook.getLevelCost(capacity);
                    boolean hasLevels = levelCost <= player.field_71068_ca;
                    tooltip.add("");
                    if (levelCost > 0) {
                        tooltip.add(this.translate("cost", levelCost));
                    }
                    if (hasLevels || player.field_71075_bZ.field_75098_d) {
                        tooltip.add(this.translate("canuse", new Object[0]));
                    } else {
                        tooltip.add(this.translate("nouse", new Object[0]));
                    }
                }
            } else {
                tooltip.add("");
                tooltip.add(this.translate("nouse", new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String translate(String key, Object ... args) {
        return new TextComponentTranslation(this.func_77658_a() + ".tooltip." + key, args).func_150260_c();
    }

    private String prettyToString(float value) {
        return (float)Math.round(value) == value ? Integer.toString(Math.round(value)) : Float.toString(value);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }
}

