/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class VillagerTinkerTrades
implements EntityVillager.ITradeList {
    private final List<ItemStack> allowedIngredients = new ArrayList<ItemStack>();
    private final int max = 17;
    private final int min = 7;

    public VillagerTinkerTrades() {
        this.allowedIngredients.add(new ItemStack((Block)Blocks.field_150331_J, 64));
        this.allowedIngredients.add(new ItemStack((Block)Blocks.field_150320_F, 64));
        this.maybeAddTinkerItem("punji", 64);
        this.maybeAddTinkerItem("tooltables", 3, 3);
        this.maybeAddTinkerItem("tooltables", 3, 2);
        this.maybeAddTinkerItem("tooltables", 3, 4);
        this.maybeAddTinkerItem("tooltables", 3, 1);
    }

    private void maybeAddTinkerItem(String name, int quantity, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("tconstruct", name));
        if (item != null) {
            this.allowedIngredients.add(new ItemStack(item, quantity, meta));
        }
    }

    private void maybeAddTinkerItem(String name, int quantity) {
        this.maybeAddTinkerItem(name, quantity, 0);
    }

    public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
        for (BlockOreberryBush block : CommonProxy.oreberryBushBlocks) {
            if (!block.config.tradeable) continue;
            int num = VillagerTinkerTrades.getNextInt(random, 7, 17);
            ItemStack ingredient = this.getIngredient(random, num);
            ItemStack ingredient2 = ingredient.func_190916_E() < 13 ? this.getIngredient(random, ingredient) : ItemStack.field_190927_a;
            ItemStack result = new ItemStack((Block)block, VillagerTinkerTrades.calcStackSize(ingredient, ingredient2));
            recipeList.add((Object)new MerchantRecipe(ingredient, ingredient2, result));
        }
    }

    private static int calcStackSize(ItemStack ingredient, ItemStack ingredient2) {
        if (ingredient == ItemStack.field_190927_a) {
            return 1;
        }
        int num = ingredient.func_190916_E();
        if (ingredient2 != ItemStack.field_190927_a) {
            num += ingredient2.func_190916_E();
        }
        return Math.max(1, Math.round((num - 5) / 4));
    }

    private ItemStack getIngredient(Random random, ItemStack ingredient) {
        int sc;
        ItemStack is;
        int tries = 0;
        while ((is = this.allowedIngredients.get(sc = VillagerTinkerTrades.getNextInt(random, 0, this.allowedIngredients.size() - 1))) == ingredient && is.func_77952_i() == ingredient.func_77952_i()) {
            if (++tries != 5) continue;
            return ItemStack.field_190927_a;
        }
        int num = VillagerTinkerTrades.getNextInt(random, 0, Math.min(is.func_190916_E(), 17 - ingredient.func_190916_E()));
        return is.func_77946_l().func_77979_a(num);
    }

    private ItemStack getIngredient(Random random, int num) {
        int sc = VillagerTinkerTrades.getNextInt(random, 0, this.allowedIngredients.size() - 1);
        ItemStack item = this.allowedIngredients.get(sc);
        return item.func_77946_l().func_77979_a(Math.min(num, item.func_190916_E()));
    }

    private static int getNextInt(Random random, int min, int max) {
        return random.nextInt(Math.max(1, max - min + 1)) + min;
    }
}

