/*
 * Decompiled with CFR 0.152.
 */
package quarris.pickpocketer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.items.IItemHandlerModifiable;
import quarris.pickpocketer.PickPocketer;
import quarris.pickpocketer.config.MobLootEntry;
import quarris.pickpocketer.config.ModConfig;

public class CapabilityMobSteal
implements IItemHandlerModifiable,
ICapabilitySerializable<NBTTagCompound> {
    private static final Field rand = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70146_Z");
    private static final Field deathLootTable = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184659_bA");
    private static final Field deathLootTableSeed = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184653_bB");
    private static final Method getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
    private static Random random = new Random();
    @CapabilityInject(value=CapabilityMobSteal.class)
    public static Capability<CapabilityMobSteal> INSTANCE;
    public final EntityLiving mob;
    public final int size;
    public final NonNullList<ItemStack> inventory;
    public boolean hasGenerated;

    public CapabilityMobSteal(EntityLiving mob, int size) {
        this.mob = mob;
        this.size = size;
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public void populateInventory(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || this.hasGenerated) {
            return;
        }
        if (this.generateCustomStealLoot()) {
            this.hasGenerated = true;
            return;
        }
        try {
            ResourceLocation resourcelocation = (ResourceLocation)deathLootTable.get(this.mob);
            if (resourcelocation == null) {
                resourcelocation = (ResourceLocation)getLootTable.invoke((Object)this.mob, new Object[0]);
            }
            if (resourcelocation != null) {
                LootTable loottable = this.mob.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
                DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.mob.field_70170_p).func_186472_a((Entity)this.mob).func_186473_a(source).func_186470_a(player).func_186469_a(player.func_184817_da());
                List loot = loottable.func_186462_a(deathLootTableSeed.getFloat(this.mob) == 0.0f ? (Random)rand.get(this.mob) : new Random(deathLootTableSeed.getLong(this.mob)), lootcontext$builder.func_186471_a());
                int size = Math.min(this.getInternalSize(), loot.size());
                for (int i = 0; i < size; ++i) {
                    this.setStackInSlot(i, (ItemStack)loot.get(i));
                }
                this.hasGenerated = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean generateCustomStealLoot() {
        String mobName = EntityRegistry.getEntry(this.mob.getClass()).getRegistryName().toString();
        if (!ModConfig.lootEntries.containsKey(mobName)) {
            return false;
        }
        MobLootEntry entry = ModConfig.lootEntries.get(mobName);
        ArrayList<MobLootEntry.ItemEntry> shuffled = new ArrayList<MobLootEntry.ItemEntry>(entry.loot);
        Collections.shuffle(shuffled, random);
        int size = Math.min(this.getInternalSize(), shuffled.size());
        for (int i = 0; i < size; ++i) {
            this.setStackInSlot(i, ((MobLootEntry.ItemEntry)shuffled.get(i)).generate(random));
        }
        return true;
    }

    public EntityEquipmentSlot getEquipSlot(int index) {
        return EntityEquipmentSlot.values()[index - this.getInternalSize()];
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot < this.getInternalSize()) {
            this.inventory.set(slot, (Object)stack);
            return;
        }
        if (!this.mob.field_70170_p.field_72995_K) {
            PickPocketer.LOGGER.warn("Attempted to set stack {} in out of bounds slot {} with max {} for mob steal capability {}. This is NOT critical but should not have happened.", (Object)stack, (Object)slot, (Object)this.getSlots(), (Object)this.mob.func_70005_c_());
        }
    }

    public int getSlots() {
        return this.size + 6;
    }

    public int getInternalSize() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.getInternalSize()) {
            return (ItemStack)this.inventory.get(slot);
        }
        if (slot < this.getSlots()) {
            return this.mob.func_184582_a(this.getEquipSlot(slot));
        }
        return ItemStack.field_190927_a;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getStackInSlot(slot);
        if (!simulate) {
            if (slot < this.getInternalSize()) {
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            } else if (slot < this.getSlots()) {
                this.mob.func_184201_a(this.getEquipSlot(slot), ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == INSTANCE;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == INSTANCE ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.inventory);
        nbt.func_74757_a("HasGenerated", this.hasGenerated);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        this.hasGenerated = nbt.func_74767_n("HasGenerated");
    }
}

