/*
 * Decompiled with CFR 0.152.
 */
package quarris.pickpocketer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import quarris.pickpocketer.config.MobLootEntry;
import quarris.pickpocketer.config.ModConfig;

public class InventoryMob
extends InventoryBasic
implements INBTSerializable<NBTTagCompound> {
    private static final Field rand = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70146_Z");
    private static final Field deathLootTable = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184659_bA");
    private static final Field deathLootTableSeed = ObfuscationReflectionHelper.findField(EntityLiving.class, (String)"field_184653_bB");
    private static final Method getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
    public final EntityLiving mob;
    private final Random random = new Random();

    public InventoryMob(EntityLiving mob) {
        super(mob.func_145748_c_().func_150254_d(), false, 5);
        this.mob = mob;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 5) {
            return super.func_70301_a(index);
        }
        if (index < 11) {
            return this.mob.func_184582_a(this.getSlot(index));
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index < 5) {
            return super.func_70304_b(index);
        }
        if (index < 11) {
            ItemStack equipment = this.func_70301_a(index);
            if (!equipment.func_190926_b()) {
                this.mob.func_184201_a(this.getSlot(index), ItemStack.field_190927_a);
            }
            return equipment;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 5) {
            super.func_70299_a(index, stack);
        }
    }

    private EntityEquipmentSlot getSlot(int index) {
        return EntityEquipmentSlot.values()[index - 5];
    }

    public boolean func_191420_l() {
        if (super.func_191420_l()) {
            for (ItemStack stack : this.mob.func_184209_aF()) {
                if (stack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public void save() {
        this.mob.getEntityData().func_74782_a("PP:Inventory", (NBTBase)this.serializeNBT());
    }

    public void load() {
        this.deserializeNBT(this.mob.getEntityData().func_74775_l("PP:Inventory"));
    }

    public void populateMobInventory(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.mob.getEntityData().func_74764_b("PP:Inventory")) {
            this.load();
            return;
        }
        if (this.generateCustomStealLoot()) {
            return;
        }
        try {
            ResourceLocation resourcelocation = (ResourceLocation)deathLootTable.get(this.mob);
            if (resourcelocation == null) {
                resourcelocation = (ResourceLocation)getLootTable.invoke((Object)this.mob, new Object[0]);
            }
            if (resourcelocation != null) {
                LootTable loottable = this.mob.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
                DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.mob.field_70170_p).func_186472_a((Entity)this.mob).func_186473_a(source).func_186470_a(player).func_186469_a(player.func_184817_da());
                List loot = loottable.func_186462_a(deathLootTableSeed.getFloat(this.mob) == 0.0f ? (Random)rand.get(this.mob) : new Random(deathLootTableSeed.getLong(this.mob)), lootcontext$builder.func_186471_a());
                int size = Math.min(5, loot.size());
                for (int i = 0; i < size; ++i) {
                    this.func_70299_a(i, (ItemStack)loot.get(i));
                }
                this.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean generateCustomStealLoot() {
        String mobName = EntityRegistry.getEntry(this.mob.getClass()).getRegistryName().toString();
        if (!ModConfig.lootEntries.containsKey(mobName)) {
            return false;
        }
        MobLootEntry entry = ModConfig.lootEntries.get(mobName);
        ArrayList<MobLootEntry.ItemEntry> shuffled = new ArrayList<MobLootEntry.ItemEntry>(entry.loot);
        Collections.shuffle(shuffled, this.random);
        int size = Math.min(5, shuffled.size());
        for (int i = 0; i < size; ++i) {
            this.func_70299_a(i, ((MobLootEntry.ItemEntry)shuffled.get(i)).generate(this.random));
        }
        this.save();
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NonNullList inv = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 5; ++i) {
            inv.set(i, (Object)this.func_70301_a(i));
        }
        return ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), (NonNullList)inv);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NonNullList inv = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)inv);
        for (int i = 0; i < 5; ++i) {
            this.func_70299_a(i, (ItemStack)inv.get(i));
        }
    }
}

