/*
 * Decompiled with CFR 0.152.
 */
package quarris.pickpocketer.container;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import quarris.pickpocketer.CapabilityMobSteal;
import quarris.pickpocketer.StealingManager;
import quarris.pickpocketer.config.ModConfig;
import quarris.pickpocketer.network.PacketHandler;
import quarris.pickpocketer.network.PacketSyncPlayer;

public class ContainerSteal
extends Container {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public final EntityPlayer player;
    public final EntityLivingBase target;

    public ContainerSteal(EntityPlayer player, EntityLivingBase target) {
        this.target = target;
        this.player = player;
        int yPlayerInv = this.isPlayerSteal() ? 145 : 112;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, i + (j + 1) * 9, 8 + i * 18, yPlayerInv + j * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, yPlayerInv + 58));
        }
        if (this.isPlayerSteal()) {
            this.addPlayerStealInventory((EntityPlayer)target);
        } else {
            this.addMobStealInventory((EntityLiving)target);
        }
    }

    public boolean isPlayerSteal() {
        return this.target instanceof EntityPlayer;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotId > 35) {
            if (clickType == ClickType.SWAP) {
                return ItemStack.field_190927_a;
            }
            if (this.isPlayerSteal() && !player.field_70170_p.field_72995_K) {
                if (player.field_70170_p.field_73012_v.nextFloat() > ModConfig.notifyChance) {
                    player.func_146105_b(new TextComponentTranslation("stealing.notify.player", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    ((EntityPlayer)this.target).func_146105_b(new TextComponentTranslation("stealing.notify.target", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                }
                player.getEntityData().func_74772_a("PP:StolenTime", player.field_70170_p.func_82737_E());
                PacketHandler.sendTo(new PacketSyncPlayer(player.field_70170_p.func_82737_E()), (EntityPlayerMP)player);
            }
            ItemStack stack = this.func_82846_b(player, slotId);
            return stack;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return !this.target.field_70128_L && player.func_70032_d((Entity)this.target) <= 3.0f && StealingManager.isHiddenFrom(player, this.target) && (!this.isPlayerSteal() || !player.getEntityData().func_74764_b("PP:StolenTime") || player.field_70170_p.func_82737_E() > player.getEntityData().func_74763_f("PP:StolenTime") + (long)ModConfig.cooldown);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 27 ? !this.func_75135_a(itemstack1, 27, 36, false) : (index < 36 ? !this.func_75135_a(itemstack1, 0, 27, false) : !this.func_75135_a(itemstack1, 0, 36, false))) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    private void addMobStealInventory(EntityLiving entity) {
        int i;
        CapabilityMobSteal mobInv = (CapabilityMobSteal)entity.getCapability(CapabilityMobSteal.INSTANCE, null);
        if (mobInv == null) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            mobInv.populateInventory(this.player);
        }
        for (i = 0; i < 5; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)mobInv, i, 44 + i * 18, 78));
        }
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)mobInv, 5, 26, 33){

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)mobInv, 6, 134, 33));
        for (i = 7; i < 11; ++i) {
            int x = (i - 7) % 2;
            int y = (i - 7) / 2;
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[i - 7];
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)mobInv, i, 71 + x * 18, 24 + y * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)ContainerSteal.this.player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
    }

    private void addPlayerStealInventory(EntityPlayer player) {
        int i;
        for (i = 0; i < VALID_EQUIPMENT_SLOTS.length; ++i) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[i];
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, 36 + (3 - i), 26 + i * 18, 21){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        for (int j = 0; j < 3; ++j) {
            for (int i2 = 0; i2 < 9; ++i2) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, i2 + (j + 1) * 9, 8 + i2 * 18, 55 + j * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 111));
        }
        this.func_75146_a(new Slot((IInventory)player.field_71071_by, 40, 134, 21){

            @Nullable
            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
    }
}

