/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.aiming.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.aiming.common.ProjectileItemDescription;
import org.jglrxavpok.aiming.common.ProjectileRegistry;
import org.lwjgl.util.vector.Vector3f;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0086\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jglrxavpok/aiming/common/ProjectilePath;", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "projectile", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)V", "itemDescription", "Lorg/jglrxavpok/aiming/common/ProjectileItemDescription;", "getItemDescription", "()Lorg/jglrxavpok/aiming/common/ProjectileItemDescription;", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "positions", "", "Lorg/lwjgl/util/vector/Vector3f;", "getPositions", "()Ljava/util/List;", "getProjectile", "()Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "kotlin.jvm.PlatformType", "compute", "maxIterations", "", "iterator", "", "potionofaiming"})
public final class ProjectilePath {
    @NotNull
    private final List<Vector3f> positions;
    private final World world;
    @NotNull
    private final ProjectileItemDescription itemDescription;
    @NotNull
    private final EntityPlayer player;
    @NotNull
    private final ItemStack projectile;

    @NotNull
    public final List<Vector3f> getPositions() {
        return this.positions;
    }

    @NotNull
    public final ProjectileItemDescription getItemDescription() {
        return this.itemDescription;
    }

    @NotNull
    public final Iterator<Vector3f> iterator() {
        return this.positions.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProjectilePath compute(int maxIterations) {
        float yaw = this.player.field_70759_as;
        float pitch = this.player.field_70125_A;
        float pitchWithOffset = this.player.field_70125_A + this.itemDescription.pitchOffset(this.projectile, this.player);
        float initialVelocity = this.itemDescription.velocity(this.projectile, this.player);
        float motionX = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float motionY = -MathHelper.func_76126_a((float)(pitchWithOffset * ((float)Math.PI / 180)));
        float motionZ = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float length = (float)Math.sqrt(motionX * motionX + motionY * motionY + motionZ * motionZ);
        motionX /= length;
        motionY /= length;
        motionZ /= length;
        motionX *= initialVelocity;
        motionY *= initialVelocity;
        motionZ *= initialVelocity;
        if (this.player.field_70122_E) {
            motionY += (float)this.player.field_70181_x;
        }
        motionX += (float)this.player.field_70159_w;
        motionZ += (float)this.player.field_70179_y;
        float x = (float)this.player.field_70165_t;
        float y = (float)(this.player.field_70163_u + (double)this.player.func_70047_e() - (double)0.1f);
        float z = (float)this.player.field_70161_v;
        this.positions.clear();
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        float gravity = this.itemDescription.gravity(this.projectile, this.player);
        float drag = this.itemDescription.dragFactor(this.projectile, this.player);
        int n = 0;
        int n2 = maxIterations;
        if (n <= n2) {
            while (true) {
                void i;
                AxisAlignedBB axisalignedbb;
                pos.func_189532_c((double)x, (double)y, (double)z);
                this.positions.add(new Vector3f(x, y, z));
                float lastX = x;
                float lastY = y;
                float lastZ = z;
                x += (motionX *= drag);
                y += (motionY -= gravity);
                z += (motionZ *= drag);
                IBlockState iblockstate = this.world.func_180495_p((BlockPos)pos);
                if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.world, (BlockPos)pos)) != Block.field_185506_k) {
                    AxisAlignedBB axisAlignedBB = axisalignedbb;
                    if (axisAlignedBB == null) {
                        Intrinsics.throwNpe();
                    }
                    if (axisAlignedBB.func_186670_a((BlockPos)pos).func_72318_a(new Vec3d((double)lastX, (double)lastY, (double)lastZ))) break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.positions.add(new Vector3f(x, y, z));
        pos.func_185344_t();
        return this;
    }

    @NotNull
    public final EntityPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public final ItemStack getProjectile() {
        return this.projectile;
    }

    public ProjectilePath(@NotNull EntityPlayer player, @NotNull ItemStack projectile) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)projectile, (String)"projectile");
        this.player = player;
        this.projectile = projectile;
        ProjectilePath projectilePath = this;
        projectilePath.positions = list = (List)new ArrayList();
        this.world = this.player.field_70170_p;
        Item item = this.projectile.func_77973_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"projectile.item");
        ProjectileItemDescription projectileItemDescription = ProjectileRegistry.INSTANCE.getDescription(item);
        if (projectileItemDescription == null) {
            Intrinsics.throwNpe();
        }
        this.itemDescription = projectileItemDescription;
    }
}

