/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CropEvents {
    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        if (CropEvents.harvest(event.getPos(), event.getPlayer())) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean harvest(BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        Block blockClicked = state.func_177230_c();
        if (Config.getReapWhitelist().stream().noneMatch(b -> b.equals(state.func_177230_c()))) {
            return false;
        }
        IGrowable growble = CropEvents.getGrowable(blockClicked);
        if (growble == null) {
            return false;
        }
        if (growble.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
            return false;
        }
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return true;
        }
        LootContext.Builder context = new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a);
        List drops = state.func_215693_a(context);
        BlockState newState = blockClicked.func_176223_P();
        if (state.func_206869_a().stream().anyMatch(p -> p.equals(HorizontalBlock.field_185512_D))) {
            newState = (BlockState)newState.func_206870_a((IProperty)HorizontalBlock.field_185512_D, state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
        }
        if (state.func_206869_a().stream().anyMatch(p -> p.equals(CropsBlock.field_176488_a))) {
            newState = (BlockState)state.func_206870_a((IProperty)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(0));
        }
        world.func_175656_a(pos, newState);
        for (ItemStack stack : drops) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
        return true;
    }

    private static IGrowable getGrowable(Block block) {
        if (block instanceof IGrowable) {
            return (IGrowable)block;
        }
        if (block instanceof NetherWartBlock) {
            return new IGrowable(){

                public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
                    return (Integer)state.func_177229_b((IProperty)NetherWartBlock.field_176486_a) < 3;
                }

                public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
                    return false;
                }

                public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
                }
            };
        }
        return null;
    }
}

