/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.api.buildcraft.api.blueprints;

import com.trhsy.sim.api.buildcraft.api.blueprints.MappingNotFoundException;
import com.trhsy.sim.api.buildcraft.api.blueprints.MappingRegistry;
import com.trhsy.sim.api.buildcraft.api.blueprints.Schematic;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SchematicFactory<S extends Schematic> {
    private static final HashMap<String, SchematicFactory<?>> factories = new HashMap();
    private static final HashMap<Class<? extends Schematic>, SchematicFactory<?>> schematicToFactory = new HashMap();

    protected abstract S loadSchematicFromWorldNBT(NBTTagCompound var1, MappingRegistry var2) throws MappingNotFoundException;

    public void saveSchematicToWorldNBT(NBTTagCompound nbt, S object, MappingRegistry registry) {
        nbt.func_74778_a("factoryID", this.getClass().getCanonicalName());
    }

    public static Schematic createSchematicFromWorldNBT(NBTTagCompound nbt, MappingRegistry registry) throws MappingNotFoundException {
        String factoryName = nbt.func_74779_i("factoryID");
        return factories.containsKey(factoryName) ? (Schematic)factories.get(factoryName).loadSchematicFromWorldNBT(nbt, registry) : null;
    }

    public static void registerSchematicFactory(Class<? extends Schematic> clas, SchematicFactory<?> factory) {
        schematicToFactory.put(clas, factory);
        factories.put(factory.getClass().getCanonicalName(), factory);
    }

    public static SchematicFactory getFactory(Class<? extends Schematic> clas) {
        Class<? extends Schematic> superClass = clas.getSuperclass();
        if (schematicToFactory.containsKey(clas)) {
            return schematicToFactory.get(clas);
        }
        return superClass != null ? SchematicFactory.getFactory(superClass) : null;
    }
}

