/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.api.buildcraft.api.blueprints;

import com.trhsy.sim.api.buildcraft.api.blueprints.IBuilderContext;
import com.trhsy.sim.api.buildcraft.api.blueprints.MappingRegistry;
import com.trhsy.sim.api.buildcraft.api.blueprints.SchematicBlockBase;
import com.trhsy.sim.api.buildcraft.api.core.BuildCraftAPI;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicMask
extends SchematicBlockBase {
    public boolean isConcrete = true;

    public SchematicMask() {
    }

    public SchematicMask(boolean isConcrete) {
        this.isConcrete = isConcrete;
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        if (this.isConcrete) {
            if (stacks.size() == 0 || !BuildCraftAPI.isSoftBlock(context.world(), x, y, z)) {
                return;
            }
            ItemStack stack = stacks.getFirst();
            EntityPlayer player = (EntityPlayer)BuildCraftAPI.proxy.getBuildCraftPlayer((WorldServer)context.world()).get();
            context.world().func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
            ForgeDirection dir = ForgeDirection.DOWN;
            while (dir != ForgeDirection.UNKNOWN && BuildCraftAPI.isSoftBlock(context.world(), x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
                dir = ForgeDirection.getOrientation((int)(dir.ordinal() + 1));
            }
            stack.func_77943_a(player, context.world(), x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite().ordinal(), 0.0f, 0.0f, 0.0f);
        } else {
            context.world().func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        if (this.isConcrete) {
            return !BuildCraftAPI.getWorldProperty("replaceable").get(context.world(), x, y, z);
        }
        return BuildCraftAPI.getWorldProperty("replaceable").get(context.world(), x, y, z);
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74757_a("isConcrete", this.isConcrete);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.isConcrete = nbt.func_74767_n("isConcrete");
    }
}

