/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.api.buildcraft.api.blueprints;

import com.trhsy.sim.api.buildcraft.api.blueprints.IBuilderContext;
import com.trhsy.sim.api.buildcraft.api.blueprints.MappingNotFoundException;
import com.trhsy.sim.api.buildcraft.api.blueprints.MappingRegistry;
import com.trhsy.sim.api.buildcraft.api.blueprints.SchematicBlock;
import com.trhsy.sim.api.buildcraft.api.core.JavaTools;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SchematicTile
extends SchematicBlock {
    public NBTTagCompound tileNBT = new NBTTagCompound();

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        registry.scanAndTranslateStacksToRegistry(this.tileNBT);
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        try {
            registry.scanAndTranslateStacksToWorld(this.tileNBT);
        }
        catch (MappingNotFoundException var3) {
            this.tileNBT = new NBTTagCompound();
        }
    }

    public void onNBTLoaded() {
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        if (this.block.hasTileEntity(this.meta)) {
            this.tileNBT.func_74768_a("x", x);
            this.tileNBT.func_74768_a("y", y);
            this.tileNBT.func_74768_a("z", z);
            context.world().func_147455_a(x, y, z, TileEntity.func_145827_c((NBTTagCompound)this.tileNBT));
        }
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if (this.block.hasTileEntity(this.meta)) {
            TileEntity tile = context.world().func_147438_o(x, y, z);
            if (tile != null) {
                tile.func_145841_b(this.tileNBT);
            }
            this.tileNBT = (NBTTagCompound)this.tileNBT.func_74737_b();
            this.onNBTLoaded();
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.storeRequirements(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                rqs.add(inv.func_70301_a(i));
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74782_a("blockCpt", (NBTBase)this.tileNBT);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.tileNBT = nbt.func_74775_l("blockCpt");
        this.onNBTLoaded();
    }

    @Override
    public int buildTime() {
        return 5;
    }
}

