/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.api.buildcraft.api.robots;

import com.trhsy.sim.api.buildcraft.api.core.BlockIndex;
import com.trhsy.sim.api.buildcraft.api.robots.DockingStation;
import com.trhsy.sim.api.buildcraft.api.robots.ResourceId;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceIdRequest
extends ResourceId {
    private BlockIndex index;
    private ForgeDirection side;
    private int slot;

    public ResourceIdRequest() {
    }

    public ResourceIdRequest(DockingStation station, int slot) {
        this.index = station.index();
        this.side = station.side();
        this.slot = slot;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            ResourceIdRequest compareId = (ResourceIdRequest)obj;
            return this.index.equals(compareId.index) && this.side.equals((Object)compareId.side) && this.slot == compareId.slot;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.index.hashCode()).append(this.side.hashCode()).append(this.slot).build();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
        nbt.func_74768_a("localId", this.slot);
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.getOrientation((int)nbt.func_74771_c("side"));
        this.slot = nbt.func_74762_e("localId");
    }
}

