/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.api.buildcraft.api.statements;

import com.trhsy.sim.api.buildcraft.api.core.BCLog;
import com.trhsy.sim.api.buildcraft.api.statements.IActionExternal;
import com.trhsy.sim.api.buildcraft.api.statements.IActionInternal;
import com.trhsy.sim.api.buildcraft.api.statements.IActionProvider;
import com.trhsy.sim.api.buildcraft.api.statements.IOverrideDefaultStatements;
import com.trhsy.sim.api.buildcraft.api.statements.IStatement;
import com.trhsy.sim.api.buildcraft.api.statements.IStatementContainer;
import com.trhsy.sim.api.buildcraft.api.statements.IStatementParameter;
import com.trhsy.sim.api.buildcraft.api.statements.ITriggerExternal;
import com.trhsy.sim.api.buildcraft.api.statements.ITriggerInternal;
import com.trhsy.sim.api.buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class StatementManager {
    public static Map<String, IStatement> statements = new HashMap<String, IStatement>();
    public static Map<String, Class<? extends IStatementParameter>> parameters = new HashMap<String, Class<? extends IStatementParameter>>();
    private static List<ITriggerProvider> triggerProviders = new LinkedList<ITriggerProvider>();
    private static List<IActionProvider> actionProviders = new LinkedList<IActionProvider>();

    private StatementManager() {
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static void registerStatement(IStatement statement) {
        statements.put(statement.getUniqueTag(), statement);
    }

    public static void registerParameterClass(Class<? extends IStatementParameter> param) {
        parameters.put(StatementManager.createParameter(param).getUniqueTag(), param);
    }

    @Deprecated
    public static void registerParameterClass(String name, Class<? extends IStatementParameter> param) {
        parameters.put(name, param);
    }

    /*
     * Unable to fully structure code
     */
    public static List<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity entity) {
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideTriggers()) != null) {
            return result;
        }
        result = new LinkedList<ITriggerExternal>();
        var3 = StatementManager.triggerProviders.iterator();
        block0: while (true) {
            if (!var3.hasNext()) {
                return result;
            }
            provider = var3.next();
            toAdd = provider.getExternalTriggers(side, entity);
            if (toAdd == null) continue;
            var6 = toAdd.iterator();
            while (true) {
                if (var6.hasNext()) ** break;
                continue block0;
                t = var6.next();
                if (result.contains(t)) continue;
                result.add(t);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<IActionExternal> getExternalActions(ForgeDirection side, TileEntity entity) {
        if (entity instanceof IOverrideDefaultStatements && (result = ((IOverrideDefaultStatements)entity).overrideActions()) != null) {
            return result;
        }
        result = new LinkedList<IActionExternal>();
        var3 = StatementManager.actionProviders.iterator();
        block0: while (true) {
            if (!var3.hasNext()) {
                return result;
            }
            provider = var3.next();
            toAdd = provider.getExternalActions(side, entity);
            if (toAdd == null) continue;
            var6 = toAdd.iterator();
            while (true) {
                if (var6.hasNext()) ** break;
                continue block0;
                t = var6.next();
                if (result.contains(t)) continue;
                result.add(t);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        result = new LinkedList<ITriggerInternal>();
        var2 = StatementManager.triggerProviders.iterator();
        block0: while (true) {
            if (!var2.hasNext()) {
                return result;
            }
            provider = var2.next();
            toAdd = provider.getInternalTriggers(container);
            if (toAdd == null) continue;
            var5 = toAdd.iterator();
            while (true) {
                if (var5.hasNext()) ** break;
                continue block0;
                t = var5.next();
                if (result.contains(t)) continue;
                result.add(t);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<IActionInternal> getInternalActions(IStatementContainer container) {
        result = new LinkedList<IActionInternal>();
        var2 = StatementManager.actionProviders.iterator();
        block0: while (true) {
            if (!var2.hasNext()) {
                return result;
            }
            provider = var2.next();
            toAdd = provider.getInternalActions(container);
            if (toAdd == null) continue;
            var5 = toAdd.iterator();
            while (true) {
                if (var5.hasNext()) ** break;
                continue block0;
                t = var5.next();
                if (result.contains(t)) continue;
                result.add(t);
            }
            break;
        }
    }

    public static IStatementParameter createParameter(String kind) {
        return StatementManager.createParameter(parameters.get(kind));
    }

    private static IStatementParameter createParameter(Class<? extends IStatementParameter> param) {
        try {
            return param.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Error var4) {
            BCLog.logErrorAPI(var4, IStatementParameter.class);
            throw var4;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        for (IStatement iStatement : statements.values()) {
            iStatement.registerIcons(register);
        }
        for (Class clazz : parameters.values()) {
            StatementManager.createParameter(clazz).registerIcons(register);
        }
    }
}

