/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.block.functionality;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FarmType;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class FarmingBox
implements Serializable {
    private static final long serialVersionUID = -4049876797684922153L;
    public V3 location;
    public V3 marker1XYZ;
    public V3 marker2XYZ;
    public V3 marker3XYZ;
    public FarmType farmType = FarmType.WHEAT;
    public int level = 1;

    public FarmingBox() {
    }

    public FarmingBox(V3 inxyz) {
        this.location = inxyz;
        if (this.level == 0) {
            this.level = 1;
        }
    }

    public FarmingBox(V3 inxyz, V3 m1xyz, V3 m2xyz, V3 m3xyz) {
        this.location = inxyz;
        this.marker1XYZ = m1xyz;
        this.marker2XYZ = m2xyz;
        this.marker3XYZ = m3xyz;
        if (this.level == 0) {
            this.level = 1;
        }
    }

    public V3 getMarkerVector(int markerNum) {
        V3 ret = null;
        try {
            if (markerNum == 1) {
                ret = this.marker1XYZ;
            } else if (markerNum == 2) {
                ret = this.marker2XYZ;
            } else if (markerNum == 3) {
                ret = this.marker3XYZ;
            }
            return ret;
        }
        catch (Exception var5) {
            return new V3(0, 0, 0, 0);
        }
    }

    public int getSizeWidth() {
        int ltr;
        boolean var1 = false;
        try {
            V3 m1 = this.getMarkerVector(1);
            V3 m2 = this.getMarkerVector(2);
            V3 m3 = this.getMarkerVector(3);
            ltr = m1.x.intValue() == m2.x.intValue() ? (int)(Math.abs(m2.z - m1.z) - 1.0) : (int)(Math.abs(m2.x - m1.x) - 1.0);
        }
        catch (Exception var5) {
            return 5;
        }
        return Math.abs(ltr);
    }

    public int getSizeLength() {
        int ftb;
        boolean var1 = false;
        try {
            V3 m1 = this.getMarkerVector(1);
            V3 m2 = this.getMarkerVector(2);
            V3 m3 = this.getMarkerVector(3);
            ftb = m1.x.intValue() == m3.x.intValue() ? (int)(Math.abs(m3.z - m1.z) - 1.0) : (int)(Math.abs(m3.x - m1.x) - 1.0);
        }
        catch (Exception var5) {
            return 5;
        }
        return Math.abs(ftb);
    }

    public ArrayList<V3> getSoilBlockPoints() {
        ArrayList<V3> ret = new ArrayList<V3>();
        V3 m1 = this.getMarkerVector(1);
        V3 m2 = this.getMarkerVector(2);
        V3 m3 = this.getMarkerVector(3);
        V3 c = m1.clone();
        int length = this.getSizeLength();
        if (length == 1) {
            ModSimReloaded.log.warning("FarmingBox: \u65e0\u6cd5\u4f7f\u75285x5\u9ed8\u8ba4\u503c\u786e\u5b9a\u519c\u573a\u5927\u5c0f");
        }
        for (int o = 0; o <= length; ++o) {
            for (int i = 0; i <= this.getSizeWidth(); ++i) {
                ret.add(c.clone());
                if (m2.x > m1.x) {
                    c.x = m1.x + (double)i;
                    continue;
                }
                if (m2.x < m1.x) {
                    c.x = m1.x - (double)i;
                    continue;
                }
                if (m2.z > m1.z) {
                    c.z = m1.z + (double)i;
                    continue;
                }
                if (!(m2.z < m1.z)) continue;
                c.z = m1.z - (double)i;
            }
            if (m3.x > m1.x) {
                c.x = m1.x + (double)o;
                continue;
            }
            if (m3.x < m1.x) {
                c.x = m1.x - (double)o;
                continue;
            }
            if (m3.z > m1.z) {
                c.z = m1.z + (double)o;
                continue;
            }
            if (!(m3.z < m1.z)) continue;
            c.z = m1.z - (double)o;
        }
        return ret;
    }

    public ArrayList<V3> getPerimeterPoints() {
        ArrayList<V3> ret = new ArrayList<V3>();
        try {
            Double var10;
            Double var9;
            int i;
            V3 m1 = this.getMarkerVector(1);
            V3 m2 = this.getMarkerVector(2);
            V3 m3 = this.getMarkerVector(3);
            V3 b = this.getLocation();
            V3 c = b.clone();
            for (i = 0; i <= this.getSizeWidth() + 1; ++i) {
                if (m2.x - b.x > 1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x + 1.0);
                } else if (m2.x - b.x < -1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x - 1.0);
                } else if (m2.z - b.z > 1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z + 1.0);
                } else if (m2.z - b.z < -1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z - 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeLength() + 2; ++i) {
                if (m3.x - b.x > 1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x + 1.0);
                } else if (m3.x - b.x < -1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x - 1.0);
                } else if (m3.z - b.z > 1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z + 1.0);
                } else if (m3.z - b.z < -1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z - 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeWidth() + 2; ++i) {
                if (m2.x - b.x > 1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x - 1.0);
                } else if (m2.x - b.x < -1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x + 1.0);
                } else if (m2.z - b.z > 1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z - 1.0);
                } else if (m2.z - b.z < -1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z + 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeLength() + 2; ++i) {
                if (m3.x - b.x > 1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x - 1.0);
                } else if (m3.x - b.x < -1.0) {
                    var9 = c.x;
                    var10 = c.x = Double.valueOf(c.x + 1.0);
                } else if (m3.z - b.z > 1.0) {
                    var9 = c.z;
                    var10 = c.z = Double.valueOf(c.z - 1.0);
                } else if (m3.z - b.z < -1.0) {
                    var9 = c.z;
                    Double d = c.z = Double.valueOf(c.z + 1.0);
                }
                ret.add(c.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public V3 getLocation() {
        return this.location;
    }

    public static FarmingBox getFarmingBlockByBoxXYZ(V3 xyz) {
        FarmingBox ret = null;
        if (ModSimReloaded.theFarmingBoxes.size() == 0) {
            FarmingBox.loadFarmingBoxes();
        }
        for (int x = 0; x < ModSimReloaded.theFarmingBoxes.size(); ++x) {
            FarmingBox block = ModSimReloaded.theFarmingBoxes.get(x);
            if (!block.location.isSameCoordsAs(xyz, true, true)) continue;
            ret = block;
            break;
        }
        return ret;
    }

    public static void loadFarmingBoxes() {
        Minecraft mc = Minecraft.func_71410_x();
        File farmFiles = new File(ModSimReloaded.getSavesDataFolder() + "Farming" + File.separator);
        farmFiles.mkdirs();
        boolean useNewFormat = false;
        for (File f : farmFiles.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            ModSimReloaded.theFarmingBoxes.clear();
            for (File f : farmFiles.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                FarmingBox box = new FarmingBox();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("location")) {
                        box.location = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m1")) {
                        if (value.contentEquals("null")) continue;
                        box.marker1XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m2")) {
                        if (value.contentEquals("null")) continue;
                        box.marker2XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m3")) {
                        if (value.contentEquals("null")) continue;
                        box.marker3XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("type")) {
                        box.farmType = FarmType.valueOf(value);
                        continue;
                    }
                    if (!name.contentEquals("level")) continue;
                    box.level = Integer.parseInt(value);
                }
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(box.location.theDimension);
                if (theWorld == null) continue;
                Block id = theWorld.func_147439_a(box.location.x.intValue(), box.location.y.intValue(), box.location.z.intValue());
                if (id == BlockLoader.blockFarmingBox) {
                    ModSimReloaded.theFarmingBoxes.add(box);
                    continue;
                }
                f.delete();
            }
        } else {
            for (File f : farmFiles.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                FarmingBox farming = (FarmingBox)ModSim.proxy.loadObject(f.getAbsoluteFile().toString());
                if (farming != null) {
                    V3 xyz = farming.location;
                    WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(xyz.theDimension);
                    if (theWorld == null) {
                        f.delete();
                        continue;
                    }
                    try {
                        Block id = theWorld.func_147439_a(xyz.x.intValue(), xyz.y.intValue(), xyz.z.intValue());
                        if (id == BlockLoader.blockFarmingBox) {
                            ModSimReloaded.theFarmingBoxes.add(farming);
                            continue;
                        }
                        f.delete();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                f.delete();
                String s = I18n.func_135052_a((String)"container.sim.farming_box_boxes", (Object[])new Object[0]);
                ModSimReloaded.sendChat(s);
            }
        }
    }

    public static void saveFarmingBoxes() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int b = 0; b < ModSimReloaded.theFarmingBoxes.size(); ++b) {
                FarmingBox farming = ModSimReloaded.theFarmingBoxes.get(b);
                strings.clear();
                if (farming == null || farming.location == null || farming.marker1XYZ == null) continue;
                try {
                    strings.add("location|" + farming.location.toString());
                    strings.add("m1|" + farming.marker1XYZ.toString());
                    strings.add("m2|" + farming.marker2XYZ.toString());
                    strings.add("m3|" + farming.marker3XYZ.toString());
                    strings.add("type|" + farming.farmType.name());
                    strings.add("level|" + farming.level);
                    String xyz = "f" + farming.location.toString().replaceAll(",", "_");
                    ModSimReloaded.saveSK2(ModSimReloaded.getSavesDataFolder() + "Farming" + File.separator + xyz + ".sk2", strings);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

