/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.block.functionality;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class MiningBox
implements Serializable {
    private static final long serialVersionUID = 2951402828966206500L;
    public V3 location;
    public V3 marker1XYZ;
    public V3 marker2XYZ;
    public V3 marker3XYZ;
    public int discards = 0;
    public boolean addGlassCover = true;
    public int size = 3;

    public MiningBox() {
    }

    public MiningBox(V3 location) {
        this.location = location;
    }

    public MiningBox(V3 inxyz, V3 m1xyz, V3 m2xyz, V3 m3xyz, int filterblocks, int size) {
        this.location = inxyz;
        this.marker1XYZ = m1xyz;
        this.marker2XYZ = m2xyz;
        this.marker3XYZ = m3xyz;
        try {
            this.discards = filterblocks;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.size = size;
    }

    public static MiningBox getMiningBlockByBoxXYZ(V3 location) {
        MiningBox block;
        int x;
        MiningBox ret = null;
        for (x = 0; x < ModSimReloaded.theMiningBoxes.size(); ++x) {
            block = ModSimReloaded.theMiningBoxes.get(x);
            if (!block.location.isSameCoordsAs(location, true, true)) continue;
            ret = block;
            break;
        }
        if (ret == null) {
            for (x = 0; x < ModSimReloaded.theMiningBoxes.size(); ++x) {
                block = ModSimReloaded.theMiningBoxes.get(x);
                if (!block.location.isSameCoordsAs(location, false, true)) continue;
                ret = block;
                break;
            }
        }
        return ret;
    }

    public static void loadMiningBoxes() {
        Minecraft mc = Minecraft.func_71410_x();
        File mineFiles = new File(ModSimReloaded.getSavesDataFolder() + "Mining" + File.separator);
        mineFiles.mkdirs();
        boolean useNewFormat = false;
        for (File f : mineFiles.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            ModSimReloaded.theMiningBoxes.clear();
            for (File f : mineFiles.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                MiningBox box = new MiningBox();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("location")) {
                        box.location = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m1")) {
                        if (value.contentEquals("null")) continue;
                        box.marker1XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m2")) {
                        if (value.contentEquals("null")) continue;
                        box.marker2XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("m3")) {
                        if (value.contentEquals("null")) continue;
                        box.marker3XYZ = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("discards")) {
                        box.discards = Integer.parseInt(value);
                        continue;
                    }
                    if (name.contentEquals("cover")) {
                        box.addGlassCover = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (!name.contentEquals("hsize")) continue;
                    box.size = Integer.parseInt(value);
                }
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(box.location.theDimension);
                if (theWorld == null) continue;
                Block id = theWorld.func_147439_a(box.location.x.intValue(), box.location.y.intValue(), box.location.z.intValue());
                if (id == BlockLoader.blockMiningBox) {
                    ModSimReloaded.theMiningBoxes.add(box);
                    continue;
                }
                f.delete();
            }
        } else {
            for (File f : mineFiles.listFiles()) {
                MiningBox mining;
                if (!f.getName().endsWith(".suk") || (mining = (MiningBox)ModSim.proxy.loadObject(f.getAbsoluteFile().toString())) == null) continue;
                V3 xyz = mining.location;
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(xyz.theDimension);
                if (theWorld == null) {
                    f.delete();
                    continue;
                }
                try {
                    Block id = theWorld.func_147439_a(xyz.x.intValue(), xyz.y.intValue(), xyz.z.intValue());
                    if (id == BlockLoader.blockMiningBox && mining != null) {
                        ModSimReloaded.theMiningBoxes.add(mining);
                        continue;
                    }
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void saveMiningBoxes() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int b = 0; b < ModSimReloaded.theMiningBoxes.size(); ++b) {
                try {
                    MiningBox mining = ModSimReloaded.theMiningBoxes.get(b);
                    strings.clear();
                    strings.add("location|" + mining.location.toString());
                    if (mining.marker1XYZ == null) continue;
                    strings.add("m1|" + mining.marker1XYZ.toString());
                    if (mining.marker2XYZ != null) {
                        strings.add("m2|" + mining.marker2XYZ.toString());
                    }
                    if (mining.marker3XYZ != null) {
                        strings.add("m3|" + mining.marker3XYZ.toString());
                    }
                    strings.add("discards|" + mining.discards);
                    strings.add("cover|" + mining.addGlassCover);
                    strings.add("hsize|" + mining.size);
                    String xyz = "m" + mining.location.toString().replaceAll(",", "_");
                    ModSimReloaded.saveSK2(ModSimReloaded.getSavesDataFolder() + "Mining" + File.separator + xyz + ".sk2", strings);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

