/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.entity;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.loader.ModSimReloaded;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;

public class CourierTask
implements Serializable {
    private static final long serialVersionUID = 1825349728277158061L;
    public String name = "";
    public String folkname = "";
    public V3 pickup = new V3();
    public V3 dropoff = new V3();
    public boolean repeat = true;

    public static V3 getCourierPoint(String name) {
        new V3();
        for (int x = 0; x < ModSimReloaded.theCourierPoints.size(); ++x) {
            V3 v = ModSimReloaded.theCourierPoints.get(x);
            if (!v.name.contentEquals(name)) continue;
            return v;
        }
        return null;
    }

    private static boolean alreadyGotTask(CourierTask theTask) {
        boolean got = false;
        for (int i = 0; i < ModSimReloaded.theCourierTasks.size(); ++i) {
            CourierTask checkTask = ModSimReloaded.theCourierTasks.get(i);
            try {
                if (!checkTask.pickup.name.contentEquals(theTask.name)) continue;
                got = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return got;
    }

    private static boolean alreadyGotPoint(V3 thePoint) {
        boolean got = false;
        for (int i = 0; i < ModSimReloaded.theCourierPoints.size(); ++i) {
            V3 checkPoint = ModSimReloaded.theCourierPoints.get(i);
            if (!checkPoint.isSameCoordsAs(thePoint, true, true)) continue;
            got = true;
            break;
        }
        return got;
    }

    public static void loadCourierTasksAndPoints() {
        ModSimReloaded.theCourierPoints.clear();
        ModSimReloaded.theCourierTasks.clear();
        File courierPoints = new File(ModSimReloaded.getSavesDataFolder() + "CourierPoints" + File.separator);
        courierPoints.mkdirs();
        File courierTasks = new File(ModSimReloaded.getSavesDataFolder() + "CourierTasks" + File.separator);
        courierTasks.mkdirs();
        boolean useNewFormat = false;
        for (File f : courierPoints.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            String value;
            String name;
            ArrayList<String> strings;
            int m1;
            File f;
            File[] listFiles = courierPoints.listFiles();
            int lengths = listFiles.length;
            for (m1 = 0; m1 < lengths; ++m1) {
                f = listFiles[m1];
                if (!f.getName().endsWith(".sk2")) continue;
                strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                V3 v = new V3();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    m1 = line.indexOf("|");
                    name = line.substring(0, m1);
                    value = line.substring(m1 + 1);
                    if (name.contentEquals("location")) {
                        v = new V3(value);
                        continue;
                    }
                    if (!name.contentEquals("name")) continue;
                    v.name = value;
                }
                if (v != null && !CourierTask.alreadyGotPoint(v)) {
                    ModSimReloaded.theCourierPoints.add(v);
                    continue;
                }
                f.delete();
            }
            listFiles = courierTasks.listFiles();
            lengths = listFiles.length;
            for (m1 = 0; m1 < lengths; ++m1) {
                f = listFiles[m1];
                if (!f.getName().endsWith(".sk2")) continue;
                strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                CourierTask ct = new CourierTask();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    m1 = line.indexOf("|");
                    name = line.substring(0, m1);
                    value = line.substring(m1 + 1);
                    if (name.contentEquals("folk")) {
                        ct.folkname = value;
                        continue;
                    }
                    if (name.contentEquals("pickup")) {
                        ct.pickup = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("dropoff")) {
                        if (value.contentEquals("null")) continue;
                        ct.dropoff = new V3(value);
                        continue;
                    }
                    if (name.contentEquals("repeat")) {
                        ct.repeat = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (!name.contentEquals("name")) continue;
                    ct.name = value;
                }
                if (!CourierTask.alreadyGotTask(ct) && ct != null && ct.dropoff != null && ct.pickup != null) {
                    ModSimReloaded.theCourierTasks.add(ct);
                    continue;
                }
                f.delete();
            }
        } else {
            for (File f : courierPoints.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                V3 point = (V3)ModSim.proxy.loadObject(f.getAbsoluteFile().toString());
                if (!CourierTask.alreadyGotPoint(point)) {
                    ModSimReloaded.theCourierPoints.add(point);
                    continue;
                }
                f.delete();
            }
            for (File f : courierTasks.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                CourierTask task = (CourierTask)ModSim.proxy.loadObject(f.getAbsoluteFile().toString());
                if (!CourierTask.alreadyGotTask(task)) {
                    ModSimReloaded.theCourierTasks.add(task);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void saveCourierTasksAndPoints() {
        String names = "";
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings;
            int mofo;
            for (mofo = 0; mofo < ModSimReloaded.theCourierPoints.size(); ++mofo) {
                strings = new ArrayList<String>();
                V3 point = ModSimReloaded.theCourierPoints.get(mofo);
                if (point == null) continue;
                ArrayList<IInventory> chests = Job.inventoriesFindClosest(point, 5);
                String fn = "cp" + point.x.intValue() + "_" + point.y.intValue() + "_" + point.z.intValue() + "_D" + point.theDimension;
                if (chests.size() > 0) {
                    if (names.contains(point.name)) continue;
                    names = names + " " + point.name;
                    strings.add("location|" + point.toString());
                    strings.add("name|" + point.name);
                    ModSimReloaded.saveSK2(ModSimReloaded.getSavesDataFolder() + "CourierPoints" + File.separator + fn + ".sk2", strings);
                    continue;
                }
                try {
                    File fi = new File(ModSimReloaded.getSavesDataFolder() + "CourierPoints" + File.separator + fn + ".sk2");
                    fi.delete();
                    continue;
                }
                catch (Exception fi) {
                    // empty catch block
                }
            }
            for (mofo = 0; mofo < ModSimReloaded.theCourierTasks.size(); ++mofo) {
                strings = new ArrayList();
                CourierTask task = ModSimReloaded.theCourierTasks.get(mofo);
                String fn = "ct" + mofo + task.folkname.replace(" ", "");
                boolean okToSave = true;
                strings.add("folk|" + task.folkname);
                strings.add("pickup|" + task.pickup.toString());
                if (task.dropoff == null) {
                    strings.add("dropoff|null");
                } else {
                    try {
                        strings.add("dropoff|" + task.dropoff.toString());
                    }
                    catch (Exception var8) {
                        okToSave = false;
                    }
                }
                strings.add("repeat|" + task.repeat);
                strings.add("name|" + task.name);
                if (!okToSave) continue;
                ModSimReloaded.saveSK2(ModSimReloaded.getSavesDataFolder() + "CourierTasks" + File.separator + fn + ".sk2", strings);
            }
        }
    }
}

