/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.entity;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.EntityFolk;
import com.trhsy.sim.common.entity.Relationship;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.JobBaker;
import com.trhsy.sim.common.jobs.JobBrickMaker;
import com.trhsy.sim.common.jobs.JobBuilder;
import com.trhsy.sim.common.jobs.JobBuildersMerchant;
import com.trhsy.sim.common.jobs.JobBurgersFryCook;
import com.trhsy.sim.common.jobs.JobBurgersManager;
import com.trhsy.sim.common.jobs.JobBurgersWaiter;
import com.trhsy.sim.common.jobs.JobButcher;
import com.trhsy.sim.common.jobs.JobCheesemaker;
import com.trhsy.sim.common.jobs.JobCourier;
import com.trhsy.sim.common.jobs.JobCropFarmer;
import com.trhsy.sim.common.jobs.JobDairyFarmer;
import com.trhsy.sim.common.jobs.JobEggFarmer;
import com.trhsy.sim.common.jobs.JobFisherman;
import com.trhsy.sim.common.jobs.JobGlassMaker;
import com.trhsy.sim.common.jobs.JobGrocer;
import com.trhsy.sim.common.jobs.JobLivestockFarmer;
import com.trhsy.sim.common.jobs.JobLumberjack;
import com.trhsy.sim.common.jobs.JobMiner;
import com.trhsy.sim.common.jobs.JobShepherd;
import com.trhsy.sim.common.jobs.JobSoldier;
import com.trhsy.sim.common.jobs.JobTerraformer;
import com.trhsy.sim.common.jobs.TerraformerType;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ConfigLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import com.trhsy.sim.packets.client.UpdateFolkPositionMessage;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Logger;

public class FolkData
implements Serializable {
    private static final long serialVersionUID = -2617939828256928361L;
    public static Logger log;
    public V3 employedAt = null;
    public Vocation vocation = null;
    public transient Job theirJob = null;
    public String name = "";
    public int age = 18;
    public int gender = 0;
    public int skinnumber = 1;
    public int levelFood = 10;
    public int levelFun = 5;
    public float levelBuilder = 1.0f;
    public float levelMiner = 1.0f;
    public float levelSoldier = 1.0f;
    public FolkAction action = FolkAction.WANDER;
    public FolkAction actionArrival = null;
    public Boolean stayPut = false;
    public V3 destination = null;
    public V3 location = null;
    public String statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
    public String status1 = "";
    public String status2 = "";
    public String status3 = "";
    public String status4 = "";
    public String status5 = "";
    public float shaggingStage = 0.0f;
    public float pregnancyStage = 0.0f;
    public transient boolean isWorking = false;
    public boolean greetedToday = false;
    public static transient long anyFolkLastSpoke;
    public Building theBuilding = null;
    public TerraformerType terraformerType = null;
    public int terraformerRadius = 1;
    public transient ArrayList<ItemStack> inventory = new ArrayList();
    public transient EntityFolk theEntity = null;
    public transient Long timeStartedGotoing = 0L;
    public transient GotoMethod gotoMethod = null;
    private transient long timeSinceLastSave = 0L;
    private transient long timeSinceLastStatusUpdate = 0L;
    private transient long timeSinceLastMinute = 0L;
    public transient V3 beamingTo = null;
    private transient FolkData hangingWith = null;
    private transient int talkCounter = 0;
    protected transient float matingStage = -1.0f;
    private transient int entityId;

    public FolkData() {
    }

    public void hasLoaded() {
        String voc = "none";
        String vocat = "";
        if (this.vocation != null && this.employedAt != null) {
            voc = this.vocation.toString();
            vocat = this.employedAt.toString();
        }
        if (this.employedAt == null) {
            this.vocation = null;
        }
        if (this.vocation == null) {
            this.employedAt = null;
        }
        if (this.levelMiner < 1.0f) {
            this.levelMiner = 1.0f;
        }
        if (this.levelBuilder < 1.0f) {
            this.levelBuilder = 1.0f;
        }
        if (this.levelSoldier < 1.0f) {
            this.levelSoldier = 1.0f;
        }
        try {
            ModSimReloaded.log.info("FolkData: hasLoaded() " + this.name + " (" + voc + ") at " + vocat + " location= " + this.location.toString() + "  " + ModSimReloaded.theFolks.size() + " \u6240\u6709\u4eba");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inventory = new ArrayList();
        this.setTheirJob(this.vocation);
        this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
        ModSimReloaded.theFolks.add(this);
    }

    public FolkData(World theWorld) {
        Random rand = new Random();
        this.gender = rand.nextInt(2);
        this.name = FolkData.generateName(this.gender, false, "");
        this.age = 18;
        this.skinnumber = this.gender == 0 ? rand.nextInt(64) : rand.nextInt(64);
        this.location = this.getLocationCloseToPlayer();
        if (this.location != null) {
            this.respawnEntity(theWorld);
            ModSimReloaded.theFolks.add(this);
            String just = I18n.func_135052_a((String)"container.sim.folk_data_just", (Object[])new Object[0]);
            ModSimReloaded.sendChat(this.name + just);
        }
    }

    public FolkData(World theWorld, FolkData mother, FolkData father) {
        EntityClientPlayerMP p;
        Random rand = new Random();
        String surname = "Unknown";
        if (father != null) {
            surname = father.name.substring(father.name.indexOf(" ") + 1).trim();
        } else if (mother != null) {
            surname = mother.name.substring(mother.name.indexOf(" ") + 1).trim();
        }
        this.gender = rand.nextInt(2);
        this.name = FolkData.generateName(this.gender, true, surname) + " " + surname;
        this.age = 0;
        this.skinnumber = this.gender == 0 ? rand.nextInt(63) + 1 : rand.nextInt(63) + 1;
        if (mother.getHome() != null) {
            mother.getHome().tenants.add(this.name);
        }
        mother.updateLocationFromEntity();
        World mworld = null;
        if (mother.isSpawned()) {
            mworld = mother.theEntity.field_70170_p;
        }
        this.location = Job.findAdjacentSpace(mother.location, mworld);
        this.respawnEntity(theWorld);
        ModSimReloaded.theFolks.add(this);
        String born = I18n.func_135052_a((String)"container.sim.folk_data_born", (Object[])new Object[0]);
        ModSimReloaded.sendChat(this.name + born);
        World world = ModSim.proxy.getClientWorld();
        if (world != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
            ModSim.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "sim:birth", 1.0f, 1.0f, false);
        }
        Relationship.setupBloodRelationships(this, father, mother);
        try {
            this.levelBuilder = (float)Math.floor(father.levelBuilder / 2.0f) + (float)Math.floor(mother.levelBuilder / 2.0f);
            if (this.levelBuilder > 10.0f) {
                this.levelBuilder = 10.0f;
            }
            this.levelMiner = (float)Math.floor(father.levelMiner / 2.0f) + (float)Math.floor(mother.levelMiner / 2.0f);
            if (this.levelMiner > 10.0f) {
                this.levelMiner = 10.0f;
            }
            this.levelSoldier = (float)Math.floor(father.levelSoldier / 2.0f) + (float)Math.floor(mother.levelSoldier / 2.0f);
            if (this.levelSoldier > 10.0f) {
                this.levelSoldier = 10.0f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLocationFromEntity() {
        if (this.isSpawned()) {
            this.location = new V3(this.theEntity.field_70165_t, this.theEntity.field_70163_u, this.theEntity.field_70161_v, this.location.theDimension);
        }
    }

    public void respawnEntity(World world) {
        if (world != null && this.beamingTo == null && (this.theEntity == null || this.theEntity.field_70128_L) && this.getDistanceToPlayer() < 50) {
            this.theEntity = new EntityFolk(world);
            this.theEntity.func_70012_b(this.location.x, this.location.y, this.location.z, 0.0f, 0.0f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)this.theEntity);
            }
            this.entityId = this.theEntity.func_145782_y();
            ModSimReloaded.log.info("FolkData:repawnEntity() " + this.name + " \u5728 " + this.location.toString() + " \u660f\u6697\u4e2d " + this.location.theDimension + " ENTITY:" + this.theEntity.func_145782_y());
        }
    }

    public static void triggerAllUpdates() {
        for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
            FolkData fd = ModSimReloaded.theFolks.get(f);
            fd.onUpdate();
        }
    }

    public void serverToClientLocationUpdate(V3 newLocation) {
        this.location = newLocation.clone();
        if (this.theEntity != null) {
            newLocation.x = Math.floor(newLocation.x) + 0.5;
            newLocation.z = Math.floor(newLocation.z) + 0.5;
            this.theEntity.field_70165_t = newLocation.x;
            this.theEntity.field_70163_u = newLocation.y;
            this.theEntity.field_70161_v = newLocation.z;
        }
    }

    public void onUpdate() {
        FolkData male;
        Random rand = new Random();
        Long now = System.currentTimeMillis();
        if (now - this.timeSinceLastMinute > 60000L) {
            long t;
            if (this.getHome() == null && this.timeSinceLastMinute > 0L) {
                this.getHomeForHomeless();
            }
            if ((t = MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L) < 2000L && this.pregnancyStage >= 1.0f) {
                for (Building build : ModSimReloaded.theBuildings) {
                    if (build == null || build.primaryXYZ == null || !build.displayName.contains("Clinic") || this.destination != null || build.blockSpecial.isEmpty()) continue;
                    V3 bed = build.blockSpecial.get(0);
                    this.gotoXYZ(bed, null);
                    String baby = I18n.func_135052_a((String)"container.sim.folk_data_baby", (Object[])new Object[0]);
                    ModSimReloaded.sendChat(this.name + baby);
                }
                this.action = FolkAction.HAVINGBABY;
            } else if (t > 2000L && this.pregnancyStage >= 1.0f) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_a_baby", (Object[])new Object[0]);
                this.pregnancyStage = 0.0f;
                male = Relationship.isFolkLivingWithSomeone(this, true);
                new FolkData((World)MinecraftServer.func_71276_C().func_71218_a(0), this, male);
            }
            if (this.action == FolkAction.ATHOME || this.action == FolkAction.STAYINGHOME) {
                this.updateLocationFromEntity();
                try {
                    V3 liveAt = null;
                    if (this.getHome().livingXYZ != null) {
                        liveAt = this.getHome().livingXYZ.clone();
                    }
                    if (liveAt == null) {
                        liveAt = this.getHome().primaryXYZ.clone();
                    }
                    if (this.location.getDistanceTo(liveAt) > 5 && this.destination == null || this.location.theDimension != this.getHome().primaryXYZ.theDimension) {
                        this.actionArrival = this.action;
                        if (liveAt != null) {
                            this.gotoXYZ(liveAt, GotoMethod.WALK);
                        }
                    }
                }
                catch (Exception var16) {
                    ModSimReloaded.log.info("\u6a21\u62df\u57ce\u9547\u7684\u5173\u952e\u5f02\u5e38:" + var16.getMessage());
                }
            }
            boolean gotWanderPoint = false;
            if (this.action == FolkAction.WANDER && this.isSpawned() && this.employedAt == null && this.age >= 18 && !this.statusText.contains(I18n.func_135052_a((String)"container.sim.folk_data.baby", (Object[])new Object[0]))) {
                int xo;
                for (xo = 0; xo < ModSimReloaded.theBuildings.size(); ++xo) {
                    Building b = ModSimReloaded.theBuildings.get(rand.nextInt(ModSimReloaded.theBuildings.size()));
                    double dist = this.location.getDistanceTo(b.primaryXYZ);
                    if (b.type.contentEquals("commercial") && dist < 40.0) {
                        boolean hasShopKeeper = false;
                        for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
                            FolkData keeper = ModSimReloaded.theFolks.get(f);
                            if (keeper.employedAt == null || !keeper.employedAt.isSameCoordsAs(b.primaryXYZ, true, true)) continue;
                            hasShopKeeper = true;
                            break;
                        }
                        if (!hasShopKeeper) continue;
                        ModSimReloaded.log.info("FolkData:onUpdate() " + this.name + " \u5f98\u5f8a\u5728 " + b.displayName + " " + dist + " \u4e2a\u8857\u533a\u4e4b\u5916\u3002");
                        this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        this.destination.doNotTimeout = true;
                        this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Shopping", (Object[])new Object[0]) + b.displayName;
                        gotWanderPoint = true;
                        if (this.hangingWith == null) break;
                        this.hangingWith.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                        this.hangingWith.hangingWith = null;
                        this.hangingWith = null;
                        break;
                    }
                    if (b.type.contentEquals("industrial") && dist < 40.0 && !b.displayName.toLowerCase().contains("farm")) {
                        try {
                            ModSimReloaded.log.info("FolkData: onUpdate() " + this.name + "\u5f98\u5f8a\u5728" + b.displayName + " " + dist + " \u4e2a\u8857\u533a\u4e4b\u5916\u3002");
                            this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                            this.destination.doNotTimeout = true;
                            this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Visiting", (Object[])new Object[0]) + b.displayName;
                            gotWanderPoint = true;
                        }
                        catch (Exception hasShopKeeper) {
                            // empty catch block
                        }
                        if (this.hangingWith == null) break;
                        this.hangingWith.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                        this.hangingWith.hangingWith = null;
                        this.hangingWith = null;
                        break;
                    }
                    if (!b.type.contentEquals("residential") || !(dist < 40.0) || this.hangingWith != null || b.tenants == null || b.tenants.size() <= 0) continue;
                    FolkData resy = FolkData.getFolkByName(b.tenants.get(0));
                    try {
                        if (resy.name.contentEquals(this.name) || resy.hangingWith != null || resy.action != FolkAction.WANDER && resy.action != FolkAction.STAYINGHOME) continue;
                        ModSimReloaded.log.info("FolkData:onUpdate() " + this.name + " \u5f98\u5f8a\u5728 " + b.displayName + " " + dist + " \u4e2a\u8857\u533a\u4e4b\u5916\u3002");
                        this.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        gotWanderPoint = true;
                        String hanging = I18n.func_135052_a((String)"container.sim.folk_data_Hanging", (Object[])new Object[0]);
                        this.statusText = hanging + resy.name;
                        resy.gotoXYZ(b.primaryXYZ, GotoMethod.WALK);
                        if (this.destination != null) {
                            this.destination.doNotTimeout = true;
                        }
                        resy.statusText = hanging + this.name;
                        this.hangingWith = resy;
                        resy.hangingWith = this;
                        break;
                    }
                    catch (Exception hanging) {
                        // empty catch block
                    }
                }
                if (!gotWanderPoint) {
                    xo = rand.nextInt(60) - 30;
                    int zo = rand.nextInt(60) - 30;
                    V3 wanderTo = new V3(this.location.x + (double)xo, this.location.y, this.location.z + (double)zo, this.location.theDimension);
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension);
                    while (world.func_147439_a(wanderTo.x.intValue(), wanderTo.y.intValue(), wanderTo.z.intValue()) != null && wanderTo.y < 255.0) {
                        Double hanging = wanderTo.y;
                        Double var40 = wanderTo.y = Double.valueOf(wanderTo.y + 1.0);
                    }
                    ModSimReloaded.log.info("FolkData:onUpdate() \u6f2b\u6e38\u547d\u4ee4 " + this.name + " to " + wanderTo.toString());
                    this.gotoXYZ(wanderTo, GotoMethod.WALK);
                    if (this.destination != null) {
                        this.destination.doNotTimeout = true;
                    }
                    this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                    this.stayPut = false;
                }
            } else if (this.action == FolkAction.WANDER && this.isSpawned() && this.age < 18 && (male = Relationship.getMotherOf(this)) != null) {
                this.gotoXYZ(male.location, null);
            }
            if (this.hangingWith != null && !this.hangingWith.statusText.contains(this.name)) {
                this.hangingWith = null;
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
            }
            if (!ModSimReloaded.isDayTime() && Relationship.isFolkLivingWithSomeone(this) && this.matingStage < 0.0f) {
                this.tryForBaby();
            }
            this.timeSinceLastMinute = now - (long)rand.nextInt(20000);
        }
        if (now - this.timeSinceLastStatusUpdate > 1000L) {
            int chance;
            this.updateStatusLines();
            if (this.statusText.contentEquals(I18n.func_135052_a((String)"container.sim.gui.button_Going", (Object[])new Object[0]))) {
                this.stayPut = false;
            }
            if (!this.isSpawned()) {
                int range = this.getDistanceToPlayer();
                if (range < 50) {
                    this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
                }
            } else {
                this.theEntity.field_71093_bK = this.location.theDimension;
                this.updateLocationFromEntity();
                int range = this.getDistanceToPlayer();
                if (range >= 50 && this.theEntity != null) {
                    ModSimReloaded.log.info("FolkData: onSecTasks - \u624b\u52a8\u5265\u79bb " + this.name + " \u56e0\u4e3a\u5b83\u4eec\u8ddd\u79bb " + range + " \u8857\u533a\u8fdc");
                    this.theEntity.func_70106_y();
                }
            }
            if (ModSimReloaded.isDayTime() && this.employedAt != null && this.action != FolkAction.ONWAYTOWORK && this.action != FolkAction.ATWORK && this.pregnancyStage == 0.0f) {
                ModSimReloaded.log.info("FolkData: " + this.name + " \u8981\u5de5\u4f5c\u4e86");
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Going_work", (Object[])new Object[0]);
                this.action = FolkAction.ONWAYTOWORK;
                this.gotoXYZ(this.employedAt, null);
                return;
            }
            if (this.pregnancyStage > 0.0f && this.employedAt != null && ModSimReloaded.isDayTime()) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Maternity_leave", (Object[])new Object[0]);
            }
            if (ModSimReloaded.isDayTime() && this.employedAt != null && this.action != FolkAction.ATWORK && this.destination == null && this.pregnancyStage == 0.0f) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Going_work", (Object[])new Object[0]);
                this.action = FolkAction.ONWAYTOWORK;
                this.updateLocationFromEntity();
                V3 temp = this.employedAt.clone();
                temp = new V3(temp.x + 5.0, temp.y, temp.z, temp.theDimension);
                this.gotoXYZ(temp, GotoMethod.SHIFT);
                this.gotoXYZ(this.employedAt, null);
                return;
            }
            if (this.action == FolkAction.ONWAYTOWORK) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Going_work", (Object[])new Object[0]);
                this.stayPut = false;
                if (this.destination == null) {
                    this.gotoXYZ(this.employedAt, null);
                }
            }
            if (this.action == FolkAction.STAYINGHOME && this.hangingWith == null) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Staying_home", (Object[])new Object[0]);
                this.stayPut = true;
            }
            if (ModSimReloaded.isDayTime() && this.statusText.contains(I18n.func_135052_a((String)"container.sim.folk_data.for_a_baby", (Object[])new Object[0]))) {
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                this.action = FolkAction.WANDER;
            }
            if (this.action == FolkAction.HAVINGBABY) {
                this.statusText = this.pregnancyStage < 1.0f ? I18n.func_135052_a((String)"container.sim.folk_data_a_baby", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folk_data_Having_baby", (Object[])new Object[0]);
            }
            if (ModSimReloaded.isDayTime() && this.employedAt == null && this.action == FolkAction.ATHOME) {
                this.isWorking = false;
                if (new Random().nextInt(4) == 1) {
                    this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Staying_home", (Object[])new Object[0]);
                    this.action = FolkAction.STAYINGHOME;
                } else {
                    this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                    this.action = FolkAction.WANDER;
                }
            }
            if (this.action == FolkAction.STAYINGHOME && this.employedAt != null) {
                this.action = FolkAction.WANDER;
            }
            boolean isSoldier = false;
            if (this.vocation != null && this.vocation == Vocation.SOLDIER) {
                isSoldier = true;
            }
            if (!ModSimReloaded.isDayTime() && !isSoldier) {
                this.action = FolkAction.WANDER;
                this.isWorking = false;
                if (this.getHome() == null) {
                    this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
                    this.stayPut = false;
                } else {
                    if (this.gotoMethod == GotoMethod.WALK) {
                        this.updateLocationFromEntity();
                    }
                    V3 liveAt = null;
                    try {
                        Building home = this.getHome();
                        if (home != null) {
                            liveAt = home.livingXYZ == null ? this.getHome().primaryXYZ.clone() : this.getHome().livingXYZ.clone();
                        }
                    }
                    catch (Exception var13) {
                        ModSimReloaded.log.warning(this.name + " \u6ca1\u6709\u4f4f\u5728" + var13.getMessage());
                    }
                    if (liveAt != null) {
                        chance = this.location.getDistanceTo(liveAt);
                        if (chance > 1 && this.destination == null) {
                            this.stayPut = false;
                            liveAt = new V3(liveAt.x + 1.0, liveAt.y + 1.0, liveAt.z, liveAt.theDimension);
                            this.gotoXYZ(liveAt, null);
                            this.action = FolkAction.GOINGHOME;
                            this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Going_home", (Object[])new Object[0]);
                            this.isWorking = false;
                        }
                        if (chance <= 1 && !this.statusText.contains(I18n.func_135052_a((String)"container.sim.folk_data.baby", (Object[])new Object[0]))) {
                            this.stayPut = true;
                            this.action = FolkAction.ATHOME;
                            this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Relaxing_home", (Object[])new Object[0]);
                            this.isWorking = false;
                        }
                    }
                }
            } else {
                this.stayPut = false;
            }
            if (this.action == FolkAction.WANDER) {
                this.stayPut = false;
            }
            int about10 = rand.nextInt(10000) + 10000;
            if (System.currentTimeMillis() - this.timeSinceLastSave > (long)about10) {
                Side side = FMLCommonHandler.instance().getEffectiveSide();
                if (side == Side.SERVER) {
                    ModSim.network.sendToServer((IMessage)new UpdateFolkPositionMessage(this.location.toString() + ";" + this.name));
                    this.saveThisFolk();
                }
                this.timeSinceLastSave = System.currentTimeMillis();
            }
            if ((this.statusText.startsWith("Hanging out ") || this.statusText.startsWith("Shopping at the ")) && this.destination == null && this.theEntity != null) {
                ++this.talkCounter;
                if (this.talkCounter == 12) {
                    if (ConfigLoader.configFolkTalking) {
                        chance = rand.nextInt(26) + 97;
                        String letter = "sim:blarg" + Character.toString((char)chance);
                        ModSim.proxy.getClientWorld().func_72980_b(this.location.x.doubleValue(), this.location.y.doubleValue(), this.location.z.doubleValue(), letter, 1.0f, 1.0f, false);
                    }
                    this.talkCounter = 0;
                    if (this.hangingWith != null) {
                        Relationship.meddleWithRelationship(this, this.hangingWith);
                    }
                }
            }
            if (this.matingStage >= 0.0f && this.matingStage < 1.0f && this.gender == 1 && this.pregnancyStage == 0.0f) {
                if (ModSimReloaded.isDayTime()) {
                    this.matingStage = -1.0f;
                } else {
                    male = Relationship.isFolkLivingWithSomeone(this, true);
                    if (male != null) {
                        this.matingStage += 0.02f;
                        if (this.isSpawned()) {
                            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
                            double d0 = rand.nextDouble() * 0.5;
                            double d1 = rand.nextDouble() * 0.5;
                            double d2 = rand.nextDouble() * 0.5;
                            theWorld.func_72869_a("heart", this.theEntity.field_70165_t, this.theEntity.field_70163_u + 2.1, this.theEntity.field_70161_v, d0, d1, d2);
                            male.updateLocationFromEntity();
                            if ((double)this.matingStage < 0.15) {
                                this.gotoXYZ(male.location, GotoMethod.SHIFT);
                            }
                            theWorld.func_72869_a("heart", male.location.x.doubleValue(), male.location.y + 2.1, male.location.z.doubleValue(), d0, d1, d2);
                            this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Trying_baby", (Object[])new Object[0]);
                            male.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Trying_baby", (Object[])new Object[0]);
                            male.stayPut = true;
                        }
                    }
                }
            } else if (this.matingStage >= 1.0f && this.matingStage < 1.1f) {
                this.matingStage = 1.1f;
                chance = rand.nextInt(7);
                ModSimReloaded.log.info("FolkData: \u5b8c\u6210\u4e86\u5a74\u513f\u673a\u4f1a\u7684\u5c1d\u8bd5=" + chance);
                male = Relationship.isFolkLivingWithSomeone(this, true);
                this.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Relaxing_home", (Object[])new Object[0]);
                male.statusText = I18n.func_135052_a((String)"container.sim.folk_data_Relaxing_home", (Object[])new Object[0]);
                if (chance == 1 && this.age < 45) {
                    EntityClientPlayerMP p;
                    World world;
                    this.pregnancyStage = 0.1f;
                    String news = I18n.func_135052_a((String)"container.sim.folk_data_Good_news", (Object[])new Object[0]);
                    String and = I18n.func_135052_a((String)"container.sim.folk_data_and", (Object[])new Object[0]);
                    String expecting_a_baby = I18n.func_135052_a((String)"container.sim.folk_data_expecting_a_baby", (Object[])new Object[0]);
                    ModSimReloaded.sendChat(news + this.name + and + male.name + expecting_a_baby);
                    if (this.isSpawned()) {
                        this.theEntity.func_70637_d(true);
                    }
                    if (male.isSpawned()) {
                        male.theEntity.func_70637_d(true);
                    }
                    if ((world = ModSim.proxy.getClientWorld()) != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
                        ModSim.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "sim:pregnant", 1.0f, 1.0f, false);
                    }
                }
            }
            this.timeSinceLastStatusUpdate = now;
        }
        if (this.beamingTo != null) {
            this.doBeaming();
        }
        if (this.theirJob != null) {
            this.theirJob.onUpdate();
        }
    }

    private void tryForBaby() {
        if (this.gender == 1 && this.pregnancyStage == 0.0f) {
            FolkData malePartner = Relationship.isFolkLivingWithSomeone(this, true);
            if (malePartner != null && this.action == FolkAction.ATHOME && malePartner.action == FolkAction.ATHOME) {
                this.matingStage = 0.0f;
                if (malePartner.isSpawned()) {
                    this.gotoXYZ(new V3(malePartner.theEntity.field_70165_t, malePartner.theEntity.field_70163_u, malePartner.theEntity.field_70161_v, malePartner.theEntity.field_71093_bK), GotoMethod.WALK);
                }
            }
        } else {
            this.matingStage = -1.0f;
        }
    }

    private void getHomeForHomeless() {
        if (this.action == FolkAction.WANDER) {
            Building.loadAllBuildings();
            for (int b = 0; b < ModSimReloaded.theBuildings.size(); ++b) {
                V3 v3;
                Building building = ModSimReloaded.theBuildings.get(b);
                if (building.tenants.size() != 0 || !building.buildingComplete || !building.type.contentEquals("residential")) continue;
                building.tenants.add(this.name);
                this.action = FolkAction.GOINGHOME;
                this.actionArrival = FolkAction.STAYINGHOME;
                if (building.livingXYZ != null) {
                    v3 = new V3(building.livingXYZ.x + 1.0, building.livingXYZ.y + 1.0, building.livingXYZ.z, building.livingXYZ.theDimension);
                    this.gotoXYZ(v3, null);
                } else {
                    v3 = new V3(building.primaryXYZ.x + 1.0, building.primaryXYZ.y + 1.0, building.primaryXYZ.z, building.primaryXYZ.theDimension);
                    this.gotoXYZ(v3, null);
                }
                ModSimReloaded.states.saveStates();
                String moving = I18n.func_135052_a((String)"container.sim.folk_data_moving", (Object[])new Object[0]);
                String Moved = I18n.func_135052_a((String)"container.sim.folk_data_Moved", (Object[])new Object[0]);
                ModSimReloaded.sendChat(this.name + moving + building.displayNameWithoutPK);
                this.statusText = Moved + building.displayNameWithoutPK;
                Building.saveAllBuildings();
                break;
            }
        }
    }

    private void updateStatusLines() {
        if (this.vocation == null) {
            this.status1 = I18n.func_135052_a((String)"container.sim.folkData1", (Object[])new Object[0]);
        } else {
            try {
                this.status1 = this.vocation.toString();
            }
            catch (Exception var2) {
                this.status1 = "";
            }
        }
        this.status2 = this.getHome() != null ? I18n.func_135052_a((String)"container.sim.folkData2", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folkData3", (Object[])new Object[0]);
        this.status3 = !Relationship.isFolkLivingWithSomeone(this) ? I18n.func_135052_a((String)"container.sim.folkData4", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folkData5", (Object[])new Object[0]);
        this.status4 = this.levelFood == 10 ? I18n.func_135052_a((String)"container.sim.folkData6", (Object[])new Object[0]) : (this.levelFood > 5 ? I18n.func_135052_a((String)"container.sim.folkData7", (Object[])new Object[0]) : (this.levelFood > 1 ? I18n.func_135052_a((String)"container.sim.folkData8", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folkData9", (Object[])new Object[0])));
        this.status5 = this.levelFun == 10 ? I18n.func_135052_a((String)"container.sim.folkData10", (Object[])new Object[0]) : (this.levelFun > 5 ? I18n.func_135052_a((String)"container.sim.folkData11", (Object[])new Object[0]) : (this.levelFun > 1 ? I18n.func_135052_a((String)"container.sim.folkData12", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folkData13", (Object[])new Object[0])));
    }

    public boolean isSpawned() {
        if (this.theEntity == null) {
            try {
                this.theEntity = FolkData.getFolkByName((String)this.name).theEntity;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.theEntity == null) {
            return false;
        }
        return !this.theEntity.field_70128_L;
    }

    public int getDistanceToPlayer() {
        EntityPlayer p = FolkData.getClosestPlayer(this.location);
        if (p == null) {
            return 9999;
        }
        V3 pv = new V3(p.field_70165_t, p.field_70163_u, p.field_70161_v, this.location.theDimension);
        return this.location.getDistanceTo(pv);
    }

    public V3 getLocationCloseToPlayer() {
        V3 ret;
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        try {
            ret = new V3(p.field_70165_t, 5.0, p.field_70161_v, p.field_71093_bK);
        }
        catch (Exception var9) {
            ModSimReloaded.log.warning("getLocationCloseToPlayer: \u73a9\u5bb6\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7aV3" + var9.getMessage());
            return new V3(0.0, 5.0, 0.0, 0);
        }
        boolean found = false;
        try {
            for (int go = 30; go > 1; --go) {
                ret = new V3(p.field_70165_t, 5.0, p.field_70161_v + (double)go, p.field_71093_bK);
                while (!found) {
                    Block bid = p.field_70170_p.func_147439_a(ret.x.intValue(), ret.y.intValue(), ret.z.intValue());
                    if ((p.field_70170_p.func_72937_j(ret.x.intValue(), ret.y.intValue(), ret.z.intValue()) || p.field_71093_bK != 0) && bid != Blocks.field_150362_t && bid == null) {
                        found = true;
                    }
                    Double var7 = ret.y;
                    Double var8 = ret.y = Double.valueOf(ret.y + 1.0);
                    if (!(ret.y > 200.0)) continue;
                    break;
                }
                if (!found) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !found ? new V3(0.0, 5.0, 0.0, 0) : ret;
    }

    public static EntityPlayer getClosestPlayer(V3 location) {
        try {
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(location.theDimension);
            EntityPlayer ret = world.func_72977_a(location.x.doubleValue(), location.y.doubleValue(), location.z.doubleValue(), 60.0);
            return ret;
        }
        catch (Exception var3) {
            return null;
        }
    }

    public static String generateName(int gender, boolean firstNameOnly, String lastNameOptional) {
        String name;
        block3: {
            int i;
            Random randomGenerator = new Random();
            String firstName = "";
            String lastName = "";
            FolkData test = null;
            name = "";
            int go = 0;
            if (go >= 200) break block3;
            if (gender == 0) {
                i = randomGenerator.nextInt(ConfigLoader.configMaleNames.length);
                firstName = ConfigLoader.configMaleNames[i].trim();
            } else {
                i = randomGenerator.nextInt(ConfigLoader.configFemaleNames.length);
                firstName = ConfigLoader.configFemaleNames[i].trim();
            }
            i = randomGenerator.nextInt(ConfigLoader.configSurnames.length);
            lastName = lastName.contentEquals("") ? ConfigLoader.configSurnames[i].trim() : lastNameOptional;
            String lang = FMLCommonHandler.instance().getCurrentLanguage();
            name = "en_US".equals(lang) ? firstName + " " + lastName : lastName + firstName;
            test = FolkData.getFolkByName(name);
            if (test != null) {
                name = name + " II";
            }
        }
        return name;
    }

    public void selfFire() {
        ModSimReloaded.log.info("FolkData: selfFire() " + this.name);
        this.isWorking = false;
        if (this.inventory.size() > 0) {
            int count = 0;
            for (int inv = 0; inv < this.inventory.size(); ++inv) {
                ItemStack is = this.inventory.get(inv);
                if (is == null) continue;
                if (this.theEntity != null) {
                    try {
                        this.theEntity.func_70099_a(is, is.field_77994_a);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        FolkData.getClosestPlayer(this.location).func_70099_a(is, (float)is.field_77994_a);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                count += is.field_77994_a;
            }
            if (count > 0) {
                String has_dropped = I18n.func_135052_a((String)"container.sim.folk_data_has_dropped", (Object[])new Object[0]);
                String inventory = I18n.func_135052_a((String)"container.sim.folk_data_inventory", (Object[])new Object[0]);
                ModSimReloaded.sendChat(this.name + has_dropped + count + inventory);
            }
        }
        this.inventory.clear();
        if (this.theEntity != null) {
            this.theEntity.field_70733_aJ = 0.0f;
            this.theEntity.func_70661_as().func_75499_g();
        }
        this.employedAt = null;
        if (this.vocation == Vocation.BUILDER) {
            this.theBuilding = null;
        }
        this.vocation = null;
        this.theirJob = null;
        this.action = FolkAction.WANDER;
        this.statusText = I18n.func_135052_a((String)"container.sim.folk_data.Wandering", (Object[])new Object[0]);
        this.stayPut = false;
        this.saveThisFolk();
    }

    public void gotoXYZ(V3 whereTo, GotoMethod methodOfTravel) {
        if (whereTo != null) {
            this.stayPut = false;
            this.destination = whereTo.clone();
            if (this.destination != null) {
                this.destination.doNotTimeout = false;
                int dist = this.location.getDistanceTo(whereTo);
                if (!this.isSpawned()) {
                    methodOfTravel = null;
                }
                if (methodOfTravel == null) {
                    V3 playpos = null;
                    try {
                        EntityPlayer pl = FolkData.getClosestPlayer(this.location);
                        if (pl != null && this.location.theDimension == this.destination.theDimension) {
                            playpos = new V3(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, pl.field_71093_bK);
                        } else {
                            dist = 999;
                        }
                    }
                    catch (Exception var11) {
                        dist = 999;
                    }
                    if (dist < 40) {
                        this.gotoMethod = GotoMethod.WALK;
                    }
                    if (!this.isSpawned() || dist >= 40) {
                        this.gotoMethod = GotoMethod.BEAM;
                    }
                    if (playpos != null) {
                        if (this.location.getDistanceTo(playpos) >= 40 && whereTo.getDistanceTo(playpos) >= 40) {
                            this.gotoMethod = GotoMethod.SHIFT;
                        }
                        try {
                            if (this.location.theDimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK && this.destination.theDimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
                                this.gotoMethod = GotoMethod.SHIFT;
                            }
                        }
                        catch (Exception var10) {
                            this.gotoMethod = GotoMethod.SHIFT;
                        }
                    }
                    if (methodOfTravel == null) {
                        methodOfTravel = GotoMethod.SHIFT;
                    }
                } else {
                    this.gotoMethod = methodOfTravel;
                }
                if (this.destination != null) {
                    if (this.gotoMethod == GotoMethod.SHIFT) {
                        int xxx = this.destination.x.intValue();
                        int zzz = this.destination.z.intValue();
                        this.destination.x = (double)xxx + 0.5;
                        this.destination.z = (double)zzz + 0.5;
                        if (this.theEntity != null) {
                            this.theEntity.field_70165_t = this.destination.x;
                            this.theEntity.field_70163_u = this.destination.y;
                            this.theEntity.field_70161_v = this.destination.z;
                            try {
                                if (this.location.theDimension != this.destination.theDimension) {
                                    this.theEntity.func_71027_c(this.destination.theDimension);
                                    this.theEntity.field_71093_bK = this.destination.theDimension;
                                    this.location.theDimension = this.destination.theDimension;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            this.location = this.destination.clone();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.destination = null;
                    } else if (this.gotoMethod == GotoMethod.BEAM) {
                        this.timeStartedGotoing = System.currentTimeMillis();
                        this.beamMeTo(whereTo);
                    } else if (this.gotoMethod == GotoMethod.WALK) {
                        this.stayPut = false;
                        this.timeStartedGotoing = System.currentTimeMillis();
                        if (this.theEntity != null) {
                            this.theEntity.gotPath = false;
                        }
                    }
                }
            }
        }
    }

    public void beamMeTo(V3 whereToIn) {
        this.stayPut = true;
        this.updateLocationFromEntity();
        if (this.beamingTo == null) {
            if (whereToIn == null) {
                ModSimReloaded.log.warning("FolkData: beamMeTo() whereTo was NULL, cancelled beaming");
            } else {
                int xxx;
                this.timeStartedGotoing = System.currentTimeMillis();
                V3 whereTo = whereToIn.clone();
                WorldServer destWorld = MinecraftServer.func_71276_C().func_71218_a(whereTo.theDimension);
                for (xxx = 0; xxx < 200; ++xxx) {
                    Block id1 = destWorld.func_147439_a(whereTo.x.intValue(), whereTo.y.intValue(), whereTo.z.intValue());
                    Block id2 = destWorld.func_147439_a(whereTo.x.intValue(), whereTo.y.intValue() + 1, whereTo.z.intValue());
                    if (id1 == null && id2 == null) break;
                    Double var8 = whereTo.y;
                    Double d = whereTo.y = Double.valueOf(whereTo.y + 1.0);
                }
                try {
                    xxx = whereTo.x.intValue();
                    whereTo.x = (double)xxx + 0.5;
                    xxx = whereTo.z.intValue();
                    whereTo.z = (double)xxx + 0.5;
                    whereTo.y = whereTo.y - 199.0;
                }
                catch (Exception var11) {
                    return;
                }
                this.destination = whereTo.clone();
                this.stayPut = true;
                if (this.isSpawned()) {
                    this.theEntity.func_70661_as().func_75499_g();
                }
                try {
                    if (ModSim.proxy.getClientWorld() != null) {
                        // empty if block
                    }
                    this.beamingTo = whereTo.clone();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void doBeaming() {
        try {
            if (System.currentTimeMillis() - this.timeStartedGotoing > 4000L || this.beamingTo == null) {
                if (this.theEntity != null) {
                    this.theEntity.func_70107_b(this.beamingTo.x, this.beamingTo.y, this.beamingTo.z);
                    if (this.theEntity.field_71093_bK != this.beamingTo.theDimension) {
                        this.theEntity.func_71027_c(this.beamingTo.theDimension);
                        this.theEntity.field_71093_bK = this.beamingTo.theDimension;
                        this.location.theDimension = this.beamingTo.theDimension;
                    }
                }
                this.location = this.beamingTo.clone();
                this.destination = null;
                this.beamingTo = null;
                this.respawnEntity((World)MinecraftServer.func_71276_C().func_71218_a(this.location.theDimension));
                return;
            }
        }
        catch (Exception var8) {
            this.destination = null;
            this.beamingTo = null;
            return;
        }
        Random random = new Random();
        Double d4 = ((double)random.nextFloat() - 2.0) * 2.0;
        this.stayPut = true;
        WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
        for (int p = 0; p < 10; ++p) {
            try {
                if (!ConfigLoader.configDisableBeamEffect) {
                    theWorld.func_72869_a("portal", this.location.x + random.nextDouble() - 0.5, this.location.y - 1.0, this.location.z + random.nextDouble() - 0.5, 0.0, -d4.doubleValue(), 0.0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ConfigLoader.configDisableBeamEffect) continue;
                theWorld.func_72869_a("portal", this.beamingTo.x + random.nextDouble() - 0.5, this.beamingTo.y - 1.0, this.beamingTo.z + random.nextDouble() - 0.5, 0.0, -d4.doubleValue(), 0.0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadAndSpawnFolks() {
        ModSimReloaded.theFolks.clear();
        File folksFolder = new File(ModSimReloaded.getSavesDataFolder() + "folks" + File.separator);
        if (!folksFolder.exists()) {
            folksFolder.mkdirs();
        }
        boolean useNewFormat = false;
        for (File f : folksFolder.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            for (File f : folksFolder.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                FolkData folkd = new FolkData();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    try {
                        if (name.contentEquals("employedat")) {
                            if (value.contentEquals("null")) continue;
                            folkd.employedAt = new V3(value);
                            continue;
                        }
                        if (name.contentEquals("vocation")) {
                            if (value.contentEquals("null")) continue;
                            folkd.vocation = Vocation.valueOf(value);
                            continue;
                        }
                        if (name.contentEquals("name")) {
                            folkd.name = value;
                            continue;
                        }
                        if (name.contentEquals("age")) {
                            folkd.age = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("gender")) {
                            folkd.gender = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("skin")) {
                            folkd.skinnumber = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("levelfood")) {
                            folkd.levelFood = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("levelfun")) {
                            folkd.levelFun = Integer.parseInt(value);
                            continue;
                        }
                        if (name.contentEquals("levelbuilder")) {
                            folkd.levelBuilder = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("levelminer")) {
                            folkd.levelMiner = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("levelsoldier")) {
                            folkd.levelSoldier = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("stayput")) {
                            folkd.stayPut = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (name.contentEquals("location")) {
                            folkd.location = new V3(value);
                            continue;
                        }
                        if (name.contentEquals("pregnancy")) {
                            folkd.pregnancyStage = Float.parseFloat(value);
                            continue;
                        }
                        if (name.contentEquals("building")) {
                            if (value.contentEquals("null")) continue;
                            int m2 = value.indexOf("|");
                            int m3 = value.indexOf("||");
                            String fn = value.substring(0, m2);
                            String type = value.substring(m2 + 1, m3);
                            String dir = value.substring(m3 + 2);
                            folkd.theBuilding = Building.getBuildingForFolk(fn, type);
                            folkd.theBuilding.buildDirection = dir;
                            continue;
                        }
                        if (name.contentEquals("terraformtype")) {
                            if (value.contentEquals("null")) continue;
                            folkd.terraformerType = TerraformerType.valueOf(value);
                            continue;
                        }
                        if (!name.contentEquals("terraformradius")) continue;
                        folkd.terraformerRadius = Integer.parseInt(value);
                    }
                    catch (Exception exception) {}
                }
                if (folkd == null) continue;
                ModSimReloaded.log.info("FolkData: loadAndSpawnFolks() \u52a0\u8f7d " + folkd.name + " \u4f7f\u7528\u65b0\u7684\u6587\u4ef6\u7cfb\u7edf");
                folkd.hasLoaded();
            }
        } else {
            for (File f : folksFolder.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                FolkData folkd = (FolkData)ModSim.proxy.loadObject(f.getAbsoluteFile().toString());
                if (folkd != null) {
                    folkd.hasLoaded();
                    continue;
                }
                f.delete();
            }
        }
    }

    public void saveThisFolk() {
        Side side;
        String folder = ModSimReloaded.getSavesDataFolder() + "folks" + File.separator;
        File f = new File(folder);
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            if (this.employedAt == null) {
                strings.add("employedat|null");
            } else {
                strings.add("employedat|" + this.employedAt.toString());
            }
            if (this.vocation == null) {
                strings.add("vocation|null");
            } else {
                strings.add("vocation|" + this.vocation.name());
            }
            strings.add("name|" + this.name);
            strings.add("age|" + this.age);
            strings.add("gender|" + this.gender);
            strings.add("skin|" + this.skinnumber);
            strings.add("levelfood|" + this.levelFood);
            strings.add("levelfun|" + this.levelFun);
            strings.add("levelbuilder|" + this.levelBuilder);
            strings.add("levelminer|" + this.levelMiner);
            strings.add("levelsoldier|" + this.levelSoldier);
            strings.add("stayput|" + this.stayPut.toString());
            strings.add("location|" + this.location.toString());
            strings.add("pregnancy|" + this.pregnancyStage);
            if (this.theBuilding == null) {
                strings.add("building|null");
            } else {
                strings.add("building|" + this.theBuilding.displayName + ".txt|" + this.theBuilding.type + "||" + this.theBuilding.buildDirection);
            }
            if (this.terraformerType == null) {
                strings.add("terraformtype|null");
            } else {
                strings.add("terraformtype|" + this.terraformerType.name());
            }
            strings.add("terraformradius|" + this.terraformerRadius);
            if (!this.name.contentEquals("")) {
                ModSimReloaded.saveSK2(folder + this.name + ".sk2", strings);
            }
        }
    }

    public Building getHome() {
        for (int b = 0; b < ModSimReloaded.theBuildings.size(); ++b) {
            Building home = ModSimReloaded.theBuildings.get(b);
            for (int t = 0; t < home.tenants.size(); ++t) {
                String tennant = home.tenants.get(t);
                if (!tennant.contentEquals(this.name)) continue;
                return home;
            }
        }
        return null;
    }

    public static void generateNewFolk(World world) {
        ArrayList fds = FolkData.getFolkHomeless();
        if (fds.size() == 0 && ModSimReloaded.theFolks.size() < ConfigLoader.configPopulationLimit) {
            new FolkData(world);
        }
    }

    public static FolkData getFolkByName(String name) {
        FolkData f = null;
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            f = ModSimReloaded.theFolks.get(x);
            if (!f.name.contentEquals(name)) continue;
            return f;
        }
        return null;
    }

    public static FolkData getFolkByLocation(V3 loc) {
        FolkData f = null;
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            f = ModSimReloaded.theFolks.get(x);
            if (!f.location.isSameCoordsAs(loc, true, false)) continue;
            return f;
        }
        return null;
    }

    public static FolkData getFolkByEmployedAt(V3 employedAt) {
        FolkData f = null;
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            f = ModSimReloaded.theFolks.get(x);
            if (f.employedAt == null || !f.employedAt.isSameCoordsAs(employedAt, true, false)) continue;
            return f;
        }
        return null;
    }

    public static ArrayList<FolkData> getFolksByEmployedAt(V3 v) {
        ArrayList<FolkData> ret = new ArrayList<FolkData>();
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            FolkData f = ModSimReloaded.theFolks.get(x);
            if (f.employedAt == null || !f.employedAt.isSameCoordsAs(v, true, false)) continue;
            ret.add(f);
        }
        return ret;
    }

    public static ArrayList getFolkUnemployed(boolean showEmployed) {
        ArrayList<FolkData> f = new ArrayList<FolkData>();
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            FolkData folk = ModSimReloaded.theFolks.get(x);
            if (showEmployed) {
                if (folk.employedAt == null) continue;
                f.add(folk);
                continue;
            }
            if (folk.employedAt != null || folk.age <= 17 || folk.pregnancyStage != 0.0f) continue;
            f.add(folk);
        }
        return f;
    }

    public static ArrayList getFolkHomeless() {
        ArrayList<FolkData> f = new ArrayList<FolkData>();
        for (int x = 0; x < ModSimReloaded.theFolks.size(); ++x) {
            FolkData folk = ModSimReloaded.theFolks.get(x);
            if (folk.getHome() != null) continue;
            f.add(folk);
        }
        return f;
    }

    public static FolkData getFolkDataByEntityId(int id) {
        for (int i = 0; i < ModSimReloaded.theFolks.size(); ++i) {
            FolkData fd = ModSimReloaded.theFolks.get(i);
            if (fd.theEntity == null || fd.theEntity.func_145782_y() != id) continue;
            return fd;
        }
        return null;
    }

    public void eventDied(DamageSource d) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        ModSimReloaded.log.info("\u5728FolkData\u53d1\u751f\u7684\u4e8b\u4ef6\u4e2d\u6b7b\u4ea1 " + side.toString() + " side");
        String oldJob = "";
        if (this.vocation != null) {
            oldJob = " (" + this.vocation.toString() + ")";
        }
        this.employedAt = null;
        this.vocation = null;
        String deathBy = "";
        if (d == DamageSource.field_76367_g) {
            deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_cactus", (Object[])new Object[0]);
        }
        if (d == DamageSource.field_76369_e) {
            deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_drowned", (Object[])new Object[0]);
        }
        if (d == DamageSource.field_76377_j) {
            deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_old", (Object[])new Object[0]);
        }
        if (d == DamageSource.field_76372_a) {
            deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_combustion", (Object[])new Object[0]);
        }
        if (d == DamageSource.field_76371_c) {
            int q;
            int i;
            deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_lava", (Object[])new Object[0]);
            if (d == DamageSource.field_76370_b) {
                deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_Burned", (Object[])new Object[0]);
            }
            if (d == DamageSource.field_76380_i) {
                deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_Fell", (Object[])new Object[0]);
            }
            if (d == DamageSource.field_76366_f) {
                deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_starvation", (Object[])new Object[0]);
            }
            if (d == DamageSource.field_76379_h) {
                deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_cliff", (Object[])new Object[0]);
            }
            if (d == DamageSource.field_76368_d) {
                deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_under", (Object[])new Object[0]);
            }
            if (deathBy.contentEquals("")) {
                Random r = new Random();
                i = r.nextInt(6);
                if (i == 0) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_Electrocuted", (Object[])new Object[0]);
                } else if (i == 1) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_Tripped", (Object[])new Object[0]);
                } else if (i == 2) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_Trampled", (Object[])new Object[0]);
                } else if (i == 3) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_Ran", (Object[])new Object[0]);
                } else if (i == 4) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_Slipped", (Object[])new Object[0]);
                } else if (i == 5) {
                    deathBy = I18n.func_135052_a((String)"container.sim.folk_data_death_by_killed", (Object[])new Object[0]);
                }
            }
            String only = "";
            only = this.age < 80 ? I18n.func_135052_a((String)"container.sim.folk_data_death_by_They", (Object[])new Object[0]) + this.age + I18n.func_135052_a((String)"container.sim.folk_data_death_by_years", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.folk_data_death_by_were", (Object[])new Object[0]) + this.age + I18n.func_135052_a((String)"container.sim.folk_data_death_by_life", (Object[])new Object[0]);
            ModSimReloaded.sendChat(this.name + oldJob + I18n.func_135052_a((String)"container.sim.folk_data_death_by_died", (Object[])new Object[0]) + deathBy + only);
            this.action = FolkAction.WANDER;
            i = 0;
            for (q = 0; q < ModSimReloaded.theFolks.size(); ++q) {
                FolkData fo = ModSimReloaded.theFolks.get(q);
                if (!fo.name.contentEquals(this.name)) continue;
                i = q;
                break;
            }
            this.evictThem();
            try {
                for (q = 0; q < ModSimReloaded.theRelationships.size(); ++q) {
                    try {
                        Relationship rel = ModSimReloaded.theRelationships.get(q);
                        if (!rel.folk1.name.contentEquals(this.name) && !rel.folk2.name.contentEquals(this.name)) continue;
                        String fn = rel.folk1.name.replaceAll(" ", "") + rel.folk2.name.replaceAll(" ", "");
                        File f = new File(ModSimReloaded.getSavesDataFolder() + "Relationships" + File.separator + fn + ".sk2");
                        f.delete();
                        ModSimReloaded.theRelationships.remove(q);
                        continue;
                    }
                    catch (Exception rel) {
                        // empty catch block
                    }
                }
                File f = new File(ModSimReloaded.getSavesDataFolder() + "folks" + File.separator + this.name + ".sk2");
                f.delete();
                if (i >= 0 && i < ModSimReloaded.theFolks.size()) {
                    ModSimReloaded.theFolks.remove(i);
                }
            }
            catch (Exception var12) {
                ModSimReloaded.log.warning("FolkData: eventDied() " + var12.toString());
            }
        }
    }

    public void evictThem() {
        if (this.getHome() != null) {
            for (int b = 0; b < ModSimReloaded.theBuildings.size(); ++b) {
                Building building = ModSimReloaded.theBuildings.get(b);
                if (building == null || this.getHome() == null || !building.primaryXYZ.isSameCoordsAs(this.getHome().primaryXYZ, true, false)) continue;
                building.removeTennant(this.name);
            }
        }
    }

    public void setTheirJob(Vocation vocation) {
        if (vocation != null) {
            this.vocation = vocation;
            if (this.vocation == Vocation.BUILDER) {
                this.theirJob = new JobBuilder(this);
            } else if (this.vocation == Vocation.BAKER) {
                this.theirJob = new JobBaker(this);
            } else if (this.vocation == Vocation.BUTCHER) {
                this.theirJob = new JobButcher(this);
            } else if (this.vocation == Vocation.CATTLEFARMER) {
                this.theirJob = new JobLivestockFarmer(this);
            } else if (this.vocation == Vocation.CHICKENFARMER) {
                this.theirJob = new JobLivestockFarmer(this);
            } else if (this.vocation == Vocation.COURIER) {
                this.theirJob = new JobCourier(this);
            } else if (this.vocation == Vocation.CROPFARMER) {
                this.theirJob = new JobCropFarmer(this);
            } else if (this.vocation == Vocation.GLASSMAKER) {
                this.theirJob = new JobGlassMaker(this);
            } else if (this.vocation == Vocation.GROCER) {
                this.theirJob = new JobGrocer(this);
            } else if (this.vocation == Vocation.LUMBERJACK) {
                this.theirJob = new JobLumberjack(this);
            } else if (this.vocation == Vocation.MERCHANT) {
                this.theirJob = new JobBuildersMerchant(this);
            } else if (this.vocation == Vocation.MINER) {
                this.theirJob = new JobMiner(this);
            } else if (this.vocation == Vocation.PIGFARMER) {
                this.theirJob = new JobLivestockFarmer(this);
            } else if (this.vocation == Vocation.SHEPHERD) {
                this.theirJob = new JobShepherd(this);
            } else if (this.vocation == Vocation.SOLDIER) {
                this.theirJob = new JobSoldier(this);
            } else if (this.vocation == Vocation.TERRAFORMER) {
                this.theirJob = new JobTerraformer(this);
            } else if (this.vocation == Vocation.FISHERMAN) {
                this.theirJob = new JobFisherman(this);
            } else if (this.vocation == Vocation.BRICKMAKER) {
                this.theirJob = new JobBrickMaker(this);
            } else if (this.vocation != Vocation.PATHBUILDER) {
                if (this.vocation == Vocation.DAIRYFARMER) {
                    this.theirJob = new JobDairyFarmer(this);
                } else if (this.vocation == Vocation.CHEESEMAKER) {
                    this.theirJob = new JobCheesemaker(this);
                } else if (this.vocation == Vocation.BURGERSMANAGER) {
                    this.theirJob = new JobBurgersManager(this);
                } else if (this.vocation == Vocation.BURGERSFRYCOOK) {
                    this.theirJob = new JobBurgersFryCook(this);
                } else if (this.vocation == Vocation.BURGERSWAITER) {
                    this.theirJob = new JobBurgersWaiter(this);
                } else if (this.vocation == Vocation.EGGFARMER) {
                    this.theirJob = new JobEggFarmer(this);
                }
            }
            this.theirJob.resetJob();
            this.theirJob.step = 1;
        }
    }

    static {
        anyFolkLastSpoke = 0L;
    }
}

