/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.entity;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class GameStates
implements Serializable {
    private static final long serialVersionUID = -2617900998876928361L;
    public int population = 0;
    public float credits = 10.0f;
    public boolean cheatMode = false;
    public int gameModeNumber = -1;
    public int dayOfWeek = 0;
    public long lastUpdateCheck = 0L;
    public long userId = 0L;
    public int populationLimit = 100;
    public int lumberArea = 30;
    public boolean disableBeamEffect = false;
    public boolean folkNoise = true;

    public void loadStates() {
        File f = new File(ModSimReloaded.getSavesDataFolder() + "settings.sk2");
        if (!f.exists()) {
            ModSimReloaded.states = (GameStates)ModSim.proxy.loadObject(ModSimReloaded.getSavesDataFolder() + "settings.suk");
        } else {
            this.loadStates2();
        }
    }

    private void loadStates2() {
        ArrayList<String> strings = ModSimReloaded.loadSK2(ModSimReloaded.getSavesDataFolder() + "settings.sk2");
        for (String line : strings) {
            if (!line.contains("|")) continue;
            int m1 = line.indexOf("|");
            String name = line.substring(0, m1);
            String value = line.substring(m1 + 1);
            try {
                if (name.contentEquals("credits")) {
                    this.credits = Float.parseFloat(value);
                    continue;
                }
                if (name.contentEquals("gamemode")) {
                    this.gameModeNumber = Integer.parseInt(value);
                    continue;
                }
                if (name.contentEquals("dayofweek")) {
                    this.dayOfWeek = Integer.parseInt(value);
                    continue;
                }
                if (name.contentEquals("lastupdatecheck")) {
                    this.lastUpdateCheck = Long.parseLong(value);
                    continue;
                }
                if (!name.contentEquals("uid")) continue;
                this.userId = Long.parseLong(value);
            }
            catch (Exception exception) {}
        }
    }

    public void saveStates() {
        String folder = ModSimReloaded.getSavesDataFolder();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("credits|" + this.credits);
        strings.add("gamemode|" + this.gameModeNumber);
        strings.add("dayofweek|" + this.dayOfWeek);
        strings.add("lastupdatecheck|" + this.lastUpdateCheck);
        ModSimReloaded.saveSK2(folder + "settings.sk2", strings);
        ModSimReloaded.log.info("GameStates: saveStates() called BOTH sides, \u91d1\u989d\u5b58\u50a8\u4e3a " + this.credits);
    }
}

