/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.entity;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.Level;
import com.trhsy.sim.common.loader.ModSimReloaded;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.resources.I18n;

public class Relationship
implements Serializable {
    private static final long serialVersionUID = -1617919828251928361L;
    public FolkData folk1 = null;
    public FolkData folk2 = null;
    public Level theLevel = Level.AQUAINTANCE;
    public int theSubLevel = 0;
    public boolean isBloodRelation = false;
    private Random rand = new Random();

    public Relationship() {
    }

    public Relationship(FolkData folk1, FolkData folk2, Level startingLevel, boolean isBlood) {
        this.folk1 = folk1;
        this.folk2 = folk2;
        this.theLevel = startingLevel;
        this.isBloodRelation = isBlood;
    }

    public String toString() {
        if (this.theLevel == Level.AQUAINTANCE) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_aquaintance", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.BESTFRIENDS) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.DESPISE) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_despises", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.DISLIKE) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_dislikes", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.ENEMY) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_ememy", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.FRIEND) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_is_friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GOODFRIEND) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_good_friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.HATE) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_hates", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.MARRIED) {
            return I18n.func_135052_a((String)"container.sim.relation_ship_married", (Object[])new Object[0]);
        }
        return this.theLevel == Level.PARTNER ? I18n.func_135052_a((String)"container.sim.relation_ship_living", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.relation_ship_relationship", (Object[])new Object[0]);
    }

    public String toStringPersepctive(FolkData folk) {
        FolkData fother;
        String other = "";
        if (folk.name.contentEquals(this.folk1.name)) {
            other = this.folk2.name;
            fother = this.folk2;
        } else {
            other = this.folk1.name;
            fother = this.folk1;
        }
        if (this.theLevel == Level.AQUAINTANCE) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_level_Aquaintance", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.BESTFRIENDS) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Best_friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.DESPISE) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Despise", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.DISLIKE) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Dislike", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.ENEMY) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Enemy", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.FRIEND) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GOODFRIEND) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Good_friends", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.HATE) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Hate", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.MARRIED) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Married", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.PARTNER) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Partner", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.MOTHERDAUGHTER) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Mother", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Daughter", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.MOTHERSON) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Mother", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Son", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.FATHERSON) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Father", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Son", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.FATHERDAUGHTER) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Father", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Daughter", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.SISTERSISTER) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Sister", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.BROTHERBROTHER) {
            return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Brother", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.SISTERBROTHER) {
            return fother.gender == 0 ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Brother", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Sister", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GRANDFATHERDAUGHTER) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandfather", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Granddaughter", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GRANDFATHERSON) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandfather", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandson", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GRANDMOTHERDAUGHTER) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandmother", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Granddaughter", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.GRANDMOTHERSON) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandmother", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Grandson", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.AUNTNEPHEW) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Aunt", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Nephew", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.AUNTNEICE) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Aunt", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Neice", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.UNCLENEPHEW) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Uncle", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Nephew", (Object[])new Object[0]);
        }
        if (this.theLevel == Level.UNCLENEICE) {
            return fother.age > folk.age ? other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Uncle", (Object[])new Object[0]) : other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_Neice", (Object[])new Object[0]);
        }
        return other + ": " + I18n.func_135052_a((String)"container.sim.relation_ship_relationship", (Object[])new Object[0]);
    }

    public static FolkData getMotherOf(FolkData sonDaughter) {
        Relationship rel;
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(sonDaughter);
        Iterator<Relationship> i$ = rels.iterator();
        do {
            if (!i$.hasNext()) {
                return null;
            }
            rel = i$.next();
        } while (rel.theLevel != Level.MOTHERDAUGHTER && rel.theLevel != Level.MOTHERSON);
        return rel.folk1.age > rel.folk2.age ? FolkData.getFolkByName(rel.folk1.name) : FolkData.getFolkByName(rel.folk2.name);
    }

    public static void addRelationship(Relationship rel) {
        boolean got = false;
        for (Relationship relation : ModSimReloaded.theRelationships) {
            try {
                if (relation.folk1.name.contentEquals(rel.folk1.name) && relation.folk2.name.contentEquals(rel.folk2.name)) {
                    got = true;
                }
                if (!relation.folk1.name.contentEquals(rel.folk2.name) || !relation.folk2.name.contentEquals(rel.folk1.name)) continue;
                got = true;
            }
            catch (Exception exception) {}
        }
        if (!got) {
            ModSimReloaded.theRelationships.add(rel);
        }
    }

    public static void setupBloodRelationships(FolkData newChild, FolkData father, FolkData mother) {
        ArrayList<Relationship> mothers = Relationship.getRelationshipsFor(mother);
        for (Relationship rel : mothers) {
            FolkData other = rel.folk1.name.contentEquals(mother.name) ? rel.folk2 : rel.folk1;
            if (rel.theLevel == Level.MOTHERDAUGHTER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERBROTHER, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERSISTER, true));
                }
            } else if (rel.theLevel == Level.MOTHERSON) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.BROTHERBROTHER, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERBROTHER, true));
                }
            }
            if (rel.theLevel == Level.MOTHERDAUGHTER && !rel.folk1.name.contentEquals(newChild.name) && !rel.folk2.name.contentEquals(newChild.name)) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERDAUGHTER, true));
                }
            } else if (rel.theLevel == Level.FATHERDAUGHTER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERDAUGHTER, true));
                }
            }
            if (rel.theLevel == Level.SISTERBROTHER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEPHEW, true));
                    continue;
                }
                Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEICE, true));
                continue;
            }
            if (rel.theLevel != Level.SISTERSISTER) continue;
            if (newChild.gender == 0) {
                Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEPHEW, true));
                continue;
            }
            Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEICE, true));
        }
        ArrayList<Relationship> fathers = Relationship.getRelationshipsFor(father);
        for (Relationship rel : fathers) {
            FolkData other = rel.folk1.name.contentEquals(father.name) ? rel.folk2 : rel.folk1;
            if (rel.theLevel == Level.FATHERSON && !rel.folk1.name.contentEquals(newChild.name) && !rel.folk2.name.contentEquals(newChild.name)) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERDAUGHTER, true));
                }
            } else if (rel.theLevel == Level.MOTHERSON) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERDAUGHTER, true));
                }
            }
            if (rel.theLevel == Level.SISTERBROTHER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEPHEW, true));
                    continue;
                }
                Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEICE, true));
                continue;
            }
            if (rel.theLevel != Level.BROTHERBROTHER) continue;
            if (newChild.gender == 0) {
                Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEPHEW, true));
                continue;
            }
            Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEICE, true));
        }
        if (newChild.gender == 0) {
            Relationship.addRelationship(new Relationship(newChild, mother, Level.MOTHERSON, true));
        } else {
            Relationship.addRelationship(new Relationship(newChild, mother, Level.MOTHERDAUGHTER, true));
        }
        if (newChild.gender == 0) {
            Relationship.addRelationship(new Relationship(newChild, father, Level.FATHERSON, true));
        } else {
            Relationship.addRelationship(new Relationship(newChild, father, Level.FATHERDAUGHTER, true));
        }
    }

    public String toFullString() {
        String folk2name = "";
        folk2name = this.folk2 == null ? "You" : this.folk2.name;
        return this.folk1.name + " " + this.toString() + " " + folk2name;
    }

    public void levelIncrease(int byAmount) {
        String oldLevel = this.toFullString();
        ModSimReloaded.log.info("Relationship: + \u5f53\u524d\u7ea7\u522b\u548c\u5b50\u7ea7\u522b:" + this.theLevel.toString() + " " + this.theSubLevel);
        this.theSubLevel += byAmount;
        if (this.theSubLevel > 100) {
            if (this.theLevel == Level.AQUAINTANCE) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 0;
            } else if (this.theLevel == Level.BESTFRIENDS) {
                if (this.folk2 == null) {
                    this.theSubLevel = 100;
                } else if (!(this.folk1.gender == this.folk2.gender || this.folk1.getHome() == null || this.folk2.getHome() == null || Relationship.isFolkLivingWithSomeone(this.folk1) || Relationship.isFolkLivingWithSomeone(this.folk2) || this.folk1.age < 18 || this.folk2.age < 18 || this.isBloodRelation)) {
                    this.theSubLevel = 50;
                    if (this.rand.nextBoolean()) {
                        this.theLevel = Level.MARRIED;
                        this.changeFemaleSurname();
                    } else {
                        this.theLevel = Level.PARTNER;
                    }
                    Building oldhome = this.folk1.getHome();
                    Building newhome = this.folk2.getHome();
                    if (oldhome != null) {
                        oldhome.removeTennant(this.folk1.name);
                    }
                    if (newhome != null) {
                        newhome.tenants.add(this.folk1.name);
                    }
                    Building.saveAllBuildings();
                    if (this.folk1.employedAt == null && this.folk2.employedAt == null) {
                        try {
                            this.folk1.action = FolkAction.GOINGHOME;
                            this.folk1.actionArrival = FolkAction.ATHOME;
                            V3 v3 = this.folk1.getHome().primaryXYZ;
                            v3 = new V3(v3.x + 1.0, v3.y + 1.0, v3.z, v3.theDimension);
                            this.folk1.gotoXYZ(v3, null);
                            this.folk2.action = FolkAction.GOINGHOME;
                            this.folk2.actionArrival = FolkAction.ATHOME;
                            V3 v32 = this.folk2.getHome().primaryXYZ;
                            v32 = new V3(v32.x + 1.0, v32.y + 1.0, v32.z, v32.theDimension);
                            this.folk2.gotoXYZ(v32, null);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (this.theLevel == Level.DESPISE) {
                this.theLevel = Level.HATE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.DISLIKE) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.ENEMY) {
                this.theLevel = Level.DESPISE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.FRIEND) {
                this.theLevel = Level.GOODFRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.GOODFRIEND) {
                this.theLevel = Level.BESTFRIENDS;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.HATE) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.MARRIED) {
                this.theSubLevel = 100;
            } else if (this.theLevel == Level.PARTNER) {
                this.theSubLevel = 100;
            }
            if (!this.toFullString().contentEquals(oldLevel)) {
                this.notifyRelationshipChange();
            }
        }
    }

    private void changeFemaleSurname() {
        FolkData maleFolk;
        FolkData femaleFolk;
        if (this.folk1.gender == 1) {
            femaleFolk = this.folk1;
            maleFolk = this.folk2;
        } else {
            femaleFolk = this.folk2;
            maleFolk = this.folk1;
        }
        for (int b = 0; b < ModSimReloaded.theBuildings.size(); ++b) {
            Building building = ModSimReloaded.theBuildings.get(b);
            if (building == null || femaleFolk.getHome() == null || !building.primaryXYZ.isSameCoordsAs(femaleFolk.getHome().primaryXYZ, true, false)) continue;
            building.removeTennant(femaleFolk.name);
        }
        File f = new File(ModSimReloaded.getSavesDataFolder() + "Folks" + File.separator + femaleFolk.name + ".sk2");
        f.delete();
        String surname = maleFolk.name.substring(maleFolk.name.indexOf(" ") + 1).trim();
        int m = femaleFolk.name.indexOf(" ");
        femaleFolk.name = femaleFolk.name.substring(0, m).trim() + " " + surname;
    }

    public void levelDecrease(int byAmount) {
        String oldLevel = this.toFullString();
        this.theSubLevel -= byAmount;
        if (this.theSubLevel < 0) {
            if (this.theLevel == Level.AQUAINTANCE) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.BESTFRIENDS) {
                if (this.folk2 == null) {
                    this.theSubLevel = 50;
                } else {
                    this.theLevel = Level.GOODFRIEND;
                    this.theSubLevel = 50;
                }
            } else if (this.theLevel == Level.DESPISE) {
                this.theLevel = Level.ENEMY;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.DISLIKE) {
                this.theLevel = Level.HATE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.ENEMY) {
                this.theSubLevel = 0;
            } else if (this.theLevel == Level.FRIEND) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.GOODFRIEND) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.HATE) {
                this.theLevel = Level.DESPISE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.MARRIED) {
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.PARTNER) {
                this.theSubLevel = 50;
            }
            if (!this.toFullString().contentEquals(oldLevel)) {
                this.notifyRelationshipChange();
            }
        }
    }

    private void notifyRelationshipChange() {
        if (this.folk2 == null || this.theLevel == Level.MARRIED || this.theLevel == Level.PARTNER) {
            ModSimReloaded.sendChat(this.toFullString().replaceAll(" is ", " is now "));
        }
    }

    public static void loadRelationships() {
        File relFiles = new File(ModSimReloaded.getSavesDataFolder() + "Relationships" + File.separator);
        relFiles.mkdirs();
        boolean useNewFormat = false;
        for (File f : relFiles.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            ModSimReloaded.theRelationships.clear();
            for (File f : relFiles.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = ModSimReloaded.loadSK2(f.getAbsoluteFile().toString());
                Relationship rel = new Relationship();
                for (String line : strings) {
                    FolkData folk;
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("folk1")) {
                        if (value.contentEquals("") || value.contentEquals("null") || (folk = FolkData.getFolkByName(value)) == null) continue;
                        rel.folk1 = folk;
                        continue;
                    }
                    if (name.contentEquals("folk2")) {
                        if (value.contentEquals("") || value.contentEquals("null") || (folk = FolkData.getFolkByName(value)) == null) continue;
                        rel.folk2 = folk;
                        continue;
                    }
                    if (name.contentEquals("level")) {
                        rel.theLevel = Level.valueOf(value);
                        continue;
                    }
                    if (name.contentEquals("sublevel")) {
                        rel.theSubLevel = Integer.parseInt(value);
                        continue;
                    }
                    if (!name.contentEquals("bloodrelation")) continue;
                    rel.isBloodRelation = Boolean.parseBoolean(value);
                }
                if (rel.folk1 == null || rel.folk2 == null) continue;
                Relationship.addRelationship(rel);
            }
        } else {
            for (File f : relFiles.listFiles()) {
                Relationship rel;
                if (!f.getName().endsWith(".suk") || (rel = (Relationship)ModSim.proxy.loadObject(f.getAbsoluteFile().toString())) == null) continue;
                Relationship.addRelationship(rel);
            }
        }
    }

    public static void saveRelationships() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int b = 0; b < ModSimReloaded.theRelationships.size(); ++b) {
                try {
                    Relationship rel = ModSimReloaded.theRelationships.get(b);
                    String fn = rel.folk1.name.replaceAll(" ", "") + rel.folk2.name.replaceAll(" ", "");
                    strings.clear();
                    strings.add("folk1|" + rel.folk1.name);
                    strings.add("folk2|" + rel.folk2.name);
                    strings.add("level|" + rel.theLevel.name());
                    strings.add("sublevel|" + rel.theSubLevel);
                    strings.add("bloodrelation|" + rel.isBloodRelation);
                    ModSimReloaded.saveSK2(ModSimReloaded.getSavesDataFolder() + "Relationships" + File.separator + fn + ".sk2", strings);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void meddleWithRelationship(FolkData folk1, FolkData folk2) {
        if (folk1.name.contentEquals(folk2.name)) {
            ModSimReloaded.log.warning("\u5173\u7cfb: \u5e72\u6d89\u5173\u7cfb() \u4e24\u4e2a\u4eba\u90fd\u662f\u540c\u4e00\u4e2a\u4eba");
        } else {
            Relationship rel = Relationship.getRelationshipBetween(folk1, folk2);
            if (rel == null) {
                Relationship.addRelationship(new Relationship(folk1, folk2, Level.AQUAINTANCE, false));
            } else {
                Random r = new Random();
                int rr = r.nextInt(5);
                if (rr == 0) {
                    rel.levelDecrease(r.nextInt(30));
                } else {
                    rel.levelIncrease(r.nextInt(30));
                }
            }
        }
    }

    public static Relationship getRelationshipBetween(FolkData folk1, FolkData folk2) {
        for (int b = 0; b < ModSimReloaded.theRelationships.size(); ++b) {
            Relationship rel = ModSimReloaded.theRelationships.get(b);
            try {
                if (folk2 == null && rel.folk2 == null && rel.folk1.name.contentEquals(folk1.name)) {
                    return rel;
                }
                if (rel.folk1.name.contentEquals(folk1.name) && rel.folk2.name.contentEquals(folk2.name)) {
                    return rel;
                }
                if (!rel.folk1.name.contentEquals(folk2.name) || !rel.folk2.name.contentEquals(folk1.name)) continue;
                return rel;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArrayList<Relationship> getRelationshipsFor(FolkData theFolk) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        for (int i = 0; i < ModSimReloaded.theRelationships.size(); ++i) {
            try {
                Relationship rel = ModSimReloaded.theRelationships.get(i);
                if (!rel.folk1.name.contentEquals(theFolk.name) && !rel.folk2.name.contentEquals(theFolk.name)) continue;
                rels.add(rel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rels;
    }

    public static boolean isFolkLivingWithSomeone(FolkData theFolk) {
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(theFolk);
        boolean ret = false;
        for (int i = 0; i < rels.size(); ++i) {
            Relationship rel = rels.get(i);
            if (rel.theLevel != Level.MARRIED && rel.theLevel != Level.PARTNER) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static FolkData isFolkLivingWithSomeone(FolkData theFolk, boolean returnFolk) {
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(theFolk);
        for (int i = 0; i < rels.size(); ++i) {
            Relationship rel = rels.get(i);
            if (rel.theLevel != Level.MARRIED && rel.theLevel != Level.PARTNER) continue;
            return rel.folk1.name.contentEquals(theFolk.name) ? FolkData.getFolkByName(rel.folk2.name) : FolkData.getFolkByName(rel.folk1.name);
        }
        return null;
    }
}

