/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.block.functionality.TileEntityWindmill;
import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class Job {
    Minecraft mc = Minecraft.func_71410_x();
    public int step = 1;
    ArrayList<V3> closestBlocks = new ArrayList();
    public Vocation vocation = null;
    public World jobWorld = null;
    private transient IInventory chestToClose = null;
    private transient Long chestToCloseWhen = 0L;

    public abstract void onArrivedAtWork();

    public abstract void resetJob();

    public void onUpdate() {
        try {
            if (this.chestToClose != null && System.currentTimeMillis() > this.chestToCloseWhen) {
                this.chestToClose.func_70305_f();
                this.chestToClose = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onUpdateGoingToWork(FolkData theFolk) {
        try {
            if (this.jobWorld == null) {
                try {
                    this.jobWorld = MinecraftServer.func_71276_C().func_71218_a(theFolk.employedAt.theDimension);
                }
                catch (Exception var7) {
                    System.out.println(var7.getMessage());
                    return;
                }
            }
            if (!(theFolk.pregnancyStage > 0.0f)) {
                if (theFolk.action == FolkAction.ONWAYTOWORK) {
                    int dist;
                    if (theFolk.gotoMethod == GotoMethod.WALK) {
                        theFolk.stayPut = false;
                        theFolk.updateLocationFromEntity();
                    }
                    if ((dist = theFolk.location.getDistanceTo(theFolk.employedAt)) <= 1) {
                        theFolk.action = FolkAction.ATWORK;
                        this.onArrivedAtWork();
                    } else if (dist > 1 && dist < 3) {
                        V3 work = theFolk.employedAt.clone();
                        work = new V3(work.x, work.y + 1.0, work.z, work.theDimension);
                        theFolk.gotoXYZ(work, GotoMethod.SHIFT);
                        theFolk.location = work;
                    }
                }
                if (ModSimReloaded.isDayTime() && theFolk.action != FolkAction.ONWAYTOWORK && theFolk.action != FolkAction.ATWORK) {
                    theFolk.action = FolkAction.ONWAYTOWORK;
                    theFolk.stayPut = false;
                    if (theFolk.destination == null) {
                        theFolk.gotoXYZ(theFolk.employedAt, null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getInventoryCount(FolkData theFolk, Item item) {
        int ret = 0;
        try {
            for (int i = 0; i < theFolk.inventory.size(); ++i) {
                ItemStack is = theFolk.inventory.get(i);
                if (is.func_77973_b() != item) continue;
                ret += is.field_77994_a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int getInventoryCount(FolkData theFolk, Block item) {
        int ret = 0;
        try {
            String lang = FMLCommonHandler.instance().getCurrentLanguage();
            for (int i = 0; i < theFolk.inventory.size(); ++i) {
                ItemStack is = theFolk.inventory.get(i);
                if (is == null) continue;
                String name = is.func_82833_r();
                String names = new ItemStack(item).func_82833_r();
                names = "en_US".equals(lang) ? names.substring(names.indexOf(" "), names.length()) : names.substring(names.length() - 1, names.length());
                if (!name.contains(names)) continue;
                ret += is.field_77994_a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public TileEntityFurnace findFurnace(V3 v) {
        TileEntityFurnace ret = null;
        try {
            V3 vRet = Job.findClosestBlockType(v, Blocks.field_150460_al, 5, false);
            if (vRet == null) {
                vRet = Job.findClosestBlockType(v, Blocks.field_150460_al, 5, false);
            }
            if (vRet != null) {
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(vRet.theDimension);
                ret = (TileEntityFurnace)theWorld.func_147438_o(vRet.x.intValue(), vRet.y.intValue(), vRet.z.intValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static boolean inventoryPut(IInventory chest, ItemStack inStack) {
        Boolean placedOK = false;
        try {
            if (inStack == null) {
                return true;
            }
            block2: for (int q = 1; q <= inStack.field_77994_a; ++q) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    ItemStack is = chest.func_70301_a(i);
                    if (is == null) {
                        is = inStack.func_77946_l();
                        is.field_77994_a = 1;
                        chest.func_70299_a(i, is);
                        ItemStack isTest = chest.func_70301_a(i);
                        if (isTest != null) {
                            placedOK = true;
                            continue block2;
                        }
                        ModSimReloaded.log.warning("Job: placeIntoInventory() \u65e0\u6cd5\u5c06 " + is.func_82833_r() + " \u653e\u5165\u7a7a\u69fd " + i);
                        placedOK = false;
                        continue;
                    }
                    if (is.func_77973_b() != inStack.func_77973_b() || is.func_77960_j() != inStack.func_77960_j() || is.field_77994_a >= is.func_77976_d()) continue;
                    int isBefore = chest.func_70301_a((int)i).field_77994_a;
                    ++is.field_77994_a;
                    chest.func_70299_a(i, is);
                    int isAfter = chest.func_70301_a((int)i).field_77994_a;
                    if (isAfter > isBefore) {
                        placedOK = true;
                        continue block2;
                    }
                    ModSimReloaded.log.warning("Job: placeIntoInventory() \u65e0\u6cd5\u66f4\u6539\u5927\u5c0f " + is.func_82833_r() + " in slot " + i);
                    placedOK = false;
                }
            }
            return placedOK;
        }
        catch (Exception exception) {
            return placedOK;
        }
    }

    public static ItemStack inventoriesGet(ArrayList<IInventory> chests, ItemStack whatItem, boolean getRandomItem, boolean compareMeta, ItemStack ignoreId) {
        ItemStack retStack = null;
        try {
            for (int c = 0; c < chests.size(); ++c) {
                IInventory chest = chests.get(c);
                retStack = Job.inventoryGet(chest, whatItem, getRandomItem, compareMeta);
                if (retStack == null) continue;
                return retStack;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack inventoriesGet(ArrayList<IInventory> chests, ItemStack whatItem, boolean getRandomItem, boolean compareMeta) {
        ItemStack retStack = null;
        try {
            for (int c = 0; c < chests.size(); ++c) {
                IInventory chest = chests.get(c);
                retStack = Job.inventoryGet(chest, whatItem, getRandomItem, compareMeta);
                if (retStack == null) continue;
                return retStack;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ItemStack inventoryGet(IInventory chest, ItemStack whatItem, boolean getRandomItem, boolean compareMeta, ItemStack ignoreId) {
        try {
            if (whatItem == null) {
                if (getRandomItem) {
                    ItemStack returnStack = null;
                    ArrayList<Integer> slots = new ArrayList<Integer>();
                    for (int i = 0; i < chest.func_70302_i_(); ++i) {
                        ItemStack chestStack = chest.func_70301_a(i);
                        if (chestStack == null) continue;
                        slots.add(i);
                    }
                    if (slots.size() == 0) {
                        return null;
                    }
                    returnStack = chest.func_70301_a(new Random().nextInt(slots.size()));
                    return returnStack;
                }
                ItemStack returnStack = null;
                for (int g = 0; g < chest.func_70302_i_(); ++g) {
                    ItemStack chestStackStack = chest.func_70301_a(g);
                    if (chestStackStack == null) continue;
                    returnStack = chestStackStack.func_77946_l();
                    chest.func_70299_a(g, (ItemStack)null);
                    return returnStack;
                }
                return returnStack;
            }
            ItemStack returnStack = whatItem.func_77946_l();
            returnStack.field_77994_a = 0;
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                boolean ignore = false;
                ItemStack chestStack = chest.func_70301_a(g);
                if (ignoreId != null && chestStack == ignoreId) {
                    ignore = true;
                }
                if (chestStack == null || ignore) continue;
                if (!compareMeta) {
                    chestStack.func_77964_b(whatItem.func_77960_j());
                }
                if (!chestStack.func_77969_a(whatItem)) continue;
                while (chestStack.field_77994_a >= 1) {
                    ++returnStack.field_77994_a;
                    --chestStack.field_77994_a;
                    if (chestStack.field_77994_a <= 0) {
                        chest.func_70299_a(g, (ItemStack)null);
                    }
                    if (returnStack.field_77994_a != whatItem.field_77994_a) continue;
                    return returnStack;
                }
            }
            if (returnStack.field_77994_a > 0) {
                return returnStack;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ItemStack inventoryGet(IInventory chest, ItemStack whatItem, boolean getRandomItem, boolean compareMeta) {
        try {
            if (whatItem == null) {
                if (getRandomItem) {
                    ItemStack returnStack = null;
                    ArrayList<Integer> slots = new ArrayList<Integer>();
                    for (int i = 0; i < chest.func_70302_i_(); ++i) {
                        ItemStack chestStack = chest.func_70301_a(i);
                        if (chestStack == null) continue;
                        slots.add(i);
                    }
                    if (slots.size() == 0) {
                        return null;
                    }
                    returnStack = chest.func_70301_a(new Random().nextInt(slots.size()));
                    return returnStack;
                }
                ItemStack returnStack = null;
                for (int g = 0; g < chest.func_70302_i_(); ++g) {
                    ItemStack chestStackStack = chest.func_70301_a(g);
                    if (chestStackStack == null) continue;
                    returnStack = chestStackStack.func_77946_l();
                    chest.func_70299_a(g, (ItemStack)null);
                    return returnStack;
                }
                return returnStack;
            }
            ItemStack returnStack = whatItem.func_77946_l();
            returnStack.field_77994_a = 0;
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                boolean ignore = false;
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack == null || ignore) continue;
                if (!compareMeta) {
                    chestStack.func_77964_b(whatItem.func_77960_j());
                }
                if (!chestStack.func_77969_a(whatItem)) continue;
                while (chestStack.field_77994_a >= 1) {
                    ++returnStack.field_77994_a;
                    --chestStack.field_77994_a;
                    if (chestStack.field_77994_a <= 0) {
                        chest.func_70299_a(g, (ItemStack)null);
                    }
                    if (returnStack.field_77994_a != whatItem.field_77994_a) continue;
                    return returnStack;
                }
            }
            if (returnStack.field_77994_a > 0) {
                return returnStack;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean inventoriesPut(ArrayList<IInventory> chests, ItemStack inStack, boolean doOpenClose) {
        boolean placedOK = false;
        try {
            for (int i = 0; i < chests.size(); ++i) {
                IInventory chest = chests.get(i);
                if (doOpenClose) {
                    this.openCloseChest(chest, 2000);
                }
                if (!(placedOK = Job.inventoryPut(chest, inStack))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return placedOK;
    }

    public static boolean inventoriesPut(ArrayList<IInventory> chests, ItemStack inStack) {
        boolean placedOK = false;
        try {
            IInventory chest;
            for (int i = 0; i < chests.size() && !(placedOK = Job.inventoryPut(chest = chests.get(i), inStack)); ++i) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return placedOK;
    }

    public boolean inventoriesTransferFromFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> toChests, ItemStack specificItems) {
        boolean placed = false;
        boolean okToPlace = false;
        try {
            for (int i = 0; i < folkInventory.size(); ++i) {
                try {
                    ItemStack folkStack = folkInventory.get(i);
                    okToPlace = specificItems != null && specificItems.func_77973_b() == folkStack.func_77973_b() ? true : specificItems == null;
                    if (!okToPlace || (placed = this.inventoriesPut(toChests, folkStack, true))) continue;
                    ModSimReloaded.log.warning("Job: \u65e0\u6cd5\u653e\u7f6e\u4e00\u5806 " + folkStack.func_82833_r() + " in chest");
                    return false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            folkInventory.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean inventoriesTransferToFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> fromChests, ItemStack whatItems, Block ignoreId) {
        boolean ret = false;
        int limit = 0;
        ItemStack got = null;
        try {
            for (int c = 0; c < fromChests.size(); ++c) {
                IInventory chest = fromChests.get(c);
                this.openCloseChest(chest, 2000);
            }
            do {
                if ((got = Job.inventoriesGet(fromChests, whatItems, false, false)) == null) continue;
                folkInventory.add(got);
                ret = true;
            } while (got != null && ++limit < 27);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int inventoriesTransferLimitedToFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> fromChests, ItemStack whatItems, int getQty, boolean doCompareMeta) {
        int gotSoFar = 0;
        Iterator<IInventory> i$ = fromChests.iterator();
        try {
            block2: while (i$.hasNext()) {
                IInventory chest = i$.next();
                for (int g = 0; g < chest.func_70302_i_(); ++g) {
                    boolean gotMatch = false;
                    ItemStack chestStack = chest.func_70301_a(g);
                    if (chestStack != null && chestStack == whatItems) {
                        if (doCompareMeta) {
                            if (chestStack.func_77960_j() == whatItems.func_77960_j()) {
                                gotMatch = true;
                            }
                        } else {
                            gotMatch = true;
                        }
                    }
                    if (gotMatch) {
                        while (gotSoFar < getQty && chestStack.field_77994_a > 0) {
                            ++gotSoFar;
                            --chestStack.field_77994_a;
                            folkInventory.add(new ItemStack(Block.func_149634_a((Item)chestStack.func_77973_b()), 1, chestStack.func_77960_j()));
                        }
                        if (chestStack.field_77994_a > 0) {
                            chest.func_70299_a(g, chestStack);
                        } else {
                            chest.func_70299_a(g, (ItemStack)null);
                        }
                    }
                    if (gotSoFar == getQty) continue block2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gotSoFar;
    }

    public int getItemCountInChests(ArrayList<IInventory> chests, ItemStack is, boolean doCompareMeta) {
        int ret = 0;
        Iterator<IInventory> i$ = chests.iterator();
        try {
            while (i$.hasNext()) {
                IInventory chest = i$.next();
                for (int g = 0; g < chest.func_70302_i_(); ++g) {
                    ItemStack chestStack = chest.func_70301_a(g);
                    if (chestStack == null || chestStack != is) continue;
                    if (!doCompareMeta) {
                        ret += chestStack.field_77994_a;
                        continue;
                    }
                    if (chestStack.func_77960_j() != is.func_77960_j()) continue;
                    ret += chestStack.field_77994_a;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public ArrayList<ItemStack> translateBlockWhenMined(World world, V3 location) {
        ArrayList itemStacks = new ArrayList();
        try {
            int i = location.x.intValue();
            int j = location.y.intValue();
            int k = location.z.intValue();
            Block block = world.func_147439_a(i, j, k);
            if (block == null) {
                return null;
            }
            int meta = world.func_72805_g(i, j, k);
            itemStacks = block.getDrops(world, i, j, k, meta, 0);
            return itemStacks;
        }
        catch (Exception exception) {
            return itemStacks;
        }
    }

    public void openCloseChest(IInventory chest, int msDelay) {
        try {
            chest.func_70295_k_();
            this.chestToClose = chest;
            this.chestToCloseWhen = System.currentTimeMillis() + (long)msDelay;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setClosestBlocksOfType(final V3 startXYZ, final ArrayList<Block> blockIDs, final int distanceLimit, final boolean needsToSeeSky, final boolean scanDownwards, final boolean oneLayerOnly) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
                    HashMap<String, V3> hm = new HashMap<String, V3>();
                    boolean skip = false;
                    int YdistanceLimit = distanceLimit;
                    if (oneLayerOnly) {
                        YdistanceLimit = 0;
                    }
                    for (int yo = 0; yo <= YdistanceLimit; ++yo) {
                        for (int d = 1; d < distanceLimit; ++d) {
                            for (int xo = -d; xo <= d; ++xo) {
                                for (int zo = -d; zo <= d; ++zo) {
                                    int sx = startXYZ.x.intValue() + xo;
                                    int sy = scanDownwards ? startXYZ.y.intValue() - yo : startXYZ.y.intValue() + yo;
                                    int sz = startXYZ.z.intValue() + zo;
                                    skip = false;
                                    for (int b = 0; b < blockIDs.size(); ++b) {
                                        V3 v;
                                        Block blockID = (Block)blockIDs.get(b);
                                        if (theWorld == null) {
                                            return;
                                        }
                                        Block blockInWorld = theWorld.func_147439_a(sx, sy, sz);
                                        if (blockInWorld != blockID) continue;
                                        if (needsToSeeSky) {
                                            boolean canSeeSky = theWorld.func_147439_a(sx, sy + 1, sz) == null;
                                            skip = !canSeeSky;
                                        }
                                        if (skip || hm.containsKey((v = new V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension)).toString())) continue;
                                        hm.put(v.toString(), v);
                                    }
                                }
                            }
                        }
                    }
                    Job.this.closestBlocks = new ArrayList(hm.values());
                    Job.this.step = 3;
                }
            });
            t.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayList<IInventory> inventoriesFindClosest(V3 startXYZ, int searchDistance) {
        ArrayList<IInventory> ret = new ArrayList<IInventory>();
        try {
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            TileEntity te = theWorld.func_147438_o(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue());
            if (te != null && te instanceof IInventory && !(te instanceof TileEntityFurnace) && !(te instanceof TileEntityWindmill)) {
                ret.add((IInventory)te);
            }
            for (int d = 1; d < searchDistance; ++d) {
                for (int yo = -d; yo <= d; ++yo) {
                    for (int xo = -d; xo <= d; ++xo) {
                        for (int zo = -d; zo <= d; ++zo) {
                            int sz;
                            int sy;
                            int sx = startXYZ.x.intValue() + xo;
                            te = theWorld.func_147438_o(sx, sy = startXYZ.y.intValue() + yo, sz = startXYZ.z.intValue() + zo);
                            if (te == null || !(te instanceof IInventory) || te instanceof TileEntityWindmill || Job.alreadyGotChest(ret, (IInventory)te)) continue;
                            ret.add((IInventory)te);
                        }
                    }
                }
            }
            return ret;
        }
        catch (Exception var12) {
            return ret;
        }
    }

    private static boolean alreadyGotChest(ArrayList<IInventory> chests, IInventory chest) {
        boolean ret = false;
        Iterator<IInventory> i$ = chests.iterator();
        try {
            while (i$.hasNext()) {
                IInventory ch = i$.next();
                if (!ch.toString().contentEquals(chest.toString())) continue;
                ret = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static V3 findAdjacentSpace(V3 startXYZ, World world) {
        V3 test = null;
        try {
            World theWorld = world;
            if (world == null) {
                theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            }
            test = startXYZ.clone();
            test = new V3(test.x + 1.0, test.y, test.z, test.theDimension);
            if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
                return test;
            }
            test = startXYZ.clone();
            test = new V3(test.x - 1.0, test.y, test.z, test.theDimension);
            if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
                return test;
            }
            test = startXYZ.clone();
            test = new V3(test.x + 1.0, test.y, test.z, test.theDimension);
            if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
                return test;
            }
            test = startXYZ.clone();
            test = new V3(test.x, test.y, test.z - 1.0, test.theDimension);
            return theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue()) ? test : startXYZ;
        }
        catch (Exception exception) {
            return startXYZ;
        }
    }

    public static V3 findClosestBlockType(V3 startXYZ, Block block, int searchDistance, boolean mustSeeSky) {
        try {
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            if (theWorld.func_147439_a(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue()) == block) {
                return startXYZ;
            }
            for (int d = 1; d < searchDistance; ++d) {
                for (int yo = -searchDistance; yo <= searchDistance; ++yo) {
                    for (int xo = -d; xo <= d; ++xo) {
                        for (int zo = -d; zo <= d; ++zo) {
                            int sz;
                            int sy;
                            int sx = startXYZ.x.intValue() + xo;
                            if (theWorld.func_147439_a(sx, sy = startXYZ.y.intValue() + yo, sz = startXYZ.z.intValue() + zo) != block) continue;
                            V3 ret = new V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension);
                            return ret;
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static V3 findClosestBlockType(V3 startXYZ, Block block, int searchDistance) {
        try {
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            if (theWorld.func_147439_a(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue()) == block) {
                return startXYZ;
            }
            for (int d = 1; d < searchDistance; ++d) {
                for (int xo = -d; xo <= d; ++xo) {
                    for (int zo = -d; zo <= d; ++zo) {
                        int sz;
                        int sy;
                        int sx = startXYZ.x.intValue() + xo;
                        if (theWorld.func_147439_a(sx, sy = startXYZ.y.intValue(), sz = startXYZ.z.intValue() + zo) != block) continue;
                        V3 ret = new V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension);
                        return ret;
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ArrayList<V3> findClosestBlocks(V3 startXYZ, Block block, int distanceLimit) {
        ArrayList<V3> blocksFound = new ArrayList<V3>();
        ArrayList<V3> retblocksFound = new ArrayList<V3>();
        try {
            int i;
            int sx;
            int ci;
            int count = 0;
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            for (ci = -distanceLimit; ci <= distanceLimit; ++ci) {
                for (int xo = -distanceLimit; xo <= distanceLimit; ++xo) {
                    for (int zo = -distanceLimit; zo <= distanceLimit; ++zo) {
                        try {
                            V3 v;
                            sx = startXYZ.x.intValue() + xo;
                            i = startXYZ.y.intValue() + ci;
                            int sz = startXYZ.z.intValue() + zo;
                            ++count;
                            if (theWorld.func_147439_a(sx, i, sz) != block || blocksFound.contains(v = new V3(Double.valueOf(sx), Double.valueOf(i), Double.valueOf(sz), startXYZ.theDimension))) continue;
                            blocksFound.add(v);
                            continue;
                        }
                        catch (Exception sz) {
                            // empty catch block
                        }
                    }
                }
            }
            ci = 0;
            double cd = 999.0;
            for (sx = 0; sx < blocksFound.size(); ++sx) {
                V3 v = (V3)blocksFound.get(sx);
                double distance = Math.sqrt((v.x - startXYZ.x) * (v.x - startXYZ.x) + (v.z - startXYZ.z) * (v.z - startXYZ.z));
                if (!(distance < cd)) continue;
                cd = distance;
                ci = sx;
            }
            if (blocksFound.size() > 0) {
                retblocksFound.add((V3)blocksFound.get(ci));
                for (i = 0; i < blocksFound.size(); ++i) {
                    if (i == ci) continue;
                    retblocksFound.add((V3)blocksFound.get(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retblocksFound;
    }

    public boolean mineBlockIntoChests(ArrayList<IInventory> chests, V3 blockXYZ) {
        boolean ret = false;
        try {
            ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, blockXYZ);
            if (minedStacks != null) {
                for (int s = 0; s < minedStacks.size(); ++s) {
                    ItemStack stack = minedStacks.get(s);
                    if (stack == null) continue;
                    this.inventoriesPut(chests, stack, false);
                }
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int getAnimalCountInPen(V3 controlBox, Class animal) {
        int i = 0;
        try {
            List list = this.jobWorld.func_72872_a(animal, AxisAlignedBB.func_72330_a((double)controlBox.x, (double)controlBox.y, (double)controlBox.z, (double)(controlBox.x + 1.0), (double)(controlBox.y + 1.0), (double)(controlBox.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
            if (list != null) {
                i = list.size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static V3 getNearestBuildingForFolk(String searchWord, FolkData folk) {
        new ArrayList();
        Building shortestDist = null;
        try {
            for (int x = 0; x < ModSimReloaded.theBuildings.size(); ++x) {
                Building b = ModSimReloaded.theBuildings.get(x);
                if (!b.displayName.toLowerCase().contains(searchWord.toLowerCase())) continue;
                if (shortestDist.primaryXYZ == null) {
                    shortestDist = b;
                }
                if (folk.location.getDistanceTo(shortestDist.primaryXYZ) >= b.primaryXYZ.getDistanceTo(folk.location)) continue;
                shortestDist = b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shortestDist.primaryXYZ;
    }
}

