/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.block.functionality.FarmingBox;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.enums.FarmType;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobBaker
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112153304279141L;
    public Vocation vocation = null;
    public Stage theStage;
    public FolkData theFolk;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> bakeryChests = null;
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient FarmingBox farm = null;

    public JobBaker() {
    }

    public JobBaker(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.runDelay = 10000;
            }
            if (this.theStage == Stage.COLLECTINGWHEAT) {
                this.runDelay = 1000;
            }
            if (this.theStage == Stage.SELLINGBREAD) {
                this.runDelay = 10000;
            }
            if (this.theStage == Stage.MAKEBREAD) {
                this.runDelay = 10000;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATSHOP) {
                        this.theStage = Stage.GOINGTOWHEATFARM;
                        this.step = 1;
                    } else if (this.theStage == Stage.GOINGTOWHEATFARM) {
                        this.stageGoingToWheatFarm();
                    } else if (this.theStage == Stage.COLLECTINGWHEAT) {
                        this.stageCollectingWheat();
                    } else if (this.theStage == Stage.GOBACKTOBAKERY) {
                        this.stageGoBackToBakery();
                    } else if (this.theStage == Stage.MAKEBREAD) {
                        this.stageMakeBread();
                    } else if (this.theStage == Stage.SELLINGBREAD) {
                        this.stageSellingBread();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToWheatFarm() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Fetching", (Object[])new Object[0]);
            if (this.theFolk.destination == null && this.step == 1) {
                this.farm = this.getCurrentFarm();
                if (this.farm == null) {
                    this.theStage = Stage.GOBACKTOBAKERY;
                    this.step = 1;
                } else {
                    this.theFolk.gotoXYZ(this.farm.getLocation(), null);
                    this.runDelay = 1000;
                    this.step = 2;
                }
            }
            if (this.step == 2) {
                double dist = 0.0;
                if (this.farm != null) {
                    this.runDelay = 1000;
                    if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                        this.theFolk.updateLocationFromEntity();
                    }
                    if ((dist = (double)this.theFolk.location.getDistanceTo(this.farm.getLocation())) <= 1.0) {
                        this.theStage = Stage.COLLECTINGWHEAT;
                        this.step = 1;
                        this.theFolk.stayPut = true;
                        if (this.theFolk.theEntity != null) {
                            this.theFolk.theEntity.field_70159_w = 0.0;
                            this.theFolk.theEntity.field_70179_y = 0.0;
                        }
                        this.runDelay = 1000;
                        return;
                    }
                } else {
                    this.theStage = Stage.GOBACKTOBAKERY;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCollectingWheat() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Collecting", (Object[])new Object[0]);
            this.runDelay = 1000;
            if (this.step == 1) {
                this.farmChests = JobBaker.inventoriesFindClosest(this.farm.getLocation(), 5);
                if (this.farmChests.size() > 0) {
                    this.farmChests.get(0).func_70295_k_();
                    this.step = 2;
                }
            } else if (this.step == 2) {
                this.farmChests = JobBaker.inventoriesFindClosest(this.farm.getLocation(), 5);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151015_O, 640), Blocks.field_150350_a);
                this.step = 3;
            } else if (this.step == 3) {
                this.farmChests.get(0).func_70305_f();
                this.theStage = Stage.GOINGTOWHEATFARM;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoBackToBakery() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Taking", (Object[])new Object[0]);
            if (this.theFolk.destination == null && this.step == 1) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                this.runDelay = 100;
                this.step = 2;
            }
            if (this.step == 2) {
                int dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1) {
                    this.theStage = Stage.MAKEBREAD;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageMakeBread() {
        block12: {
            try {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Baking_bread", (Object[])new Object[0]);
                this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
                if (this.bakeryChests != null && this.bakeryChests.size() != 0) {
                    if (this.step == 1) {
                        this.theFolk.updateLocationFromEntity();
                        int wheat = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                        if (wheat > 1) {
                            this.theFolk.beamMeTo(this.theFolk.employedAt);
                        }
                        this.step = 2;
                        break block12;
                    }
                    if (this.step == 2) {
                        int wheat = this.getInventoryCount(this.theFolk, Items.field_151015_O);
                        int bread = (int)Math.floor(wheat / 3);
                        this.pay = (float)((double)bread * 0.2);
                        this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
                        try {
                            this.bakeryChests.get(0).func_70295_k_();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.inventoriesPut(this.bakeryChests, new ItemStack(Items.field_151025_P, bread), true);
                        this.theFolk.inventory.clear();
                        this.step = 3;
                        break block12;
                    }
                    if (this.step == 3) {
                        this.bakeryChests.get(0).func_70305_f();
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Selling", (Object[])new Object[0]);
                        this.theFolk.stayPut = true;
                        if (this.theFolk.theEntity != null) {
                            if (this.theFolk.gender == 0) {
                                this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:bakerm", 1.0f, 1.0f, false);
                            } else {
                                this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:bakerf", 1.0f, 1.0f, false);
                            }
                        }
                        this.theStage = Stage.SELLINGBREAD;
                        this.step = 1;
                    }
                    break block12;
                }
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Who", (Object[])new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageSellingBread() {
        try {
            if (this.step == 1) {
                if (this.pay > 0.0f) {
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits -= this.pay;
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.Baker_paid", (Object[])new Object[0]) + ModSimReloaded.displayMoney(this.pay) + I18n.func_135052_a((String)"container.sim.job.credits", (Object[])new Object[0]));
                    this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
                }
                this.step = 2;
                return;
            }
            if (this.step == 2) {
                if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L <= 11600L) return;
                this.step = 3;
                return;
            }
            if (this.step == 3) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Closing", (Object[])new Object[0]);
                ItemStack breadStack = null;
                if (ModSimReloaded.theFolks.size() > 1) {
                    int sell = ModSimReloaded.theFolks.size() + 1 + new Random().nextInt(ModSimReloaded.theFolks.size());
                    this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
                    breadStack = JobBaker.inventoriesGet(this.bakeryChests, new ItemStack(Items.field_151025_P, sell), false, false);
                }
                if (breadStack == null) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.Baker_today", (Object[])new Object[0]));
                } else {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.has_sold", (Object[])new Object[0]) + breadStack.field_77994_a + I18n.func_135052_a((String)"container.sim.job.folks_today", (Object[])new Object[0]));
                    for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
                        FolkData folk = ModSimReloaded.theFolks.get(f);
                        if (breadStack.field_77994_a <= 0) continue;
                        folk.levelFood = 10;
                        --breadStack.field_77994_a;
                    }
                }
                this.step = 4;
                return;
            }
            if (this.step != 4) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FarmingBox getCurrentFarm() {
        boolean found = false;
        try {
            while (!found) {
                try {
                    FarmingBox farm = ModSimReloaded.theFarmingBoxes.get(this.currentFarmNum);
                    if (farm.farmType == FarmType.WHEAT) {
                        found = true;
                        ++this.currentFarmNum;
                        return farm;
                    }
                    ++this.currentFarmNum;
                    if (this.currentFarmNum <= ModSimReloaded.theFarmingBoxes.size() - 1) continue;
                    return null;
                }
                catch (Exception var4) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Baker_Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSHOP;
                this.currentFarmNum = 0;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

