/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.EntityConBox;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ConfigLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import com.trhsy.sim.util.GameMode;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class JobBuilder
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177665807904279141L;
    public Stage theStage;
    public FolkData theFolk = null;
    public Vocation vocation = null;
    public int runDelay = 1000;
    public long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> constructorChests = new ArrayList();
    private transient Building theBuilding = null;
    private transient EntityConBox theConBox = null;
    private transient long lastNotifiedOfMaterials = 0L;
    private transient long soundLastPlayed = 0L;
    int l = 0;
    int ftb = 0;
    int ltr = 0;
    int xo = 0;
    int zo = 0;
    int acount = 0;
    int cx;
    int cy;
    int cz;
    int ex;
    int ey;
    int ez;
    int bx = 0;
    int by = 0;
    int bz = 0;

    public JobBuilder() {
    }

    public JobBuilder(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null) {
                if (this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
                this.theBuilding = this.theFolk.theBuilding;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            if (this.theFolk != null) {
                super.onUpdate();
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.WAITINGFORRESOURCES) {
                    this.runDelay = 3000;
                    if (this.theBuilding != null) {
                        // empty if block
                    }
                }
                if (this.theStage == Stage.INPROGRESS && this.step == 1) {
                    this.runDelay = (int)(2000.0f / this.theFolk.levelBuilder);
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    this.timeSinceLastRun = System.currentTimeMillis();
                    if (this.theFolk.theirJob != null && this.theFolk.vocation != Vocation.BUILDER) {
                        this.theFolk.selfFire();
                    } else {
                        this.theFolk.updateLocationFromEntity();
                        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                        if (dist <= 3 && this.theStage == Stage.WORKERASSIGNED) {
                            this.theFolk.action = FolkAction.ATWORK;
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_Arrived", (Object[])new Object[0]);
                            this.theStage = Stage.BLUEPRINT;
                        }
                        if (dist < 10 && this.theStage == Stage.WORKERASSIGNED && this.theFolk.destination == null) {
                            this.theFolk.action = FolkAction.ATWORK;
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_Arrived", (Object[])new Object[0]);
                            this.theStage = Stage.BLUEPRINT;
                        }
                        if ((this.theStage == Stage.IDLE || this.theStage == Stage.WORKERASSIGNED) && ModSimReloaded.isDayTime()) {
                            if (this.theFolk.action != FolkAction.ONWAYTOWORK) {
                                this.theStage = Stage.WORKERASSIGNED;
                            }
                        } else if (this.theStage != Stage.WORKERASSIGNED) {
                            if (this.theStage == Stage.BLUEPRINT) {
                                this.stageBlueprint();
                            } else if (this.theStage == Stage.WAITINGFORRESOURCES) {
                                this.stageWaitingForResources();
                            } else if (this.theStage == Stage.INPROGRESS) {
                                this.stageInProgress();
                            } else if (this.theStage == Stage.COMPLETE) {
                                this.stageComplete();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageBlueprint() {
        try {
            this.theBuilding = this.theFolk.theBuilding;
            if (this.theBuilding == null) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_building", (Object[])new Object[0]);
            } else {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_blueprints", (Object[])new Object[0]);
                this.theFolk.updateLocationFromEntity();
                double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (dist < 4.0) {
                    this.theFolk.stayPut = true;
                }
                if (ConfigLoader.configFolkTalking) {
                    if (this.theFolk.gender == 0) {
                        this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readym", 1.0f, 1.0f, false);
                    } else {
                        this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readyf", 1.0f, 1.0f, false);
                    }
                }
                this.theStage = Stage.WAITINGFORRESOURCES;
                this.step = 1;
                if (this.theConBox == null) {
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.theFolk.location.theDimension);
                    this.theConBox = new EntityConBox((World)world);
                    this.theConBox.theFolk = this.theFolk;
                    this.theConBox.func_70012_b(this.theFolk.employedAt.x + 2.0, this.theFolk.employedAt.y, this.theFolk.employedAt.z, 0.0f, 0.0f);
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)this.theConBox);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaitingForResources() {
        block15: {
            try {
                this.theFolk.isWorking = false;
                if (this.step == 1) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_Checking", (Object[])new Object[0]);
                    this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                    if (this.constructorChests.size() == 0) {
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_constructor_block", (Object[])new Object[0]);
                    } else {
                        try {
                            this.constructorChests.get(0).func_70295_k_();
                        }
                        catch (Exception var2) {
                            ModSimReloaded.log.warning("JobBuilder:JobBuilder's \u7684\u7bb1\u5b50\u662f\u7a7a\u7684");
                        }
                        this.step = 2;
                    }
                    int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                    if (dist < 5) {
                        this.theFolk.stayPut = true;
                    }
                    break block15;
                }
                if (this.step == 2) {
                    this.constructorChests.get(0).func_70305_f();
                    this.theStage = Stage.INPROGRESS;
                    this.step = 1;
                } else if (this.step == 3) {
                    int dist;
                    if (this.theFolk.vocation != Vocation.BUILDER) {
                        this.theFolk.selfFire();
                        return;
                    }
                    this.step = 2;
                    this.theStage = Stage.INPROGRESS;
                    if (this.theFolk.isSpawned()) {
                        this.theFolk.updateLocationFromEntity();
                    }
                    if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) < 5) {
                        this.theFolk.stayPut = true;
                    } else {
                        this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageInProgress() {
        block76: {
            try {
                Block blockId = null;
                boolean alreadyPlaced = false;
                this.theFolk.updateLocationFromEntity();
                int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (dist > 5 && this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                    return;
                }
                if (this.step == 1) {
                    this.cx = this.theFolk.employedAt.x.intValue();
                    this.cy = this.theFolk.employedAt.y.intValue();
                    this.cz = this.theFolk.employedAt.z.intValue();
                    this.ex = this.theFolk.employedAt.x.intValue();
                    this.ey = this.theFolk.employedAt.y.intValue();
                    this.ez = this.theFolk.employedAt.z.intValue();
                    this.bx = this.ex;
                    this.by = this.ey;
                    this.bz = this.ez;
                    if (this.theBuilding.buildDirection.contentEquals("-x")) {
                        this.bx = this.cx + 1;
                    } else if (this.theBuilding.buildDirection.contentEquals("+x")) {
                        this.bx = this.cx - 1;
                    } else if (this.theBuilding.buildDirection.contentEquals("-z")) {
                        this.bz = this.cz + 1;
                    } else if (this.theBuilding.buildDirection.contentEquals("+z")) {
                        this.bz = this.cz - 1;
                    } else {
                        if (!this.theBuilding.buildDirection.contentEquals("+z")) {
                            ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.builder_constructor_direction", (Object[])new Object[0]));
                            this.theFolk.selfFire();
                            return;
                        }
                        this.bz = this.cz - 1;
                    }
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_building", (Object[])new Object[0]) + this.theBuilding.displayNameWithoutPK);
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_Building", (Object[])new Object[0]) + this.theBuilding.displayNameWithoutPK;
                    if (this.theBuilding == null || this.theBuilding.layerCount == 0) {
                        ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_misplaced", (Object[])new Object[0]));
                        return;
                    }
                    this.theFolk.stayPut = true;
                    if (this.theBuilding == null) {
                        this.theFolk.selfFire();
                        return;
                    }
                    this.l = 0;
                    this.ftb = 0;
                    this.ltr = 0;
                    this.acount = 0;
                    this.step = 2;
                    this.theBuilding.blockLocations.clear();
                    break block76;
                }
                if (this.step != 2) break block76;
                do {
                    block78: {
                        Block currBlockId;
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_Building", (Object[])new Object[0]) + this.theBuilding.displayNameWithoutPK;
                        if (this.theBuilding.buildDirection.contentEquals("+z")) {
                            this.xo = this.ltr;
                            this.zo = -this.ftb;
                        } else if (this.theBuilding.buildDirection.contentEquals("-z")) {
                            this.xo = -this.ltr;
                            this.zo = this.ftb;
                        } else if (this.theBuilding.buildDirection.contentEquals("+x")) {
                            this.xo = -this.ftb;
                            this.zo = -this.ltr;
                        } else if (this.theBuilding.buildDirection.contentEquals("-x")) {
                            this.xo = this.ftb;
                            this.zo = this.ltr;
                        }
                        if (this.theBuilding == null) {
                            this.theFolk.selfFire();
                            return;
                        }
                        String[] bl = null;
                        boolean st = false;
                        try {
                            bl = this.theBuilding.structure[this.acount].split(":");
                        }
                        catch (Exception var17) {
                            ModSimReloaded.log.warning("JobBuilder: \u5efa\u7b51\u4e2d\u7684\u7a7a\u5757,\u6539\u7528\u7a7a\u6c14");
                            bl = "0:0".split(":");
                        }
                        blockId = Block.func_149684_b((String)bl[0]);
                        int subtype = Integer.parseInt(bl[1]);
                        if (blockId == Blocks.field_150349_c) {
                            blockId = Blocks.field_150346_d;
                        }
                        if (this.theBuilding.type.contentEquals("other") && this.acount == 0) {
                            blockId = BlockLoader.blockOtherControlBox;
                            subtype = 2;
                        }
                        if (blockId == BlockLoader.blockControlBox) {
                            try {
                                this.theBuilding.primaryXYZ = new V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                                this.theBuilding.saveThisBuilding();
                            }
                            catch (Exception var16) {
                                ModSimReloaded.log.warning("JobBuilder:\u6784\u5efa\u4e3a\u7a7a");
                            }
                        }
                        if (blockId == BlockLoader.livingBlock && this.theBuilding.type == "residential") {
                            this.theBuilding.livingXYZ = new V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                            blockId = null;
                            subtype = 0;
                        } else if (blockId == BlockLoader.specialBlock && this.theBuilding.type != "residential") {
                            V3 v3 = new V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                            v3.meta = subtype;
                            this.theBuilding.blockSpecial.add(v3);
                            blockId = null;
                            subtype = 0;
                        }
                        int currBlockMeta = 0;
                        try {
                            currBlockId = this.jobWorld.func_147439_a(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                            currBlockMeta = this.jobWorld.func_72805_g(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                            alreadyPlaced = blockId == currBlockId || blockId == Blocks.field_150346_d && currBlockId == Blocks.field_150349_c || blockId == Blocks.field_150349_c && currBlockId == Blocks.field_150346_d;
                        }
                        catch (Exception var20) {
                            this.theFolk.selfFire();
                            ModSimReloaded.log.info("\u9519\u8bef:" + var20.getMessage());
                            return;
                        }
                        String want = "???";
                        ItemStack wantIS = new ItemStack(blockId, 1, 0);
                        if (wantIS != null && wantIS != null) {
                            try {
                                want = wantIS.func_82833_r();
                                if (blockId != null) {
                                    this.theBuilding.blockLocations.add(new V3(this.bx + this.xo, this.by + this.l, this.bz + this.zo, this.theFolk.location.theDimension));
                                }
                            }
                            catch (Exception var15) {
                                want = "?";
                                ModSimReloaded.log.warning("JobBuilder:wantItemStack \u4e3a\u7a7a, wantIS \u4e3a\u7a7a, blockID=" + blockId);
                            }
                        } else {
                            want = "???";
                        }
                        if (!alreadyPlaced && currBlockId != null) {
                            V3 blockToRemove = new V3(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                            this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                            this.mineBlockIntoChests(this.constructorChests, blockToRemove);
                            this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, Blocks.field_150350_a, 0, 3);
                            this.theFolk.isWorking = true;
                        }
                        if (!alreadyPlaced) {
                            ItemStack got;
                            boolean requiredBlocks;
                            boolean gotBlock = false;
                            boolean bl2 = requiredBlocks = blockId == Blocks.field_150344_f || blockId == Blocks.field_150347_e || blockId == Blocks.field_150359_w || blockId == Blocks.field_150325_L || blockId == Blocks.field_150336_V || blockId == Blocks.field_150346_d || blockId == Blocks.field_150417_aV || blockId == Blocks.field_150422_aJ || blockId == Blocks.field_150348_b || blockId == Blocks.field_150364_r;
                            if (GameMode.gameMode == GameMode.GAMEMODES.NORMAL) {
                                if (requiredBlocks) {
                                    this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                    got = JobBuilder.inventoriesGet(this.constructorChests, new ItemStack(blockId, 1, 0), false, false);
                                    gotBlock = got != null;
                                } else {
                                    gotBlock = true;
                                }
                            } else if (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE) {
                                gotBlock = true;
                            } else if (GameMode.gameMode == GameMode.GAMEMODES.HARDCORE) {
                                if (blockId != null) {
                                    if (blockId != Blocks.field_150349_c && blockId != Blocks.field_150355_j && blockId != Blocks.field_150355_j && blockId != Blocks.field_150353_l && blockId != Blocks.field_150353_l && blockId != Blocks.field_150444_as && blockId != Blocks.field_150414_aQ && blockId != Blocks.field_150333_U && blockId != Blocks.field_150376_bx && blockId != Blocks.field_150373_bw && blockId != Blocks.field_150334_T && blockId != Blocks.field_150458_ak && blockId != Blocks.field_150466_ao && blockId != Blocks.field_150454_av && blockId != Blocks.field_150324_C) {
                                        this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                        got = JobBuilder.inventoriesGet(this.constructorChests, new ItemStack(blockId, 1, 0), false, false);
                                        gotBlock = got != null;
                                        if (blockId == BlockLoader.blockControlBox) {
                                            gotBlock = true;
                                        }
                                    } else {
                                        gotBlock = true;
                                    }
                                } else {
                                    gotBlock = true;
                                }
                            }
                            if (!gotBlock) {
                                this.theStage = Stage.WAITINGFORRESOURCES;
                                if (want.toLowerCase().contentEquals(I18n.func_135052_a((String)"container.sim.sim_gui_BC11", (Object[])new Object[0]))) {
                                    want = I18n.func_135052_a((String)"container.sim.sim_gui_BC12", (Object[])new Object[0]);
                                }
                                if (want.toLowerCase().contentEquals(I18n.func_135052_a((String)"container.sim.sim_gui_BC9", (Object[])new Object[0]))) {
                                    want = I18n.func_135052_a((String)"container.sim.sim_gui_BC10", (Object[])new Object[0]);
                                }
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_Waiting", (Object[])new Object[0]) + want;
                                if (System.currentTimeMillis() - this.lastNotifiedOfMaterials > (long)(ConfigLoader.configMaterialReminderInterval * 60 * 1000)) {
                                    this.lastNotifiedOfMaterials = System.currentTimeMillis();
                                    ModSimReloaded.sendChat(this.theFolk.name + " ( " + I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_who's", (Object[])new Object[0]) + this.theFolk.theBuilding.displayNameWithoutPK + ")" + I18n.func_135052_a((String)"container.sim.job.builder_constructor_started_more", (Object[])new Object[0]) + want);
                                }
                                this.step = 3;
                                return;
                            }
                            try {
                                if (alreadyPlaced) break block78;
                                try {
                                    int aft;
                                    if (blockId == BlockLoader.livingBlock) {
                                        alreadyPlaced = true;
                                    }
                                    if (blockId == BlockLoader.blockATMControlBox && this.theBuilding.displayNameWithoutPK.toLowerCase().contentEquals(I18n.func_135052_a((String)"container.sim.ATMs", (Object[])new Object[0]))) {
                                        subtype = 1;
                                    }
                                    if (!alreadyPlaced) {
                                        this.theFolk.stayPut = true;
                                        this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, blockId, subtype, 3);
                                        this.jobWorld.func_147471_g(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                                    }
                                    int b4 = (int)Math.floor(this.theFolk.levelBuilder);
                                    if (this.theFolk.levelBuilder < 10.0f) {
                                        FolkData var10000 = this.theFolk;
                                        var10000.levelBuilder = (float)((double)var10000.levelBuilder + 0.001 / (double)b4);
                                    }
                                    if (b4 != (aft = (int)Math.floor(this.theFolk.levelBuilder))) {
                                        ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.builder_constructor_levelled", (Object[])new Object[0]) + aft);
                                    }
                                    if (System.currentTimeMillis() - this.soundLastPlayed >= 2000L) {
                                        this.mc.field_71441_e.func_72980_b((double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), "sim:construction", 1.0f, 1.0f, false);
                                        this.soundLastPlayed = System.currentTimeMillis();
                                    }
                                    if (this.mc.field_71441_e.field_72995_K) {
                                        this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.3f, 0.0);
                                        this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.2f, 0.0);
                                        this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.1f, 0.0);
                                    }
                                    if (blockId != null && GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && blockId != BlockLoader.livingBlock) {
                                        GameStates var25 = ModSimReloaded.states;
                                        var25.credits -= 0.02f;
                                    }
                                }
                                catch (Exception var18) {
                                    ModSimReloaded.log.warning("JobBuilder: \u53ef\u80fd\u4e0d\u5b58\u5728\u7684\u65b9\u5757\uff08\u6765\u81ea\u5176\u4ed6\u6a21\u7ec4\uff09ID=" + blockId);
                                    try {
                                        this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, blockId, 0, 3);
                                    }
                                    catch (Exception var14) {
                                        ModSimReloaded.log.warning("\u9519\u8bef\uff1a" + var14.getMessage());
                                    }
                                }
                            }
                            catch (Exception var19) {
                                ModSimReloaded.log.warning("\u9519\u8bef\uff1a" + var19.getMessage());
                            }
                        }
                    }
                    ++this.acount;
                    ++this.ltr;
                    if (this.ltr == this.theBuilding.ltrCount) {
                        this.ltr = 0;
                        ++this.ftb;
                        if (this.ftb == this.theBuilding.ftbCount) {
                            this.ftb = 0;
                            ++this.l;
                            if (this.l == this.theBuilding.layerCount) {
                                this.theStage = Stage.COMPLETE;
                                this.stageComplete();
                                return;
                            }
                        }
                    }
                    this.runDelay = blockId != null && !alreadyPlaced ? (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE ? 0 : (int)(2000.0f / this.theFolk.levelBuilder)) : 0;
                    if (this.theFolk.theEntity == null) continue;
                    this.theFolk.theEntity.func_71038_i();
                } while (blockId == null || alreadyPlaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageComplete() {
        try {
            int b;
            this.theFolk.isWorking = false;
            if (this.theBuilding != null) {
                if (this.theBuilding.buildingComplete) {
                    // empty if block
                }
                if (this.theBuilding != null) {
                    this.theBuilding.buildingComplete = true;
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.builder_constructor_completed", (Object[])new Object[0]) + this.theBuilding.displayNameWithoutPK);
                    ModSim.proxy.getClientWorld().func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
                    this.theBuilding.saveThisBuilding();
                    this.theFolk.theBuilding = null;
                } else {
                    ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.builder_constructor_Error", (Object[])new Object[0]) + this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.builder_constructor_was_building", (Object[])new Object[0]));
                }
            }
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.func_70095_a(false);
            }
            this.theFolk.stayPut = false;
            this.theFolk.selfFire();
            this.theStage = Stage.IDLE;
            boolean activeBuilders = false;
            for (b = 0; b < ModSimReloaded.theFolks.size(); ++b) {
                FolkData fd = ModSimReloaded.theFolks.get(b);
                if (fd.vocation != Vocation.BUILDER) continue;
                activeBuilders = true;
            }
            if (!activeBuilders) {
                for (b = 0; b < ModSimReloaded.theBuildings.size(); ++b) {
                    Building building = ModSimReloaded.theBuildings.get(b);
                    building.buildingComplete = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.builder_constructor_site", (Object[])new Object[0]);
                this.theStage = Stage.BLUEPRINT;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

