/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import net.minecraft.client.resources.I18n;

public class JobBuildersMerchant
extends Job
implements Serializable {
    private static final long serialVersionUID = 1177112214324279141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;

    public JobBuildersMerchant() {
    }

    public JobBuildersMerchant(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.INSTORE) {
                this.runDelay = 10000;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (!(this.theStage == Stage.IDLE && ModSimReloaded.isDayTime() || this.theStage != Stage.INSTORE)) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.serving_customers", (Object[])new Object[0]);
                    this.theFolk.updateLocationFromEntity();
                    double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                    if (dist > 5.0 && this.theFolk.destination == null) {
                        this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                    }
                    if (dist <= 5.0) {
                        this.theFolk.stayPut = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            this.theFolk.updateLocationFromEntity();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_at_the_store", (Object[])new Object[0]);
                this.theStage = Stage.INSTORE;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

