/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ItemLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobBurgersFryCook
extends Job {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;
    private ItemStack isMakeFood = null;
    private int tryMeta = 3;

    public JobBurgersFryCook(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (this.theStore == null) {
                this.theStore = Building.getBuilding(this.theFolk.employedAt);
            }
            if (this.theStore != null) {
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.ARRIVEDATSTORE) {
                    this.theFolk.action = FolkAction.ATWORK;
                    this.runDelay = 11000;
                } else {
                    this.runDelay = this.theStage == Stage.NOINGREDIANTS ? 30000 : (this.theStage == Stage.MAKEFOOD ? 15000 : 5000);
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.ARRIVEDATSTORE) {
                            this.theStage = Stage.MAKEFOOD;
                        } else if (this.theStage == Stage.MAKEFOOD) {
                            this.stageMakeFood();
                        } else if (this.theStage == Stage.NOINGREDIANTS) {
                            this.stageNoIngrediants();
                        }
                    }
                    if (!ModSimReloaded.isDayTime()) {
                        this.theStage = Stage.IDLE;
                    }
                    this.timeSinceLastRun = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageNoIngrediants() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_ingrediants", (Object[])new Object[0]);
            this.theStage = Stage.MAKEFOOD;
            this.step = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageMakeFood() {
        block30: {
            try {
                ArrayList<V3> ch = this.theStore.getSpecialBlocks(0);
                if (ch.isEmpty()) {
                    this.theStage = Stage.NOINGREDIANTS;
                    break block30;
                }
                ArrayList<IInventory> chestsIn = JobBurgersFryCook.inventoriesFindClosest(ch.get(0), 3);
                if (chestsIn.isEmpty()) {
                    this.theStage = Stage.NOINGREDIANTS;
                    break block30;
                }
                ArrayList<V3> ch2 = this.theStore.getSpecialBlocks(2);
                if (ch.isEmpty()) {
                    this.theStage = Stage.NOINGREDIANTS;
                    break block30;
                }
                ArrayList<IInventory> chestsOut = JobBurgersFryCook.inventoriesFindClosest(ch2.get(0), 3);
                if (chestsIn.isEmpty()) {
                    this.theStage = Stage.NOINGREDIANTS;
                    break block30;
                }
                ArrayList<V3> back = this.theStore.getSpecialBlocks(1);
                if (!back.isEmpty()) {
                    this.theFolk.gotoXYZ(back.get(0), null);
                    try {
                        this.theFolk.destination.destinationAcc = 0.3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.step == 1) {
                    if (this.tryMeta == 3) {
                        int c = this.getItemCountInChests(chestsIn, new ItemStack(ItemLoader.itemFoods, 1, 0), true);
                        if (c == 0) {
                            this.tryMeta = 1;
                            return;
                        }
                        c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151082_bd, 1), false);
                        if (c == 0) {
                            this.tryMeta = 2;
                            return;
                        }
                        c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151025_P, 1), false);
                        if (c == 0) {
                            this.tryMeta = 2;
                            return;
                        }
                        this.isMakeFood = new ItemStack(ItemLoader.itemFoods, 1, 3);
                        this.step = 2;
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_Cooking", (Object[])new Object[0]);
                    } else if (this.tryMeta == 1) {
                        int c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151082_bd, 1), false);
                        if (c == 0) {
                            this.tryMeta = 2;
                            return;
                        }
                        c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151025_P, 1), false);
                        if (c == 0) {
                            this.tryMeta = 2;
                            return;
                        }
                        this.isMakeFood = new ItemStack(ItemLoader.itemFoods, 1, 1);
                        this.step = 2;
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_Hamburger", (Object[])new Object[0]);
                    } else if (this.tryMeta == 2) {
                        int c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151174_bG), false);
                        if (c == 0) {
                            this.tryMeta = 3;
                            return;
                        }
                        this.isMakeFood = new ItemStack(ItemLoader.itemFoods, 1, 2);
                        this.step = 2;
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_Fries", (Object[])new Object[0]);
                    }
                    if (this.step == 1) {
                        this.theStage = Stage.NOINGREDIANTS;
                    } else {
                        this.theFolk.isWorking = true;
                    }
                } else if (this.step == 2) {
                    if (this.isMakeFood.func_77960_j() == 3) {
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(ItemLoader.itemFoods, 1, 0), false, true);
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151025_P, 1), false, false);
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151082_bd, 1), false, false);
                        this.tryMeta = 1;
                    } else if (this.isMakeFood.func_77960_j() == 1) {
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151025_P, 1), false, false);
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151082_bd, 1), false, false);
                        this.tryMeta = 2;
                    } else if (this.isMakeFood.func_77960_j() == 2) {
                        JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151174_bG, 1), false, false);
                        this.tryMeta = 3;
                    }
                    this.inventoriesPut(chestsOut, this.isMakeFood, true);
                    this.theFolk.isWorking = false;
                    this.step = 1;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_Checking_Ingrediants", (Object[])new Object[0]);
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits = (float)((double)var10000.credits - 0.45);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_at_the_store", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSTORE;
                ArrayList<V3> back = this.theStore.getSpecialBlocks(1);
                if (!back.isEmpty()) {
                    this.theFolk.gotoXYZ(back.get(0), null);
                    this.step = 1;
                }
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

