/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ItemLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JobBurgersManager
extends Job {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;
    private int currentPickup = 0;
    private ArrayList<Building> pickupBuildings = new ArrayList();

    public JobBurgersManager(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (this.theStore == null) {
                this.theStore = Building.getBuilding(this.theFolk.employedAt);
            }
            if (this.theStore != null) {
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.ARRIVEDATSTORE) {
                    this.theFolk.action = FolkAction.ATWORK;
                    this.runDelay = 11000;
                } else {
                    this.runDelay = this.theStage == Stage.HANGINGOUT ? 30000 : 5000;
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.ARRIVEDATSTORE) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.Checking", (Object[])new Object[0]);
                            this.theStage = Stage.PICKUPBAKERY;
                            this.step = 1;
                        } else if (this.theStage == Stage.PICKUPBAKERY) {
                            this.stagePickupBakery();
                        } else if (this.theStage == Stage.PICKUPGROCERY) {
                            this.stagePickupGrocery();
                        } else if (this.theStage == Stage.PICKUPCHEESE) {
                            this.stagePickupCheese();
                        } else if (this.theStage == Stage.PICKUPBUTCHERS) {
                            this.stagePickupButchers();
                        } else if (this.theStage == Stage.DROPOFF) {
                            this.stageDropoff();
                        } else if (this.theStage == Stage.HANGINGOUT) {
                            this.stageHangingOut();
                        }
                    }
                    if (!ModSimReloaded.isDayTime()) {
                        this.theStage = Stage.IDLE;
                    }
                    this.timeSinceLastRun = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doPickup(String buildingSearch, Block pickUpItem, boolean doCompareMeta) {
        try {
            if (this.step == 1) {
                this.currentPickup = 0;
                this.pickupBuildings.clear();
                this.pickupBuildings = Building.getBuildingBySearch(buildingSearch, true);
                if (this.pickupBuildings.size() == 0) {
                    this.step = 4;
                    return;
                }
                this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.On_my", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                this.step = 2;
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                }
            } else if (this.step == 3) {
                int count;
                int buy;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.Buying", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                ArrayList<IInventory> chests = JobBurgersManager.inventoriesFindClosest(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, 5);
                if (!chests.isEmpty() && (buy = (count = this.getItemCountInChests(chests, new ItemStack(pickUpItem, 1), doCompareMeta)) / 4) > 0) {
                    ModSimReloaded.log.info("JobBurgersManager: \u8d2d\u4e70 " + count + " \u4ef6\u5546\u54c1\u4e2d\u8d2d\u4e70 " + buy + " \u4ef6");
                    this.inventoriesTransferLimitedToFolk(this.theFolk.inventory, chests, new ItemStack(pickUpItem, 1, pickUpItem.func_149692_a(1)), buy, doCompareMeta);
                }
                ++this.currentPickup;
                if (this.currentPickup <= this.pickupBuildings.size() - 1) {
                    this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.On_my", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                    this.step = 2;
                } else {
                    this.step = 4;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doPickup(String buildingSearch, Item pickUpItem, boolean doCompareMeta) {
        try {
            if (this.step == 1) {
                this.currentPickup = 0;
                this.pickupBuildings.clear();
                this.pickupBuildings = Building.getBuildingBySearch(buildingSearch, true);
                if (this.pickupBuildings.size() == 0) {
                    this.step = 4;
                    return;
                }
                this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.On_my", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                this.step = 2;
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                }
            } else if (this.step == 3) {
                int count;
                int buy;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.Buying_items", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                ArrayList<IInventory> chests = JobBurgersManager.inventoriesFindClosest(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, 5);
                if (!chests.isEmpty() && (buy = (count = this.getItemCountInChests(chests, new ItemStack(pickUpItem, 1), doCompareMeta)) / 4) > 0) {
                    ModSimReloaded.log.info("JobBurgersManager: \u8d2d\u4e70 " + buy + " out of " + count + " \u7269\u54c1");
                    this.inventoriesTransferLimitedToFolk(this.theFolk.inventory, chests, new ItemStack(pickUpItem, 1), buy, doCompareMeta);
                }
                ++this.currentPickup;
                if (this.currentPickup <= this.pickupBuildings.size() - 1) {
                    this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.manager.On_my", (Object[])new Object[0]) + this.pickupBuildings.get((int)this.currentPickup).displayName;
                    this.step = 2;
                } else {
                    this.step = 4;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stagePickupBakery() {
        try {
            if (this.step < 4) {
                this.doPickup("bakery", new ItemStack(Items.field_151025_P).func_77973_b(), false);
            } else {
                this.theStage = Stage.PICKUPGROCERY;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stagePickupGrocery() {
        try {
            if (this.step < 4) {
                this.doPickup("grocery", new ItemStack(Items.field_151174_bG).func_77973_b(), false);
            } else {
                this.theStage = Stage.PICKUPCHEESE;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stagePickupCheese() {
        try {
            if (this.step < 4) {
                this.doPickup("cheese factory", new ItemStack(ItemLoader.itemFoods, 1, 0).func_77973_b(), true);
            } else {
                this.theStage = Stage.PICKUPBUTCHERS;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stagePickupButchers() {
        try {
            if (this.step < 4) {
                this.doPickup("butchers", new ItemStack(Items.field_151082_bd, 1).func_77973_b(), false);
            } else {
                this.theStage = Stage.DROPOFF;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageDropoff() {
        try {
            if (this.step == 1) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.dropoff.On_my", (Object[])new Object[0]);
                ArrayList<V3> back = this.theStore.getSpecialBlocks(0);
                if (!back.isEmpty()) {
                    this.theFolk.gotoXYZ(back.get(0), null);
                    this.step = 2;
                }
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                }
            } else if (this.step == 3) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.dropoff.Unloading", (Object[])new Object[0]);
                ArrayList<V3> back = this.theStore.getSpecialBlocks(0);
                ArrayList<IInventory> backstoreChests = JobBurgersManager.inventoriesFindClosest(back.get(0), 3);
                boolean ok = this.inventoriesTransferFromFolk(this.theFolk.inventory, backstoreChests, null);
                if (!ok) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.dropoff.chest", (Object[])new Object[0]));
                }
                this.theStage = Stage.HANGINGOUT;
                this.step = 0;
                GameStates var10000 = ModSimReloaded.states;
                var10000.credits = (float)((double)var10000.credits - 2.45);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageHangingOut() {
        try {
            if (this.step % 2 == 0) {
                this.theFolk.gotoXYZ(this.theStore.primaryXYZ, GotoMethod.WALK);
            } else {
                this.theFolk.gotoXYZ(this.theStore.getSpecialBlocks(0).get(0), GotoMethod.WALK);
            }
            String say = "";
            switch (this.step) {
                case 0: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Counting", (Object[])new Object[0]);
                    break;
                }
                case 1: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Cancelling", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Being", (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Doing", (Object[])new Object[0]);
                    break;
                }
                case 4: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Disciplining", (Object[])new Object[0]);
                    break;
                }
                case 5: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Reducing", (Object[])new Object[0]);
                    break;
                }
                case 6: {
                    say = I18n.func_135052_a((String)"container.sim.job.dropoff.Adjusting", (Object[])new Object[0]);
                }
            }
            ++this.step;
            if (this.step > 6) {
                this.step = 0;
            }
            this.theFolk.statusText = say;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_at_the_store", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSTORE;
                ArrayList<V3> back = this.theStore.getSpecialBlocks(0);
                if (!back.isEmpty()) {
                    this.theFolk.gotoXYZ(back.get(0), null);
                }
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

