/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ItemLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobBurgersWaiter
extends Job {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;

    public JobBurgersWaiter(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (this.theStore == null) {
                this.theStore = Building.getBuilding(this.theFolk.employedAt);
            }
            if (this.theStore != null) {
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.ARRIVEDATSTORE) {
                    this.theFolk.action = FolkAction.ATWORK;
                    this.runDelay = 11000;
                } else {
                    this.runDelay = this.theStage == Stage.SERVING ? 45000 : 5000;
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.ARRIVEDATSTORE) {
                            this.theStage = Stage.SERVING;
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.serving_customers", (Object[])new Object[0]);
                        } else if (this.theStage == Stage.SERVING) {
                            this.stageServing();
                        }
                    }
                    if (!ModSimReloaded.isDayTime()) {
                        this.theStage = Stage.IDLE;
                    }
                    this.timeSinceLastRun = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageServing() {
        block9: {
            try {
                ArrayList<IInventory> theChests;
                ArrayList<V3> serve = this.theStore.getSpecialBlocks(2);
                if (serve.isEmpty() || (theChests = JobBurgersWaiter.inventoriesFindClosest(serve.get(0), 3)).isEmpty()) break block9;
                this.theFolk.gotoXYZ(serve.get(0), null);
                try {
                    this.theFolk.destination.destinationAcc = 0.3;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ItemStack is = JobBurgersWaiter.inventoriesGet(theChests, null, true, false);
                if (is == null) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.serving.Wishing", (Object[])new Object[0]);
                } else if (is.func_77973_b() == ItemLoader.itemFoods) {
                    is = new ItemStack(is.func_77973_b(), 1, is.func_77960_j());
                    JobBurgersWaiter.inventoriesGet(theChests, is, false, true);
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.merchant.Just_sold", (Object[])new Object[0]) + is.func_82833_r();
                    int r = new Random().nextInt(ModSimReloaded.theFolks.size() - 1);
                    FolkData folk = ModSimReloaded.theFolks.get(r);
                    if (folk.levelFood < 10) {
                        ++folk.levelFood;
                    }
                    folk.saveThisFolk();
                    ModSimReloaded.log.info("JobBurgersWaiter: \u521a\u5403\u8fc7 " + folk.name);
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits = (float)((double)var10000.credits - 0.45);
                } else {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.merchant.Who_put", (Object[])new Object[0]) + is.func_82833_r() + I18n.func_135052_a((String)"container.sim.job.merchant.my_chest", (Object[])new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_at_the_store", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSTORE;
                ArrayList<V3> back = this.theStore.getSpecialBlocks(2);
                if (!back.isEmpty()) {
                    this.theFolk.gotoXYZ(back.get(0), null);
                }
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

