/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobButcher
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904271422L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> chestsAtFarm = new ArrayList();
    private transient ArrayList<IInventory> chestsAtShop = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient Building farm = null;
    private transient boolean onRoute = false;

    public JobButcher() {
    }

    public JobButcher(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.theFolk.action = FolkAction.ATWORK;
                this.runDelay = 11000;
            } else {
                this.runDelay = 3000;
            }
            if (this.theStage == Stage.SELLINGMEAT) {
                this.runDelay = 10000;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATSHOP) {
                        this.theStage = Stage.GOINGTOMEATFARM;
                    } else if (this.theStage == Stage.GOINGTOMEATFARM) {
                        this.stageGoingToFarm();
                    } else if (this.theStage == Stage.COLLECTINGMEAT) {
                        this.stageCollectingMeat();
                    } else if (this.theStage == Stage.GOBACKTOSTORE) {
                        this.stageGoBackToStore();
                    } else if (this.theStage == Stage.SELLINGMEAT) {
                        this.stageSellingMeat();
                    }
                }
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                if (this.theStage == Stage.ARRIVEDATSHOP) {
                    this.theFolk.action = FolkAction.ATWORK;
                    this.runDelay = 11000;
                } else {
                    this.runDelay = 3000;
                }
                if (this.theStage == Stage.SELLINGMEAT) {
                    this.runDelay = 10000;
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    this.timeSinceLastRun = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToFarm() {
        block9: {
            try {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Fetching", (Object[])new Object[0]);
                this.theFolk.action = FolkAction.ATWORK;
                if (!this.onRoute) {
                    this.farm = this.getCurrentFarm();
                    try {
                        if (this.farm != null && this.farm.primaryXYZ != null) {
                            this.onRoute = true;
                            this.theFolk.gotoXYZ(this.farm.primaryXYZ, GotoMethod.BEAM);
                            break block9;
                        }
                        this.theStage = Stage.GOBACKTOSTORE;
                    }
                    catch (Exception var2) {
                        this.theStage = Stage.GOBACKTOSTORE;
                    }
                    break block9;
                }
                int dist = this.theFolk.location.getDistanceTo(this.farm.primaryXYZ);
                if (dist < 3) {
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.onRoute = false;
                    this.theStage = Stage.COLLECTINGMEAT;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    return;
                }
                if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageCollectingMeat() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Collecting", (Object[])new Object[0]);
            this.theFolk.action = FolkAction.ATWORK;
            if (this.step == 1) {
                this.chestsAtFarm.clear();
                this.chestsAtFarm = JobButcher.inventoriesFindClosest(this.farm.primaryXYZ, 5);
                if (this.chestsAtFarm.size() > 0) {
                    this.step = 2;
                }
            } else if (this.step == 2) {
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151076_bf, 1, 640), null);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151147_al, 1, 640), null);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtFarm, new ItemStack(Items.field_151082_bd, 1, 640), null);
                this.step = 3;
            } else if (this.step == 3) {
                this.theStage = Stage.GOINGTOMEATFARM;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoBackToStore() {
        try {
            this.theFolk.action = FolkAction.ATWORK;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Taking", (Object[])new Object[0]);
            if (!this.onRoute) {
                this.onRoute = true;
                this.theFolk.gotoXYZ(this.theFolk.employedAt, GotoMethod.BEAM);
            } else {
                double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (dist < 2.0) {
                    this.onRoute = false;
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.theFolk.stayPut = true;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Unloading", (Object[])new Object[0]);
                    int meat1 = this.getInventoryCount(this.theFolk, Items.field_151147_al);
                    int meat2 = this.getInventoryCount(this.theFolk, Items.field_151076_bf);
                    int meat3 = this.getInventoryCount(this.theFolk, Items.field_151082_bd);
                    this.pay = (float)((double)(meat1 + meat2 + meat3) * 0.03);
                    this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
                    this.inventoriesTransferFromFolk(this.theFolk.inventory, this.chestsAtShop, null);
                    this.theStage = Stage.SELLINGMEAT;
                    this.step = 1;
                    return;
                }
                if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageSellingMeat() {
        try {
            this.theFolk.action = FolkAction.ATWORK;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Selling", (Object[])new Object[0]);
            if (this.step == 1) {
                this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
                this.openCloseChest(this.chestsAtShop.get(0), 2000);
                if (this.pay > 0.0f) {
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits -= this.pay;
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.butcher.collected", (Object[])new Object[0]) + ModSimReloaded.displayMoney(this.pay) + I18n.func_135052_a((String)"container.sim.job.credits", (Object[])new Object[0]));
                    this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
                }
                this.step = 2;
                return;
            }
            if (this.step == 2) {
                if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L > 11600L) {
                    this.step = 3;
                }
                this.theFolk.updateLocationFromEntity();
                double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (!(dist > 8.0)) return;
                this.theFolk.beamMeTo(this.theFolk.employedAt);
                return;
            }
            if (this.step == 3) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Closing", (Object[])new Object[0]);
                int sell = 0;
                boolean notEnough = false;
                ItemStack piece = null;
                this.chestsAtShop = JobButcher.inventoriesFindClosest(this.theFolk.employedAt, 3);
                for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
                    piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151147_al, 1), false, false);
                    if (piece == null) {
                        piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151076_bf, 1), false, false);
                    }
                    if (piece == null) {
                        piece = JobButcher.inventoriesGet(this.chestsAtShop, new ItemStack(Items.field_151082_bd, 1), false, false);
                    }
                    if (piece == null) continue;
                    FolkData folk = ModSimReloaded.theFolks.get(f);
                    folk.levelFood = 10;
                    ++sell;
                }
                if (sell > 0) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.butcher.has_sold", (Object[])new Object[0]) + sell + I18n.func_135052_a((String)"container.sim.job.butcher.folks", (Object[])new Object[0]));
                }
                this.step = 4;
                return;
            }
            if (this.step != 4) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Building getCurrentFarm() {
        boolean found = false;
        try {
            while (!found) {
                try {
                    Building farm = ModSimReloaded.theBuildings.get(this.currentFarmNum);
                    if (farm.displayNameWithoutPK.contains("Cattle Farm") || farm.displayNameWithoutPK.contains("Pig Farm") || farm.displayNameWithoutPK.contains("Chicken Farm")) {
                        found = true;
                        ++this.currentFarmNum;
                        return farm;
                    }
                    ++this.currentFarmNum;
                    if (this.currentFarmNum <= ModSimReloaded.theBuildings.size() - 1) continue;
                    return null;
                }
                catch (Exception var3) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.butcher.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSHOP;
                this.currentFarmNum = 0;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

