/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ItemLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobCheesemaker
extends Job {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private ArrayList<IInventory> chestsAtDairy = new ArrayList();
    private int currentFarmNum = 0;
    private Building farm = null;
    private long timeSinceLastRun = 0L;
    private Building theCheeseFactory = null;
    private boolean tubToggle = true;
    private int stirCount = 0;
    private V3 currentStirPos;

    public JobCheesemaker(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (this.theCheeseFactory == null) {
                Building.loadAllBuildings();
                this.theCheeseFactory = Building.getBuilding(this.theFolk.employedAt);
            }
            if (this.theCheeseFactory == null) {
                Building.loadAllBuildings();
                this.theCheeseFactory = Building.getBuilding(this.theFolk.employedAt);
            }
            if (this.theCheeseFactory == null) {
                this.theFolk.selfFire();
                ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.cheese_maker.There", (Object[])new Object[0]));
            } else {
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.ARRIVEDATFACTORY) {
                    this.theFolk.action = FolkAction.ATWORK;
                    this.runDelay = 11000;
                } else {
                    this.runDelay = this.theStage == Stage.EMPTYINGMILK ? 1000 : 5000;
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.ARRIVEDATFACTORY) {
                            this.stageArrivedAtFactory();
                        } else if (this.theStage == Stage.GOINGTODAIRYFARM) {
                            this.stageGoingToDairyFarm();
                        } else if (this.theStage == Stage.COLLECTINGMILK) {
                            this.stageCollectingMilk();
                        } else if (this.theStage == Stage.GOINGTOTANK) {
                            this.stageGoingToTank();
                        } else if (this.theStage == Stage.EMPTYINGMILK) {
                            this.stageEmptyingMilk();
                        } else if (this.theStage == Stage.STIRING) {
                            this.stageStiring();
                        } else if (this.theStage == Stage.HARVESTCHEESE) {
                            this.stageHarvestCheese();
                        } else if (this.theStage == Stage.SLICECHEESE) {
                            this.stageSliceCheese();
                        }
                    }
                    if (!ModSimReloaded.isDayTime()) {
                        this.theStage = Stage.IDLE;
                    }
                    this.timeSinceLastRun = System.currentTimeMillis();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageArrivedAtFactory() {
        try {
            ArrayList<V3> cheesechest = this.theCheeseFactory.getSpecialBlocks(5);
            ArrayList<IInventory> chests = JobCheesemaker.inventoriesFindClosest(cheesechest.get(0), 4);
            this.inventoriesTransferToFolk(this.theFolk.inventory, chests, new ItemStack(Items.field_151117_aB, 64), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theStage = Stage.GOINGTODAIRYFARM;
        this.currentFarmNum = -1;
    }

    private void stageGoingToDairyFarm() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Going", (Object[])new Object[0]);
            ++this.currentFarmNum;
            ArrayList<Building> dairyFarms = Building.getBuildingBySearch(I18n.func_135052_a((String)"container.sim.gui_contains_Dairy_Farm", (Object[])new Object[0]), true);
            if (!dairyFarms.isEmpty() && dairyFarms.size() - 1 <= this.currentFarmNum) {
                this.farm = dairyFarms.get(this.currentFarmNum);
                this.theFolk.gotoXYZ(this.farm.primaryXYZ, GotoMethod.BEAM);
                this.theStage = Stage.COLLECTINGMILK;
                this.step = 1;
            } else if (dairyFarms.isEmpty()) {
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.cheese_maker.has_retired", (Object[])new Object[0]));
                this.theFolk.selfFire();
            } else {
                this.theStage = Stage.GOINGTOTANK;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCollectingMilk() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Collecting", (Object[])new Object[0]);
            if (this.step == 1) {
                if (this.theFolk.destination == null && this.theFolk.location.getDistanceTo(this.farm.primaryXYZ) < 5) {
                    this.step = 2;
                    this.theFolk.isWorking = true;
                } else {
                    ModSimReloaded.log.info("JobCheeseMaker: \u8fd8\u6ca1\u5230\u519c\u573a");
                }
            } else if (this.step == 2) {
                this.chestsAtDairy = Job.inventoriesFindClosest(this.farm.primaryXYZ, 5);
                if (this.chestsAtDairy.isEmpty()) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.cheese_maker.I_quit", (Object[])new Object[0]));
                    this.theFolk.selfFire();
                    return;
                }
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.chestsAtDairy, new ItemStack(Items.field_151117_aB, 1), null);
                if (this.theFolk.inventory == null || this.theFolk.inventory.isEmpty()) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.cheese_maker.dairy", (Object[])new Object[0]));
                    this.theStage = Stage.SLICECHEESE;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.process", (Object[])new Object[0]);
                    return;
                }
                ArrayList<V3> tanktop = this.theCheeseFactory.getSpecialBlocks(3);
                if (!tanktop.isEmpty()) {
                    this.theFolk.gotoXYZ(tanktop.get(0), GotoMethod.BEAM);
                    this.theStage = Stage.GOINGTOTANK;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                } else {
                    ModSimReloaded.log.warning("JobCheesemaker: \u6ca1\u6709\u84c4\u6c34\u6c60");
                    this.theFolk.selfFire();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToTank() {
        try {
            if (this.step == 1) {
                if (this.theFolk.destination == null) {
                    this.step = 2;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Preparing", (Object[])new Object[0]);
                } else {
                    ModSimReloaded.log.info("JobCheeseMaker: \u8fd8\u6ca1\u5230\u540e\u9762");
                }
            } else if (this.step == 2) {
                this.theStage = Stage.EMPTYINGMILK;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageEmptyingMilk() {
        block12: {
            try {
                if (this.step == 1) {
                    if (this.theFolk.inventory != null && !this.theFolk.inventory.isEmpty()) {
                        this.theFolk.statusText = this.theFolk.inventory.size() > 1 ? I18n.func_135052_a((String)"container.sim.job.cheese_maker.Emptying", (Object[])new Object[0]) + this.theFolk.inventory.size() + I18n.func_135052_a((String)"container.sim.job.cheese_maker.buckets", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.job.cheese_maker.Emptied", (Object[])new Object[0]);
                        this.theFolk.isWorking = true;
                        this.theFolk.stayPut = true;
                        this.step = 2;
                    } else {
                        this.step = 3;
                    }
                    break block12;
                }
                if (this.step == 2) {
                    ArrayList<V3> milkblocks = this.theCheeseFactory.getSpecialBlocks(0);
                    int lightID = Block.func_149682_b((Block)BlockLoader.lightBox);
                    ModSimReloaded.log.info(Integer.toString(lightID));
                    boolean filledOk = false;
                    for (V3 milkBlock : milkblocks) {
                        Block id = this.jobWorld.func_147439_a(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue());
                        int meta = this.jobWorld.func_72805_g(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue());
                        if (id != Blocks.field_150350_a && (id != BlockLoader.blockFluidMilk || meta != 1)) continue;
                        this.jobWorld.func_147465_d(milkBlock.x.intValue(), milkBlock.y.intValue(), milkBlock.z.intValue(), BlockLoader.blockFluidMilk, 0, 3);
                        try {
                            this.theFolk.inventory.remove(0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        filledOk = true;
                        break;
                    }
                    if (filledOk) {
                        this.theFolk.isWorking = false;
                        this.step = 1;
                    } else {
                        this.theStage = Stage.STIRING;
                        this.step = 1;
                        this.theFolk.isWorking = false;
                        ArrayList<V3> cheesechest = this.theCheeseFactory.getSpecialBlocks(5);
                        ArrayList<IInventory> chests = JobCheesemaker.inventoriesFindClosest(cheesechest.get(0), 4);
                        this.inventoriesTransferFromFolk(this.theFolk.inventory, chests, null);
                    }
                    break block12;
                }
                if (this.step == 3) {
                    this.theStage = Stage.STIRING;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageStiring() {
        try {
            ArrayList<V3> stirPositions = this.theCheeseFactory.getSpecialBlocks(4);
            if (this.step == 1) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.viscosity", (Object[])new Object[0]);
                if (!stirPositions.isEmpty()) {
                    if (this.tubToggle) {
                        this.currentStirPos = stirPositions.get(0);
                        this.theFolk.gotoXYZ(this.currentStirPos, null);
                    } else {
                        this.currentStirPos = stirPositions.get(1);
                        this.theFolk.gotoXYZ(this.currentStirPos, null);
                    }
                    this.tubToggle = !this.tubToggle;
                    this.stirCount = 0;
                    this.step = 2;
                } else {
                    ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.cheese_maker.constructor", (Object[])new Object[0]));
                    this.theFolk.selfFire();
                }
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                }
            } else if (this.step == 3) {
                String say = "";
                switch (this.stirCount) {
                    case 0: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Stirring", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.ingredient", (Object[])new Object[0]);
                        break;
                    }
                    case 2: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.bacterial", (Object[])new Object[0]);
                        break;
                    }
                    case 3: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.unwanted", (Object[])new Object[0]);
                        break;
                    }
                    case 4: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.fermentation", (Object[])new Object[0]);
                        break;
                    }
                    case 5: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Adding", (Object[])new Object[0]);
                        break;
                    }
                    case 6: {
                        say = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Reticulating", (Object[])new Object[0]);
                    }
                }
                this.theFolk.statusText = say;
                this.theFolk.isWorking = true;
                this.theFolk.stayPut = true;
                if (this.stirCount == 6) {
                    this.transformMilkToCheese(this.currentStirPos);
                }
                ++this.stirCount;
                if (this.stirCount > 6) {
                    this.theFolk.isWorking = false;
                    this.step = 1;
                }
                if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L > 9900L) {
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    this.theStage = Stage.HARVESTCHEESE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transformMilkToCheese(V3 currentStirPos) {
        try {
            ArrayList<V3> milkBlocks = this.theCheeseFactory.getSpecialBlocks(0);
            ArrayList<V3> cheeseBlocks = this.theCheeseFactory.getSpecialBlocks(1);
            if (!milkBlocks.isEmpty() && !cheeseBlocks.isEmpty()) {
                int dist;
                Block id;
                boolean placedCheese = false;
                int milkGotCount = 0;
                for (int m = milkBlocks.size() - 1; m > 0; --m) {
                    V3 cheese = milkBlocks.get(m);
                    id = this.jobWorld.func_147439_a(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue());
                    dist = this.jobWorld.func_72805_g(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue());
                    if (id != BlockLoader.blockFluidMilk || dist != 0) continue;
                    this.jobWorld.func_147465_d(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue(), id, 0, 3);
                    if (++milkGotCount > 1) break;
                }
                if (milkGotCount > 0) {
                    for (V3 cheese : cheeseBlocks) {
                        id = this.jobWorld.func_147439_a(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue());
                        dist = cheese.getDistanceTo(currentStirPos);
                        if (id == BlockLoader.blockCheeseBlock || dist >= 5) continue;
                        this.jobWorld.func_147465_d(cheese.x.intValue(), cheese.y.intValue(), cheese.z.intValue(), BlockLoader.blockCheeseBlock, 0, 3);
                        placedCheese = true;
                        break;
                    }
                }
                if (milkGotCount == 0 || !placedCheese) {
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    this.theStage = Stage.HARVESTCHEESE;
                }
            } else {
                this.theFolk.selfFire();
                ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.cheese_maker.Cheese_factory", (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageHarvestCheese() {
        try {
            ArrayList<V3> cheeseBlocks = this.theCheeseFactory.getSpecialBlocks(1);
            ArrayList<V3> stirPositions = this.theCheeseFactory.getSpecialBlocks(4);
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Extracting", (Object[])new Object[0]);
            if (this.step == 1) {
                this.theFolk.gotoXYZ(stirPositions.get(0), null);
                this.step = 2;
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                    this.theFolk.isWorking = true;
                }
            } else if (this.step == 3) {
                this.theFolk.isWorking = false;
                boolean gotBlock = false;
                for (V3 block : cheeseBlocks) {
                    Block id = this.jobWorld.func_147439_a(block.x.intValue(), block.y.intValue(), block.z.intValue());
                    if (stirPositions.get(0).getDistanceTo(block) >= 5 || id != BlockLoader.blockCheeseBlock) continue;
                    gotBlock = true;
                    this.theFolk.inventory.add(new ItemStack(BlockLoader.blockCheeseBlock));
                    this.jobWorld.func_147465_d(block.x.intValue(), block.y.intValue(), block.z.intValue(), id, 0, 3);
                    this.theFolk.isWorking = true;
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits = (float)((double)var10000.credits - 0.45);
                    break;
                }
                if (!gotBlock) {
                    this.theFolk.isWorking = false;
                    this.step = 4;
                    this.theFolk.gotoXYZ(stirPositions.get(1), null);
                }
            } else if (this.step == 4) {
                if (this.theFolk.destination == null) {
                    this.step = 5;
                    this.theFolk.isWorking = true;
                }
            } else if (this.step == 5) {
                this.theFolk.isWorking = false;
                boolean gotBlock = false;
                for (V3 block : cheeseBlocks) {
                    Block id = this.jobWorld.func_147439_a(block.x.intValue(), block.y.intValue(), block.z.intValue());
                    if (stirPositions.get(1).getDistanceTo(block) >= 5 || id != BlockLoader.blockCheeseBlock) continue;
                    gotBlock = true;
                    this.theFolk.inventory.add(new ItemStack(BlockLoader.blockCheeseBlock));
                    this.jobWorld.func_147465_d(block.x.intValue(), block.y.intValue(), block.z.intValue(), id, 0, 3);
                    break;
                }
                if (!gotBlock) {
                    this.step = 1;
                    this.theStage = Stage.SLICECHEESE;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Counting", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageSliceCheese() {
        try {
            ArrayList<V3> slicewaypoint = this.theCheeseFactory.getSpecialBlocks(5);
            if (slicewaypoint.isEmpty()) {
                this.theFolk.selfFire();
                ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.cheese_maker.problem", (Object[])new Object[0]));
            } else if (this.step == 1) {
                this.theFolk.gotoXYZ(slicewaypoint.get(0), null);
                this.step = 2;
            } else if (this.step == 2) {
                if (this.theFolk.destination == null) {
                    this.step = 3;
                    this.theFolk.stayPut = true;
                }
            } else if (this.step == 3) {
                ArrayList<IInventory> chests = Job.inventoriesFindClosest(slicewaypoint.get(0), 4);
                if (chests.isEmpty()) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.cheese_maker.Someone", (Object[])new Object[0]));
                    this.theFolk.selfFire();
                }
                this.inventoriesTransferFromFolk(this.theFolk.inventory, chests, null);
                this.step = 4;
            } else if (this.step == 4) {
                ArrayList<IInventory> chests = Job.inventoriesFindClosest(slicewaypoint.get(0), 4);
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.Slicing", (Object[])new Object[0]);
                ItemStack cheese = JobCheesemaker.inventoriesGet(chests, new ItemStack(BlockLoader.blockCheeseBlock, 1), false, false);
                if (cheese != null) {
                    boolean placedOK = this.inventoriesPut(chests, new ItemStack(ItemLoader.itemFoods, 9, 0), true);
                    if (!placedOK) {
                        ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.cheese_maker.factory", (Object[])new Object[0]));
                        this.theFolk.selfFire();
                    }
                } else {
                    this.step = 5;
                }
            } else if (this.step == 5) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.love_cheese", (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.cheese_maker.the_factory", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATFACTORY;
                this.currentFarmNum = 0;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

