/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.CourierTask;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobCourier
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207901844141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<CourierTask> courierTasks = new ArrayList();
    private transient ArrayList<IInventory> chests = new ArrayList();
    private transient int currentTask = 0;
    private transient long timeSinceLastCycle = 0L;
    private transient V3 pickup;
    private transient V3 dropoff;
    private transient boolean onRoute = false;

    public JobCourier() {
    }

    public JobCourier(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            this.runDelay = this.theStage == Stage.ATDEPOT ? 15000 : 3000;
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage == Stage.IDLE && ModSimReloaded.isDayTime()) {
                    this.onUpdateGoingToWork(this.theFolk);
                } else if (this.theStage == Stage.ATDEPOT) {
                    this.stageAtDepot();
                } else if (this.theStage == Stage.GOINGTOPICKUP) {
                    this.stageGoingToPickup();
                } else if (this.theStage == Stage.PICKINGUP) {
                    this.stagePickingUp();
                } else if (this.theStage == Stage.GOINGTODROPOFF) {
                    this.stageGoingToDropoff();
                } else if (this.theStage == Stage.DROPPINGOFF) {
                    this.stageDroppingOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageAtDepot() {
        try {
            if (System.currentTimeMillis() - this.timeSinceLastCycle >= 180000L) {
                this.currentTask = 0;
                this.courierTasks.clear();
                for (int t = 0; t < ModSimReloaded.theCourierTasks.size(); ++t) {
                    CourierTask task = ModSimReloaded.theCourierTasks.get(t);
                    if (task == null || task.pickup == null || !task.folkname.contentEquals(this.theFolk.name)) continue;
                    try {
                        this.courierTasks.add(task);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.courierTasks.size() == 0) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.deliveries", (Object[])new Object[0]);
                } else {
                    this.theStage = Stage.GOINGTOPICKUP;
                    this.onRoute = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToPickup() {
        try {
            if (!this.onRoute) {
                CourierTask task = this.courierTasks.get(this.currentTask);
                this.pickup = task.pickup;
                if (this.pickup != null) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.On_my", (Object[])new Object[0]) + this.pickup.name + I18n.func_135052_a((String)"container.sim.job.courier.pick_up", (Object[])new Object[0]);
                    V3 d = this.pickup.clone();
                    d = new V3(d.x, d.y + 1.0, d.z, d.theDimension);
                    this.theFolk.gotoXYZ(d, GotoMethod.BEAM);
                    this.onRoute = true;
                } else {
                    this.theStage = Stage.IDLE;
                }
            } else {
                double dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.pickup)) < 3.0) {
                    this.theStage = Stage.PICKINGUP;
                    this.onRoute = false;
                } else if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stagePickingUp() {
        try {
            CourierTask task = this.courierTasks.get(this.currentTask);
            V3 pickup = task.pickup;
            this.chests.clear();
            this.chests = JobCourier.inventoriesFindClosest(pickup, 4);
            if (this.chests.size() == 0) {
                ModSimReloaded.log.warning("JobCourier: StagePickingup() \u62fe\u53d6\u65f6\u6ca1\u6709\u5b9d\u7bb1\uff1a" + pickup.name + "\uff0c\u79fb\u9664\u4efb\u52a1\u3002");
                ++this.currentTask;
                if (this.currentTask >= this.courierTasks.size()) {
                    this.currentTask = 0;
                    this.theStage = Stage.IDLE;
                } else {
                    this.onRoute = false;
                    this.theStage = Stage.GOINGTOPICKUP;
                }
            } else {
                this.theFolk.stayPut = true;
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.Picking", (Object[])new Object[0]);
                ModSimReloaded.log.info("JobCourier: pickupStage() " + this.theFolk.name + "(courier)\u627e\u5230 " + this.chests.size() + " \u4e2a\u7bb1\u5b50 " + pickup.name);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.chests, null, BlockLoader.lightBox);
            }
            if (this.theFolk.inventory.size() == 0) {
                ++this.currentTask;
                if (this.currentTask >= this.courierTasks.size()) {
                    this.currentTask = 0;
                    this.theStage = Stage.IDLE;
                    this.timeSinceLastCycle = System.currentTimeMillis();
                } else {
                    this.theStage = Stage.GOINGTOPICKUP;
                }
            } else {
                this.theStage = Stage.GOINGTODROPOFF;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.Going", (Object[])new Object[0]);
                this.onRoute = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToDropoff() {
        try {
            CourierTask task = this.courierTasks.get(this.currentTask);
            if (task != null && task.dropoff != null) {
                this.dropoff = task.dropoff.clone();
            } else {
                this.theStage = Stage.ATDEPOT;
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                if (task != null) {
                    this.courierTasks.remove(task);
                }
            }
            if (this.dropoff == null) {
                this.dropoff = this.theFolk.employedAt;
                this.dropoff.name = I18n.func_135052_a((String)"container.sim.job.courier.The_depot", (Object[])new Object[0]);
            }
            if (!this.onRoute) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.On_my", (Object[])new Object[0]) + this.dropoff.name + I18n.func_135052_a((String)"container.sim.job.courier.drop_off", (Object[])new Object[0]);
                V3 d = this.dropoff.clone();
                d = new V3(d.x, d.y + 1.0, d.z, d.theDimension);
                if (d == null) {
                    d = this.theFolk.employedAt.clone();
                }
                Double var4 = d.y;
                Double var5 = d.y = Double.valueOf(d.y + 1.0);
                this.theFolk.beamMeTo(d);
                this.theFolk.gotoXYZ(d, GotoMethod.BEAM);
                this.onRoute = true;
            } else {
                double dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.dropoff)) < 4.0) {
                    this.theStage = Stage.DROPPINGOFF;
                    this.onRoute = false;
                } else if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageDroppingOff() {
        try {
            CourierTask task = this.courierTasks.get(this.currentTask);
            V3 dropoff = task.dropoff;
            dropoff = new V3(dropoff.x, dropoff.y + 1.0, dropoff.z, dropoff.theDimension);
            if (dropoff == null) {
                dropoff = this.theFolk.employedAt;
                dropoff.name = I18n.func_135052_a((String)"container.sim.job.courier.The_depot", (Object[])new Object[0]);
            }
            this.chests.clear();
            this.chests = JobCourier.inventoriesFindClosest(dropoff, 5);
            if (this.chests.size() == 0) {
                ModSimReloaded.log.warning("JobCourierL dropoff() \u4e0b\u8f66\u65f6\u6ca1\u6709\u627e\u5230\u7bb1\u5b50");
                ++this.currentTask;
                if (this.currentTask >= this.courierTasks.size()) {
                    this.currentTask = 0;
                    this.theStage = Stage.IDLE;
                } else {
                    this.theStage = Stage.GOINGTOPICKUP;
                }
            } else {
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.Dropping", (Object[])new Object[0]);
                this.theFolk.action = FolkAction.ATWORK;
                ModSimReloaded.log.info("JobCourier: " + this.theFolk.name + " \u627e\u5230 " + this.chests.size() + " \u4e2a\u7bb1\u5b50 " + dropoff.name);
                while (this.theFolk.inventory.size() > 0) {
                    int oldSize = this.theFolk.inventory.size();
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits -= 0.11f;
                    ItemStack invItem = this.theFolk.inventory.get(0);
                    this.theFolk.statusText = this.theFolk.inventory.size() > 1 ? this.theFolk.inventory.size() + I18n.func_135052_a((String)"container.sim.job.courier.unload", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.job.courier.Last", (Object[])new Object[0]);
                    boolean placed = this.inventoriesTransferFromFolk(this.theFolk.inventory, this.chests, null);
                    if (placed) continue;
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.courier.Courier", (Object[])new Object[0]) + dropoff.name + I18n.func_135052_a((String)"container.sim.job.courier.because", (Object[])new Object[0]));
                    break;
                }
            }
            ++this.currentTask;
            if (this.currentTask >= this.courierTasks.size()) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.task_list", (Object[])new Object[0]);
                this.currentTask = 0;
                this.timeSinceLastCycle = System.currentTimeMillis();
                this.theFolk.stayPut = false;
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                this.theStage = Stage.IDLE;
            } else {
                this.theStage = Stage.GOINGTOPICKUP;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.courier.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ATDEPOT;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

