/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.block.functionality.FarmingBox;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FarmType;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import com.trhsy.sim.util.GameMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobCropFarmer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112214234279141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient boolean doneSomeWork = false;
    private transient FarmingBox farmingBlock = null;
    private transient ArrayList<IInventory> farmingChests = new ArrayList();
    private transient String farmDir = "";
    private transient int ftbCount = 0;
    private transient int ltrCount = 0;
    private transient int xo = 0;
    private transient int zo = 0;
    private transient Block id = null;
    private transient int mx;
    private transient int my;
    private transient int mz;
    private transient int xxx = 0;
    private transient int yyy = 0;
    private transient int zzz = 0;
    private transient int ftb = 1;
    private transient int ltr = -1;
    private transient int meta = 0;
    private transient long lastFarmCycle = 0L;
    private transient long lastCustomHarvest = 0L;
    private transient int rowCounter = 0;

    public JobCropFarmer() {
    }

    public JobCropFarmer(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null) {
                if (this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
                this.farmingBlock = FarmingBox.getFarmingBlockByBoxXYZ(folk.employedAt);
                this.runDelay = 1000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            if (ModSimReloaded.theFarmingBoxes.size() != 0) {
                super.onUpdate();
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                }
                super.onUpdateGoingToWork(this.theFolk);
                if (this.theStage == Stage.CHECKINGFORCHESTS) {
                    this.runDelay = 1000;
                }
                if (this.theStage == Stage.HARVEST || this.theStage == Stage.HOELAND || this.theStage == Stage.PLANTSEEDS) {
                    this.runDelay = 500;
                }
                if (this.theStage == Stage.HANGOUT) {
                    this.runDelay = this.step == 1 ? 1000 : 60000;
                }
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    this.timeSinceLastRun = System.currentTimeMillis();
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.ARRIVEDATFARM) {
                            this.theStage = Stage.CHECKINGFORCHESTS;
                        } else if (this.theStage == Stage.CHECKINGFORCHESTS) {
                            this.stageCheckingForChests();
                        } else if (this.theStage == Stage.HARVEST) {
                            this.stageHarvest();
                        } else if (this.theStage == Stage.HOELAND) {
                            this.stageHoeland();
                        } else if (this.theStage == Stage.PLANTSEEDS) {
                            this.stagePlantSeeds();
                        } else if (this.theStage == Stage.HANGOUT) {
                            this.stageHangout();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stageCheckingForChests() {
        try {
            if (this.farmingChests.isEmpty()) {
                this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
            }
            ModSimReloaded.log.info("JobCropFarmer: \u5728\u519c\u573a\u53d1\u73b0 " + this.farmingChests.size() + " \u7bb1\u5b50");
            this.theFolk.stayPut = true;
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 3) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            if (this.farmingChests.isEmpty()) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Please", (Object[])new Object[0]);
            } else {
                this.theStage = Stage.HARVEST;
                this.step = 1;
                this.theFolk.stayPut = true;
                if (this.theFolk.gender == 0) {
                    this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readym", 1.0f, 1.0f, false);
                } else {
                    this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readyf", 1.0f, 1.0f, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupFarming() {
        try {
            this.ftb = 0;
            this.ltr = -1;
            if (this.farmingBlock == null) {
                ModSimReloaded.log.warning("JobCropFarmer: FarmingBlock \u4e3a\u7a7a - \u4e0d\u5b58\u5728\u6216\u672a\u627e\u5230\uff1f\uff01");
            } else {
                V3 m1 = this.farmingBlock.marker1XYZ;
                V3 m2 = this.farmingBlock.marker2XYZ;
                V3 m3 = this.farmingBlock.marker3XYZ;
                if (this.farmingBlock.marker1XYZ == null) {
                    ModSimReloaded.log.warning("JobCropFarmer: FarmingBlock \u7684\u6807\u8bb0\u4e3a\u7a7a");
                } else {
                    try {
                        this.mx = m1.x.intValue();
                        this.my = m1.y.intValue() - 1;
                        this.mz = m1.z.intValue();
                        int m2x = m2.x.intValue();
                        int m1x = m1.x.intValue();
                        int m2z = m2.z.intValue();
                        int m1z = m1.z.intValue();
                        if (m2x == m1x) {
                            this.farmDir = m2z > this.mz ? "z+" : "z-";
                        } else if (m2z == m1z) {
                            this.farmDir = m2x > this.mx ? "x+" : "x-";
                        }
                        this.ltrCount = this.farmingBlock.getSizeWidth();
                        this.ftbCount = this.farmingBlock.getSizeLength();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean setXYZ() {
        boolean ret = false;
        try {
            ++this.ltr;
            if (this.ltr > this.ltrCount + 1) {
                this.ltr = 0;
                ++this.ftb;
                if (this.ftb > this.ftbCount + 1) {
                    ret = true;
                }
            }
            if (this.farmDir.contentEquals("x+")) {
                this.xo = this.ltr;
                this.zo = -this.ftb;
            } else if (this.farmDir.contentEquals("x-")) {
                this.xo = -this.ltr;
                this.zo = this.ftb;
            } else if (this.farmDir.contentEquals("z+")) {
                this.xo = this.ftb;
                this.zo = this.ltr;
            } else if (this.farmDir.contentEquals("z-")) {
                this.xo = -this.ftb;
                this.zo = -this.ltr;
            }
            try {
                this.xxx = this.mx + this.xo;
                this.yyy = this.farmingBlock.location.y.intValue();
                this.zzz = this.mz + this.zo;
                return ret;
            }
            catch (Exception var3) {
                ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.crop.farmer.There", (Object[])new Object[0]) + this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.crop.farmer.farming", (Object[])new Object[0]));
                this.theFolk.selfFire();
                return false;
            }
        }
        catch (Exception exception) {
            return ret;
        }
    }

    public void stageHarvest() {
        block30: {
            try {
                if (this.farmingBlock == null || this.farmingBlock.farmType == null) {
                    ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.crop.farmer.problem", (Object[])new Object[0]));
                    if (this.theFolk != null) {
                        this.theFolk.selfFire();
                    }
                }
                if (this.step == 1) {
                    this.setupFarming();
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Harvesting", (Object[])new Object[0]);
                    int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                    if (dist > 3) {
                        this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                    }
                    this.step = 2;
                    this.theFolk.isWorking = true;
                    break block30;
                }
                if (this.step != 2) break block30;
                boolean done = this.setXYZ();
                boolean hasHarvest = false;
                if (done) {
                    this.theStage = Stage.HOELAND;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    this.lastCustomHarvest = System.currentTimeMillis();
                    return;
                }
                while (!hasHarvest) {
                    this.id = this.jobWorld.func_147439_a(this.xxx, this.yyy, this.zzz);
                    this.meta = this.jobWorld.func_72805_g(this.xxx, this.yyy, this.zzz);
                    try {
                        if (!this.theFolk.isSpawned() && this.farmingBlock.farmType != FarmType.CUSTOM && this.farmingBlock.farmType != FarmType.SUGAR && this.farmingBlock.farmType != FarmType.CACTUS && this.meta < 7) {
                            ++this.meta;
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, this.id, this.meta, 3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean canHarvest = false;
                    V3 harvestBlock = new V3(Double.valueOf(this.xxx), Double.valueOf(this.yyy), Double.valueOf(this.zzz), this.jobWorld.field_73011_w.field_76574_g);
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, harvestBlock);
                    if (this.farmingBlock.farmType != FarmType.SUGAR && this.farmingBlock.farmType != FarmType.CACTUS) {
                        if (this.id == Blocks.field_150440_ba || this.id == Blocks.field_150423_aK || this.farmingBlock.farmType == FarmType.CUSTOM || this.meta >= 7) {
                            if (this.id != Blocks.field_150393_bb && this.id != Blocks.field_150394_bc) {
                                canHarvest = true;
                            }
                            if (this.id == null) {
                                canHarvest = false;
                            }
                        }
                    } else {
                        Block sid1 = this.jobWorld.func_147439_a(this.xxx, this.yyy + 1, this.zzz);
                        Block sid2 = this.jobWorld.func_147439_a(this.xxx, this.yyy + 2, this.zzz);
                        if (sid1 == Blocks.field_150436_aH && sid2 == Blocks.field_150436_aH) {
                            canHarvest = true;
                        }
                        if (sid1 == Blocks.field_150434_aF && sid2 == Blocks.field_150434_aF) {
                            canHarvest = true;
                        }
                    }
                    if (canHarvest) {
                        if (this.farmingBlock.farmType != FarmType.SUGAR && this.farmingBlock.farmType != FarmType.CACTUS) {
                            if (this.farmingBlock.farmType == FarmType.CUSTOM) {
                                if (System.currentTimeMillis() - this.lastCustomHarvest < 3600000L) {
                                    this.theStage = Stage.HOELAND;
                                    this.step = 1;
                                    this.theFolk.isWorking = false;
                                    return;
                                }
                                this.jobWorld.func_147480_a(this.xxx, this.yyy, this.zzz, true);
                                this.pickUpDroppedCrops(harvestBlock);
                            } else {
                                if (minedStacks != null) {
                                    this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                    for (int s = 0; s < minedStacks.size(); ++s) {
                                        ItemStack stack = minedStacks.get(s);
                                        if (stack == null) continue;
                                        this.inventoriesPut(this.farmingChests, stack, false);
                                    }
                                }
                                this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, this.id, 0, 3);
                            }
                        } else {
                            this.farmingChests = JobCropFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy + 1, this.zzz, this.id, 0, 3);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy + 2, this.zzz, this.id, 0, 3);
                            if (this.farmingBlock.farmType == FarmType.SUGAR) {
                                this.inventoriesPut(this.farmingChests, new ItemStack(Items.field_151120_aE, 2), false);
                            } else if (this.farmingBlock.farmType == FarmType.CACTUS) {
                                this.inventoriesPut(this.farmingChests, new ItemStack(Blocks.field_150434_aF, 2), false);
                            }
                        }
                        if (this.farmingBlock.farmType != FarmType.CUSTOM) {
                            // empty if block
                        }
                        GameStates var10000 = ModSimReloaded.states;
                        var10000.credits -= 0.02f;
                        this.doneSomeWork = true;
                        hasHarvest = true;
                        continue;
                    }
                    hasHarvest = false;
                    done = this.setXYZ();
                    if (!done) continue;
                    this.theStage = Stage.HOELAND;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    return;
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void pickUpDroppedCrops(V3 v3center) {
        try {
            List list1;
            if (this.theFolk.theEntity != null && !(list1 = this.jobWorld.func_72839_b((Entity)this.theFolk.theEntity, AxisAlignedBB.func_72330_a((double)v3center.x, (double)v3center.y, (double)v3center.z, (double)(v3center.x + 1.0), (double)(v3center.y + 1.0), (double)(v3center.z + 1.0)).func_72314_b(3.0, 2.0, 3.0))).isEmpty()) {
                for (int i = 0; i < list1.size(); ++i) {
                    Entity entity1 = (Entity)list1.get(i);
                    if (!(entity1 instanceof EntityItem)) continue;
                    EntityItem entityitem = (EntityItem)entity1;
                    ItemStack is = entityitem.func_92059_d();
                    try {
                        boolean ok;
                        ItemFood food = (ItemFood)is.func_77973_b();
                        if (food == null || !(ok = this.inventoriesPut(this.farmingChests, is, false))) continue;
                        entityitem.func_70106_y();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stageHoeland() {
        try {
            if (this.step == 1) {
                this.setupFarming();
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Tilling", (Object[])new Object[0]);
                this.theFolk.stayPut = true;
                this.theFolk.action = FolkAction.ATWORK;
                this.step = 2;
                this.theFolk.isWorking = true;
                this.rowCounter = 0;
            } else if (this.step == 2) {
                boolean done = false;
                boolean hasTilled = false;
                while (!hasTilled && !done) {
                    GameStates var10000;
                    done = this.setXYZ();
                    if (done) {
                        this.theStage = Stage.PLANTSEEDS;
                        this.step = 1;
                        return;
                    }
                    this.id = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                    this.meta = this.mc.field_71441_e.func_72805_g(this.xxx, this.yyy - 1, this.zzz);
                    if (this.farmingBlock.farmType == FarmType.SUGAR) {
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.preparing", (Object[])new Object[0]);
                        if (this.rowCounter % 3 != 0 && (this.rowCounter + 1) % 3 != 0) {
                            if ((this.rowCounter + 2) % 3 == 0 && this.id != Blocks.field_150355_j) {
                                this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150355_j, 0, 3);
                                hasTilled = true;
                                var10000 = ModSimReloaded.states;
                                var10000.credits -= 0.01f;
                            }
                        } else if (this.id != Blocks.field_150346_d && this.id != Blocks.field_150349_c) {
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150346_d, 0, 3);
                            this.jobWorld.func_72980_b((double)this.xxx, (double)(this.yyy - 1), (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                            hasTilled = true;
                            var10000 = ModSimReloaded.states;
                            var10000.credits -= 0.01f;
                        }
                        ++this.rowCounter;
                        if (this.rowCounter > this.farmingBlock.getSizeWidth() + 1) {
                            this.rowCounter = 0;
                        }
                    } else if (this.farmingBlock.farmType == FarmType.CACTUS) {
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.the_land", (Object[])new Object[0]);
                        if ((this.xxx + this.zzz) % 2 == 0 && this.id != Blocks.field_150354_m) {
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, (Block)Blocks.field_150354_m, 0, 3);
                            hasTilled = true;
                            var10000 = ModSimReloaded.states;
                            var10000.credits -= 0.01f;
                        }
                    } else if (!(this.id != Blocks.field_150349_c && this.id != Blocks.field_150346_d || (this.farmingBlock.farmType != FarmType.MELON && this.farmingBlock.farmType != FarmType.PUMPKIN || this.ftb % 4 != 0 && this.ftb % 4 != 1) && this.farmingBlock.farmType != FarmType.WHEAT && this.farmingBlock.farmType != FarmType.CARROT && this.farmingBlock.farmType != FarmType.POTATO && this.farmingBlock.farmType != FarmType.CUSTOM)) {
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_72980_b((double)this.xxx, (double)(this.yyy - 1), (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                        hasTilled = true;
                        var10000 = ModSimReloaded.states;
                        var10000.credits -= 0.01f;
                    }
                    if (!done) continue;
                    this.theStage = Stage.PLANTSEEDS;
                    this.step = 1;
                    this.theFolk.isWorking = false;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stagePlantSeeds() {
        block38: {
            try {
                if (this.step == 1) {
                    this.setupFarming();
                    this.theFolk.stayPut = true;
                    this.theFolk.action = FolkAction.ATWORK;
                    this.step = 2;
                    this.theFolk.isWorking = true;
                    break block38;
                }
                if (this.step != 2) break block38;
                boolean done = false;
                boolean hasSown = false;
                while (true) {
                    ItemStack seed;
                    if (hasSown || done) {
                        if (done) {
                            this.theStage = Stage.HANGOUT;
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Relaxing_farm", (Object[])new Object[0]);
                            this.step = 1;
                            this.theFolk.isWorking = false;
                            this.inventoriesTransferFromFolk(this.theFolk.inventory, this.farmingChests, null);
                            return;
                        }
                        return;
                    }
                    done = this.setXYZ();
                    if (done) {
                        this.theStage = Stage.HANGOUT;
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Relaxing", (Object[])new Object[0]);
                        this.step = 1;
                        return;
                    }
                    Block gid = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                    Block aid = this.jobWorld.func_147439_a(this.xxx, this.yyy, this.zzz);
                    if (gid != Blocks.field_150354_m && gid != Blocks.field_150349_c && gid != Blocks.field_150346_d && gid != Blocks.field_150458_ak || aid != Blocks.field_150350_a) continue;
                    try {
                        if (this.farmingBlock.farmType != FarmType.CUSTOM) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Planting", (Object[])new Object[0]) + this.farmingBlock.farmType.toString() + I18n.func_135052_a((String)"container.sim.job.crop.farmer.seeds", (Object[])new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.farmingBlock.farmType == FarmType.WHEAT) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151014_N, 1), false, false)) == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.No_more", (Object[])new Object[0]);
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150464_aj, 0, 3);
                        hasSown = true;
                    } else if (this.farmingBlock.farmType == FarmType.PUMPKIN) {
                        if (this.ftb % 4 == 0 || this.ftb % 4 == 1) {
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151080_bb, 1), false, false)) == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.pumpkin", (Object[])new Object[0]);
                                this.theStage = Stage.HANGOUT;
                                this.step = 1;
                                return;
                            }
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150393_bb, 0, 3);
                            hasSown = true;
                        }
                    } else if (this.farmingBlock.farmType == FarmType.MELON) {
                        if (this.ftb % 4 == 0 || this.ftb % 4 == 1) {
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151081_bc, 1), false, false)) == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.melon", (Object[])new Object[0]);
                                this.theStage = Stage.HANGOUT;
                                this.step = 1;
                                return;
                            }
                            this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150394_bc, 0, 3);
                            hasSown = true;
                        }
                    } else if (this.farmingBlock.farmType == FarmType.CARROT) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151172_bF, 1), false, false)) == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.carrots", (Object[])new Object[0]);
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150459_bM, 0, 3);
                        hasSown = true;
                    } else if (this.farmingBlock.farmType == FarmType.POTATO) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151174_bG, 1), false, false)) == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.potatoes", (Object[])new Object[0]);
                            this.theStage = Stage.HANGOUT;
                            this.step = 1;
                            return;
                        }
                        this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                        this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150469_bN, 0, 3);
                        hasSown = true;
                    } else if (this.farmingBlock.farmType == FarmType.SUGAR) {
                        Block cid = this.jobWorld.func_147439_a(this.xxx, this.yyy - 1, this.zzz);
                        if (cid == Blocks.field_150346_d || cid == Blocks.field_150349_c || cid == Blocks.field_150354_m) {
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Items.field_151120_aE, 1), false, false)) == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.sugar", (Object[])new Object[0]);
                                this.theStage = Stage.HANGOUT;
                                this.step = 1;
                                return;
                            }
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150436_aH, 0, 3);
                            hasSown = true;
                        }
                    } else if (this.farmingBlock.farmType == FarmType.CACTUS) {
                        if ((this.xxx + this.zzz) % 2 == 0) {
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(Blocks.field_150434_aF, 1), false, false)) == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.cactus", (Object[])new Object[0]);
                                this.theStage = Stage.HANGOUT;
                                this.step = 1;
                                return;
                            }
                            this.jobWorld.func_147465_d(this.xxx, this.yyy, this.zzz, Blocks.field_150434_aF, 0, 3);
                            hasSown = true;
                        }
                    } else if (this.farmingBlock.farmType == FarmType.CUSTOM) {
                        block5: for (int ch = 0; ch < this.farmingChests.size(); ++ch) {
                            IInventory chest = this.farmingChests.get(ch);
                            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                                ItemStack chestStack = chest.func_70301_a(g);
                                if (chestStack == null) continue;
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Planting", (Object[])new Object[0]) + chestStack.func_82833_r();
                                seed = JobCropFarmer.inventoriesGet(this.farmingChests, new ItemStack(chestStack.func_77973_b(), 1), false, false);
                                if (seed == null) continue;
                                this.jobWorld.func_147465_d(this.xxx, this.yyy - 1, this.zzz, Blocks.field_150458_ak, 0, 3);
                                hasSown = seed.func_77973_b().func_77648_a(seed, (EntityPlayer)this.mc.field_71439_g, this.jobWorld, this.xxx, this.yyy - 1, this.zzz, 1, 0.0f, 0.0f, 0.0f);
                                if (hasSown) break block5;
                                this.theFolk.inventory.add(seed);
                                break block5;
                            }
                        }
                    }
                    if (!hasSown) continue;
                    this.jobWorld.func_72980_b((double)this.xxx, (double)this.yyy, (double)this.zzz, Blocks.field_150349_c.field_149762_H.func_150498_e(), 1.0f, 1.0f, false);
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits -= 0.01f;
                    this.doneSomeWork = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stageHangout() {
        try {
            if (this.step == 1) {
                this.lastFarmCycle = System.currentTimeMillis();
                this.step = 2;
                this.theFolk.isWorking = false;
            } else if (this.step == 2) {
                int r;
                Random ra = new Random();
                int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (dist > 3) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
                if ((r = ra.nextInt(10)) == 0) {
                    this.theFolk.statusText = GameMode.gameMode == GameMode.GAMEMODES.HARDCORE ? I18n.func_135052_a((String)"container.sim.job.crop.farmer.Wow", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.sim.job.crop.farmer.Facebook", (Object[])new Object[0]);
                } else if (r == 1) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Checking", (Object[])new Object[0]);
                } else if (r == 2) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Wishing", (Object[])new Object[0]);
                } else if (r == 3) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Having", (Object[])new Object[0]);
                } else if (r == 4) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Cleaning", (Object[])new Object[0]);
                } else if (r == 5) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Sharpening", (Object[])new Object[0]);
                } else if (r == 6) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Eating", (Object[])new Object[0]);
                } else if (r == 7) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Reticulating", (Object[])new Object[0]);
                } else if (r == 8) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Relaxing", (Object[])new Object[0]);
                } else if (r == 9) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Minecraft", (Object[])new Object[0]);
                }
                if (System.currentTimeMillis() - this.lastFarmCycle > 180000L) {
                    this.theStage = Stage.HARVEST;
                    this.step = 1;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.crop.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATFARM;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

