/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobEggFarmer
extends Job {
    public Vocation vocation = null;
    public Stage theStage;
    public FolkData theFolk;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private ArrayList<IInventory> farmChests = new ArrayList();

    public JobEggFarmer(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            this.runDelay = this.theStage == Stage.FEEDINGCHICKENS ? 40000 : 10000;
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATFARM) {
                        this.stageArrived();
                    } else if (this.theStage == Stage.FEEDINGCHICKENS) {
                        this.stageWaiting();
                    } else if (this.theStage == Stage.COLLECTINGEGGS) {
                        this.stageCollectingEggs();
                    } else if (this.theStage == Stage.STORINGEGGS) {
                        this.stageStoringEggs();
                    } else if (this.theStage == Stage.CANTWORK) {
                        this.stageCantWork();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageArrived() {
        try {
            this.vocation = this.theFolk.vocation;
            this.theStage = Stage.FEEDINGCHICKENS;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.Feeding", (Object[])new Object[0]);
            int count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityChicken.class);
            if (count < 6) {
                this.spawnHens(this.theFolk.employedAt, 6 - count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaiting() {
        try {
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 10.0) {
                this.theFolk.beamMeTo(this.theFolk.employedAt);
            }
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.Raking", (Object[])new Object[0]);
            this.theStage = Stage.COLLECTINGEGGS;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCollectingEggs() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.Collecting", (Object[])new Object[0]);
            this.theStage = Stage.STORINGEGGS;
            this.theFolk.isWorking = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageStoringEggs() {
        try {
            Random rand = new Random();
            int c = rand.nextInt(7);
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.Storing", (Object[])new Object[0]);
            this.theFolk.isWorking = false;
            this.farmChests = JobEggFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.farmChests.size() > 0) {
                boolean ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151110_aK, c + 1, 0), true);
                if (!ok) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.egg.farmer.chests_eggs", (Object[])new Object[0]));
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.chests_full", (Object[])new Object[0]);
                    this.theStage = Stage.CANTWORK;
                } else {
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits -= 0.05f;
                    this.theStage = Stage.FEEDINGCHICKENS;
                }
            } else {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.egg_chests", (Object[])new Object[0]);
                this.theStage = Stage.CANTWORK;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCantWork() {
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.egg.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATFARM;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void spawnHens(V3 controlBox, int count) {
        EntityChicken newAnimal = null;
        try {
            for (int c = 1; c <= count; ++c) {
                newAnimal = new EntityChicken(this.jobWorld);
                newAnimal.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
                if (this.jobWorld.field_72995_K) continue;
                this.jobWorld.func_72838_d((Entity)newAnimal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

