/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobFisherman
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207254191941L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient long timeSinceLastCaughtFish = 0L;
    private transient int fishCount = 0;
    private transient ArrayList<IInventory> dockChests = new ArrayList();

    public JobFisherman(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            this.runDelay = this.theStage == Stage.CAUGHTFISH ? 20000 + new Random().nextInt(20000) : 2000;
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATDOCK) {
                        this.stageArrived();
                    } else if (this.theStage == Stage.FISHING) {
                        this.stageFishing();
                    } else if (this.theStage == Stage.CAUGHTFISH) {
                        this.stageCaughtFish();
                    } else if (this.theStage == Stage.SELLINGFISH) {
                        this.stageSellingFish();
                    } else if (this.theStage == Stage.CANTWORK) {
                        this.stageCantWork();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageArrived() {
        try {
            V3 water = Job.findClosestBlockType(this.theFolk.employedAt, Blocks.field_150355_j, 5, false);
            if (water == null) {
                this.theStage = Stage.CANTWORK;
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.Fisherman", (Object[])new Object[0]));
                return;
            }
            this.theStage = Stage.FISHING;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.Casting", (Object[])new Object[0]);
            this.fishCount = 0;
            if (this.jobWorld.field_72995_K) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCantWork() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.round", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageFishing() {
        try {
            this.theFolk.updateLocationFromEntity();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 3) {
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.Fishing", (Object[])new Object[0]);
                if (System.currentTimeMillis() - this.timeSinceLastCaughtFish > 50000L) {
                    this.theStage = Stage.CAUGHTFISH;
                }
                if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L > 11980L) {
                    this.theStage = Stage.SELLINGFISH;
                    this.step = 1;
                }
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCaughtFish() {
        try {
            this.timeSinceLastCaughtFish = System.currentTimeMillis();
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.Caught", (Object[])new Object[0]);
            ++this.fishCount;
            GameStates var10000 = ModSimReloaded.states;
            var10000.credits -= 0.02f;
            this.dockChests = JobFisherman.inventoriesFindClosest(this.theFolk.employedAt, 4);
            if (this.dockChests.size() == 0) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.someone", (Object[])new Object[0]);
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.dock", (Object[])new Object[0]));
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.func_145779_a(Items.field_151115_aP, 1);
                }
            } else {
                this.inventoriesPut(this.dockChests, new ItemStack(Items.field_151115_aP, 1), true);
            }
            this.theStage = Stage.FISHING;
            this.theFolk.updateLocationFromEntity();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 3) {
                this.theFolk.stayPut = true;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageSellingFish() {
        try {
            if (this.mc.func_71401_C().field_71305_c[0].func_72820_D() % 24000L < 11600L) {
                this.theStage = Stage.IDLE;
                return;
            }
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.caught_done", (Object[])new Object[0]) + this.fishCount + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.fish", (Object[])new Object[0]);
            if (this.step == 1) {
                ItemStack fishStack = null;
                if (ModSimReloaded.theFolks.size() > 1) {
                    int sell = ModSimReloaded.theFolks.size() + 1;
                    this.dockChests = JobFisherman.inventoriesFindClosest(this.theFolk.employedAt, 4);
                    fishStack = JobFisherman.inventoriesGet(this.dockChests, new ItemStack(Items.field_151115_aP, sell), false, false);
                }
                if (fishStack == null) {
                    this.theStage = Stage.IDLE;
                    return;
                }
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.caughts", (Object[])new Object[0]) + this.fishCount + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.and_has", (Object[])new Object[0]) + fishStack.field_77994_a + I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.to_folks", (Object[])new Object[0]));
                for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
                    FolkData folk = ModSimReloaded.theFolks.get(f);
                    if (fishStack.field_77994_a <= 0) continue;
                    folk.levelFood = 10;
                    --fishStack.field_77994_a;
                }
                this.step = 2;
                return;
            }
            if (this.step != 2) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.fisherman.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATDOCK;
                this.timeSinceLastCaughtFish = System.currentTimeMillis();
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.fishCount = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

