/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class JobGlassMaker
extends Job
implements Serializable {
    private static final long serialVersionUID = 1177111222904279141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient V3 blockOfSand = null;
    private transient ArrayList<IInventory> factoryChests = new ArrayList();
    private transient TileEntityFurnace factoryFurnace = null;
    private long lastGotocmd = 0L;
    private int gotoCount = 0;

    public JobGlassMaker() {
    }

    public JobGlassMaker(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.IDLE) {
                this.runDelay = 2000;
                this.theStage = Stage.SCANFORSAND;
            } else {
                this.runDelay = this.theStage != Stage.COLLECTSAND && this.theStage != Stage.GOTOSANDBLOCK && this.theStage != Stage.SCANFORSAND ? 2000 : 250;
                if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                    this.timeSinceLastRun = System.currentTimeMillis();
                    if (this.factoryFurnace == null) {
                        this.factoryFurnace = this.findFurnace(this.theFolk.employedAt);
                    }
                    if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                        if (this.theStage == Stage.SCANFORSAND) {
                            this.stageScanForSand();
                        } else if (this.theStage == Stage.GOTOSANDBLOCK) {
                            this.stageGotoSandBlock();
                        } else if (this.theStage == Stage.COLLECTSAND) {
                            this.stageCollectSand();
                        } else if (this.theStage == Stage.RETURNSAND) {
                            this.stageReturnSand();
                        } else if (this.theStage == Stage.USEFURNACE) {
                            this.stageUseFurnace();
                        } else if (this.theStage == Stage.CANTWORK) {
                            this.stageCantWork();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCantWork() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.There", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageScanForSand() {
        try {
            if (this.theFolk.statusText.contains(I18n.func_135052_a((String)"container.sim.Arrived", (Object[])new Object[0])) || this.theFolk.statusText.contains(I18n.func_135052_a((String)"container.sim.glass", (Object[])new Object[0]))) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Going", (Object[])new Object[0]);
            }
            try {
                this.blockOfSand = JobGlassMaker.findClosestBlockType(this.theFolk.employedAt, (Block)Blocks.field_150354_m, 80, true);
                if (this.blockOfSand == null) {
                    this.theStage = Stage.USEFURNACE;
                    return;
                }
                this.theStage = Stage.GOTOSANDBLOCK;
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGotoSandBlock() {
        try {
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.field_70733_aJ = 0.0f;
            }
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.blockOfSand);
            if (dist > 4.0 && System.currentTimeMillis() - this.lastGotocmd > 10000L) {
                this.theFolk.stayPut = false;
                this.theFolk.gotoXYZ(this.blockOfSand, null);
                this.theFolk.stayPut = false;
                this.lastGotocmd = System.currentTimeMillis();
            }
            this.theStage = Stage.COLLECTSAND;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCollectSand() {
        block8: {
            try {
                this.runDelay = 1000;
                this.theFolk.isWorking = true;
                this.theFolk.updateLocationFromEntity();
                double dist = this.theFolk.location.getDistanceTo(this.blockOfSand);
                if (dist > 6.0 && System.currentTimeMillis() - this.lastGotocmd > 10000L) {
                    this.theFolk.gotoXYZ(this.blockOfSand, null);
                    this.theFolk.stayPut = false;
                    this.lastGotocmd = System.currentTimeMillis();
                    ++this.gotoCount;
                    if (this.gotoCount > 2) {
                        this.gotoCount = 0;
                        V3 bs = this.blockOfSand.clone();
                        bs = new V3(bs.x - 1.0, bs.y + 1.0, bs.z, bs.theDimension);
                        this.theFolk.beamMeTo(bs);
                    }
                    break block8;
                }
                if (dist > 6.0) break block8;
                try {
                    if (dist < 6.0) {
                        // empty if block
                    }
                    this.gotoCount = 0;
                    this.jobWorld.func_147465_d(this.blockOfSand.x.intValue(), this.blockOfSand.y.intValue(), this.blockOfSand.z.intValue(), this.blockOfSand.blockID, 0, 3);
                    this.mc.field_71441_e.func_72980_b(this.blockOfSand.x.doubleValue(), this.blockOfSand.y.doubleValue(), this.blockOfSand.z.doubleValue(), "step.sand", 1.0f, 1.0f, false);
                    this.theFolk.inventory.add(new ItemStack((Block)Blocks.field_150354_m, 1));
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Diggy", (Object[])new Object[0]) + this.theFolk.inventory.size();
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits = (float)((double)var10000.credits - 0.012);
                    if (this.theFolk.inventory.size() < 64) {
                        this.theStage = Stage.SCANFORSAND;
                        break block8;
                    }
                    this.theStage = Stage.RETURNSAND;
                    this.step = 1;
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageReturnSand() {
        this.theFolk.isWorking = false;
        try {
            if (this.step == 1) {
                V3 adj = this.theFolk.employedAt.clone();
                adj = new V3(adj.x - 1.0, adj.y + 1.0, adj.z, adj.theDimension);
                this.theFolk.gotoXYZ(adj, null);
                this.step = 2;
            } else if (this.step == 2) {
                double dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) < 4.0) {
                    this.theFolk.stayPut = true;
                    this.step = 3;
                } else if (this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
            } else if (this.step == 3) {
                this.factoryChests = JobGlassMaker.inventoriesFindClosest(this.theFolk.employedAt, 5);
                this.openCloseChest(this.factoryChests.get(0), 1000);
                boolean placed = this.inventoriesTransferFromFolk(this.theFolk.inventory, this.factoryChests, null);
                this.theStage = Stage.USEFURNACE;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageUseFurnace() {
        try {
            this.factoryFurnace = this.findFurnace(this.theFolk.employedAt);
            this.factoryChests = JobGlassMaker.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.factoryFurnace == null) {
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.glass.farmer.Where", (Object[])new Object[0]));
            } else if (this.step == 1) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Checking", (Object[])new Object[0]);
                ItemStack currentSand = this.factoryFurnace.func_70301_a(1);
                ItemStack gotFuel = null;
                if (currentSand == null) {
                    gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack(Items.field_151044_h, 64), false, false, new ItemStack(Items.field_151044_h, 64));
                    if (gotFuel == null) {
                        gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack(Items.field_151129_at, 1), false, false, new ItemStack(Items.field_151129_at, 1));
                    }
                    if (gotFuel == null) {
                        gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack(Blocks.field_150364_r, 64), false, false, new ItemStack(Blocks.field_150364_r, 64));
                    }
                    if (gotFuel == null) {
                        gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack(Blocks.field_150344_f, 64), false, false, new ItemStack(Blocks.field_150344_f, 1));
                    }
                    if (gotFuel == null) {
                        ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.glass.farmer.furnace", (Object[])new Object[0]));
                        this.theStage = Stage.SCANFORSAND;
                        this.step = 1;
                        return;
                    }
                    this.factoryFurnace.func_70299_a(1, gotFuel);
                    this.step = 2;
                    return;
                }
                this.step = 2;
            } else if (this.step == 2) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Adding", (Object[])new Object[0]);
                if (this.factoryFurnace != null) {
                    ItemStack currentSand = this.factoryFurnace.func_70301_a(0);
                    ItemStack gotFuel = null;
                    if (currentSand == null) {
                        gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack((Block)Blocks.field_150354_m, 64), false, false, new ItemStack((Block)Blocks.field_150354_m, 64));
                        if (gotFuel != null) {
                            this.factoryFurnace.func_70299_a(0, gotFuel);
                        }
                        this.step = 3;
                        return;
                    }
                    gotFuel = JobGlassMaker.inventoriesGet(this.factoryChests, new ItemStack((Block)Blocks.field_150354_m, 64 - currentSand.field_77994_a), false, false, new ItemStack((Block)Blocks.field_150354_m, 64 - currentSand.field_77994_a));
                    if (gotFuel != null) {
                        currentSand.field_77994_a += gotFuel.field_77994_a;
                        this.factoryFurnace.func_70299_a(0, currentSand);
                    }
                    this.step = 3;
                    return;
                }
            } else if (this.step == 3) {
                ItemStack currentSand = this.factoryFurnace.func_70301_a(2);
                if (currentSand != null) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Putting", (Object[])new Object[0]);
                    this.inventoriesPut(this.factoryChests, currentSand, true);
                    GameStates var10000 = ModSimReloaded.states;
                    var10000.credits = (float)((double)var10000.credits - 0.005 * (double)currentSand.field_77994_a);
                    this.factoryFurnace.func_70299_a(2, (ItemStack)null);
                } else {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.glass", (Object[])new Object[0]);
                }
                this.theStage = Stage.SCANFORSAND;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.glass.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.USEFURNACE;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

