/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.block.functionality.FarmingBox;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.enums.FarmType;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobGrocer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177119265904279141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> grocerChests = new ArrayList();
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient FarmingBox farm = null;
    private transient boolean onRoute = false;

    public JobGrocer() {
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public JobGrocer(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.runDelay = 10000;
                this.theFolk.action = FolkAction.ATWORK;
            }
            if (this.theStage == Stage.COLLECTINGFOOD) {
                this.runDelay = 4000;
            }
            if (this.theStage == Stage.SELLINGFOOD) {
                this.runDelay = 10000;
                this.theFolk.action = FolkAction.ATWORK;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATSHOP) {
                        this.stageArrived();
                    } else if (this.theStage == Stage.GOINGTOFOODFARM) {
                        this.stageGoingToFoodFarm();
                    } else if (this.theStage == Stage.COLLECTINGFOOD) {
                        this.stageCollectingFood();
                    } else if (this.theStage == Stage.GOBACKTOSTORE) {
                        this.stageGoBackToStore();
                    } else if (this.theStage == Stage.SELLINGFOOD) {
                        this.stageSellingFood();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageArrived() {
        try {
            this.currentFarmNum = 0;
            this.theFolk.stayPut = true;
            this.theStage = Stage.GOINGTOFOODFARM;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoingToFoodFarm() {
        block11: {
            try {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Fetching", (Object[])new Object[0]);
                if (!this.onRoute) {
                    this.farm = this.getCurrentFarm();
                    if (this.farm == null) {
                        this.theStage = Stage.GOBACKTOSTORE;
                    } else {
                        this.onRoute = true;
                        this.theFolk.gotoXYZ(this.farm.getLocation(), null);
                    }
                    break block11;
                }
                double dist = 0.0;
                try {
                    if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                        this.theFolk.updateLocationFromEntity();
                    }
                    dist = this.theFolk.location.getDistanceTo(this.farm.location);
                }
                catch (Exception var4) {
                    this.theStage = Stage.GOBACKTOSTORE;
                }
                if (dist < 3.0) {
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.onRoute = false;
                    this.theStage = Stage.COLLECTINGFOOD;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    return;
                }
                if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageCollectingFood() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Collecting", (Object[])new Object[0]);
            if (this.step == 1) {
                if (this.farm == null) {
                    this.theStage = Stage.GOINGTOFOODFARM;
                    return;
                }
                this.farmChests = JobGrocer.inventoriesFindClosest(this.farm.getLocation(), 5);
                if (this.farmChests.size() > 0) {
                    this.theFolk.stayPut = true;
                    this.farmChests.get(0).func_70295_k_();
                    this.step = 2;
                }
            } else if (this.step == 2) {
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151127_ba, 640), Blocks.field_150346_d);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Blocks.field_150423_aK, 640), null);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151172_bF, 640), null);
                this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151174_bG, 640), null);
                this.step = 3;
            } else if (this.step == 3) {
                this.farmChests.get(0).func_70305_f();
                this.theStage = Stage.GOINGTOFOODFARM;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGoBackToStore() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Taking", (Object[])new Object[0]);
            if (!this.onRoute) {
                this.onRoute = true;
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            } else {
                double dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1.0) {
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.onRoute = false;
                    this.theStage = Stage.SELLINGFOOD;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    return;
                }
                if (this.theFolk.destination == null) {
                    this.onRoute = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageSellingFood() {
        try {
            this.grocerChests = JobGrocer.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.step == 1) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Unloading", (Object[])new Object[0]);
                int sell = this.getInventoryCount(this.theFolk, Blocks.field_150423_aK);
                int melons = this.getInventoryCount(this.theFolk, Items.field_151127_ba);
                int f = this.getInventoryCount(this.theFolk, Items.field_151172_bF);
                int c = this.getInventoryCount(this.theFolk, Items.field_151174_bG);
                this.pay = (float)((double)sell * 0.2);
                this.pay += (float)((double)melons * 0.05);
                this.pay += (float)((double)f * 0.05);
                this.pay += (float)((double)c * 0.05);
                this.inventoriesTransferFromFolk(this.theFolk.inventory, this.grocerChests, null);
                GameStates var10000 = ModSimReloaded.states;
                var10000.credits -= this.pay;
                this.step = 2;
                return;
            }
            if (this.step == 2) {
                this.theFolk.updateLocationFromEntity();
                int sell = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
                if (sell > 2 && this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Selling", (Object[])new Object[0]);
                if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L <= 11600L) return;
                this.step = 3;
                return;
            }
            if (this.step == 3) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.grocer.farmer.Closing", (Object[])new Object[0]);
                int sell = 0;
                ItemStack piece = null;
                block4: for (int f = 0; f < ModSimReloaded.theFolks.size(); ++f) {
                    for (int c = 0; c < this.grocerChests.size(); ++c) {
                        IInventory chest = this.grocerChests.get(c);
                        for (int g = 0; g < chest.func_70302_i_(); ++g) {
                            ItemStack chestStack = chest.func_70301_a(g);
                            try {
                                int count = new Random().nextInt(3) + 1;
                                ItemFood food = (ItemFood)chestStack.func_77973_b();
                                piece = JobGrocer.inventoriesGet(this.grocerChests, new ItemStack(chestStack.func_77973_b(), count), false, false);
                                FolkData folk = ModSimReloaded.theFolks.get(f);
                                folk.levelFood = 10;
                                sell += count;
                                continue block4;
                            }
                            catch (Exception var11) {
                                continue;
                            }
                        }
                    }
                }
                if (sell > 0) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.grocer.farmer.grocer", (Object[])new Object[0]) + sell + I18n.func_135052_a((String)"container.sim.job.grocer.farmer.folks", (Object[])new Object[0]));
                } else {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.grocer.farmer.today", (Object[])new Object[0]));
                }
                this.step = 4;
                return;
            }
            if (this.step != 4) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FarmingBox getCurrentFarm() {
        boolean found = false;
        FarmingBox farm = null;
        try {
            while (!found) {
                try {
                    farm = ModSimReloaded.theFarmingBoxes.get(this.currentFarmNum);
                }
                catch (Exception var4) {
                    return null;
                }
                if (farm == null) {
                    return null;
                }
                if (farm.farmType != FarmType.MELON && farm.farmType != FarmType.PUMPKIN && farm.farmType != FarmType.CARROT && farm.farmType != FarmType.POTATO) {
                    ++this.currentFarmNum;
                    if (this.currentFarmNum <= ModSimReloaded.theFarmingBoxes.size() - 1) continue;
                    return null;
                }
                found = true;
                ++this.currentFarmNum;
                return farm;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.Arrived_at_the_store", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATSHOP;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

