/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobLivestockFarmer
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112209988279141L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private ArrayList<IInventory> farmChests = new ArrayList();
    EntityAnimal redShirt = null;

    public JobLivestockFarmer() {
    }

    public JobLivestockFarmer(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, GotoMethod.BEAM);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.WAITINGFORMATUREANIMAL) {
                this.runDelay = 20000;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATFARM) {
                        this.stageArrived();
                    } else if (this.theStage == Stage.WAITINGFORMATUREANIMAL) {
                        this.stageWaiting();
                    } else if (this.theStage == Stage.SLAUGHTERING) {
                        this.stageSlaughtering();
                    } else if (this.theStage == Stage.CANTWORK) {
                        this.stageCantWork();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageArrived() {
        try {
            int count;
            this.vocation = this.theFolk.vocation;
            this.theStage = Stage.WAITINGFORMATUREANIMAL;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.Starting", (Object[])new Object[0]);
            if (this.vocation == Vocation.CATTLEFARMER) {
                int count2 = this.getAnimalCountInPen(this.theFolk.employedAt, EntityCow.class);
                if (count2 < 2) {
                    this.spawnAnimals(this.theFolk.employedAt, "Cow", 6 - count2);
                }
            } else if (this.vocation == Vocation.CHICKENFARMER) {
                int count3 = this.getAnimalCountInPen(this.theFolk.employedAt, EntityChicken.class);
                if (count3 < 2) {
                    this.spawnAnimals(this.theFolk.employedAt, "Chicken", 6 - count3);
                }
            } else if (this.vocation == Vocation.PIGFARMER && (count = this.getAnimalCountInPen(this.theFolk.employedAt, EntityPig.class)) < 2) {
                this.spawnAnimals(this.theFolk.employedAt, "Pig", 6 - count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaiting() {
        try {
            this.vocation = this.theFolk.vocation;
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 10.0) {
                this.theFolk.beamMeTo(this.theFolk.employedAt);
            }
            List list = null;
            if (this.vocation == Vocation.CATTLEFARMER) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.Feeding", (Object[])new Object[0]);
                list = this.jobWorld.func_72872_a(EntityCow.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
            } else if (this.vocation == Vocation.CHICKENFARMER) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.chickens", (Object[])new Object[0]);
                list = this.jobWorld.func_72872_a(EntityChicken.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
            } else if (this.vocation == Vocation.PIGFARMER) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.pigs", (Object[])new Object[0]);
                list = this.jobWorld.func_72872_a(EntityPig.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(4.0, 2.0, 4.0));
            }
            int adultCount = 0;
            EntityAnimal animal = null;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    animal = (EntityAnimal)list.get(i);
                    if (animal.func_70631_g_()) continue;
                    ++adultCount;
                    this.redShirt = animal;
                }
                if (adultCount > 2) {
                    this.theStage = Stage.SLAUGHTERING;
                } else if (adultCount <= 2 && list.size() < 10) {
                    EntityAnimal a1 = null;
                    EntityAnimal a2 = null;
                    for (int i = 0; i < list.size(); ++i) {
                        animal = (EntityAnimal)list.get(i);
                        if (animal.func_70631_g_()) continue;
                        if (a1 == null) {
                            a1 = animal;
                            continue;
                        }
                        if (a2 != null) continue;
                        a2 = animal;
                    }
                    if (a1 != null && a2 != null) {
                        a2.func_70778_a(this.jobWorld.func_72865_a((Entity)a2, (Entity)a1, 20.0f, true, true, true, true));
                        this.procreate(a1, new V3(a1.field_70165_t, a1.field_70163_u, a1.field_70161_v, this.theFolk.location.theDimension));
                    }
                    this.theStage = Stage.WAITINGFORMATUREANIMAL;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.Raking", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageSlaughtering() {
        try {
            Random rand = new Random();
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.Off", (Object[])new Object[0]);
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.func_70625_a((Entity)this.redShirt, 1.0f, 1.0f);
            }
            this.redShirt.func_70606_j(0.0f);
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            int quant = 0;
            this.farmChests = JobLivestockFarmer.inventoriesFindClosest(this.theFolk.employedAt, 5);
            boolean ok = true;
            if (this.vocation == Vocation.CATTLEFARMER) {
                quant = rand.nextInt(2) + 1;
                ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151082_bd, quant), true);
                this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151116_aA, 1), false);
            } else if (this.vocation == Vocation.PIGFARMER) {
                quant = rand.nextInt(2) + 1;
                ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151147_al, quant), true);
            } else if (this.vocation == Vocation.CHICKENFARMER) {
                quant = rand.nextInt(2) + 1;
                ok = this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151076_bf, quant), true);
                this.inventoriesPut(this.farmChests, new ItemStack(Items.field_151008_G, 1), false);
            }
            if (!ok) {
                this.theStage = Stage.CANTWORK;
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.livestock.farmer.chests", (Object[])new Object[0]));
            } else {
                GameStates var10000 = ModSimReloaded.states;
                var10000.credits -= 0.02f * (float)quant;
                this.theStage = Stage.WAITINGFORMATUREANIMAL;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCantWork() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.meat", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void procreate(EntityAnimal parentAnimal, V3 pos) {
        try {
            EntityAgeable babyAnimal = parentAnimal.func_90011_a((EntityAgeable)parentAnimal);
            Random rand = new Random();
            if (babyAnimal != null) {
                parentAnimal.func_90011_a(babyAnimal);
                babyAnimal.func_70873_a(-3000);
                babyAnimal.func_70012_b(parentAnimal.field_70165_t, parentAnimal.field_70163_u, parentAnimal.field_70161_v, parentAnimal.field_70177_z, parentAnimal.field_70125_A);
                for (int var3 = 0; var3 < 7; ++var3) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.mc.field_71441_e.func_72869_a("heart", pos.x + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0, pos.y + 0.5 + (double)(rand.nextFloat() * 1.0f), pos.z + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0, d, d1, d2);
                }
                parentAnimal.field_70170_p.func_72838_d((Entity)babyAnimal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void spawnAnimals(V3 controlBox, String animal, int count) {
        EntityPig newAnimal = null;
        try {
            for (int c = 1; c <= count; ++c) {
                if (animal.contentEquals("Pig")) {
                    newAnimal = new EntityPig(this.jobWorld);
                } else if (animal.contentEquals("Cow")) {
                    newAnimal = new EntityCow(this.jobWorld);
                } else if (animal.contentEquals("Chicken")) {
                    newAnimal = new EntityChicken(this.jobWorld);
                }
                newAnimal.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
                if (this.jobWorld.field_72995_K) continue;
                this.jobWorld.func_72838_d((Entity)newAnimal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.livestock.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATFARM;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

