/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ConfigLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobLumberjack
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904887741L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> millChests = new ArrayList();
    private transient V3 foundWoodAt = new V3();
    private transient Building lumbermill = null;
    private transient long startedGoing = 0L;
    public transient boolean isChopping = false;
    private transient float pay = 0.0f;
    private transient boolean onRoute = false;

    public JobLumberjack() {
    }

    public JobLumberjack(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage == Stage.IDLE && ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.SCANFORTREE;
                } else if (this.theStage == Stage.ARRIVEDATMILL) {
                    this.theStage = Stage.SCANFORTREE;
                } else if (this.theStage == Stage.SCANFORTREE) {
                    this.stageScanForTree();
                } else if (this.theStage == Stage.GOTOTREE) {
                    this.pickUpSaplings();
                    this.stageGotoTree();
                } else if (this.theStage == Stage.CHOPPINGTREE) {
                    this.stageChoppingTree();
                    this.pickUpSaplings();
                } else if (this.theStage == Stage.RETURNWOOD) {
                    this.stageReturnWood();
                    this.pickUpSaplings();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageScanForTree() {
        try {
            this.theFolk.action = FolkAction.ATWORK;
            this.theFolk.isWorking = false;
            V3 searchXYZ = null;
            this.lumbermill = Building.getBuilding(this.theFolk.employedAt);
            V3 ts = null;
            try {
                searchXYZ = this.lumbermill.lumbermillMarker != null ? this.lumbermill.lumbermillMarker : (this.theFolk.employedAt != null ? this.theFolk.employedAt.clone() : this.theFolk.location.clone());
                ts = searchXYZ.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            V3 searchpos = ts != null ? ts.clone() : this.theFolk.location.clone();
            try {
                this.foundWoodAt = JobLumberjack.findClosestBlockType(searchpos, Blocks.field_150364_r, ConfigLoader.configLumberArea, false);
                this.foundWoodAt.theDimension = this.jobWorld.field_73011_w.field_76574_g;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.theStage = Stage.GOTOTREE;
            this.onRoute = false;
            if (this.foundWoodAt == null) {
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.wood", (Object[])new Object[0]));
                this.theFolk.selfFire();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGotoTree() {
        try {
            this.theFolk.isWorking = false;
            if (!this.onRoute) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.Going", (Object[])new Object[0]);
                this.theFolk.gotoXYZ(this.foundWoodAt, null);
                this.startedGoing = System.currentTimeMillis();
                this.onRoute = true;
            } else {
                double dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.foundWoodAt)) < 7.0) {
                    this.theStage = Stage.CHOPPINGTREE;
                    this.theFolk.stayPut = true;
                    this.step = 1;
                } else {
                    if (this.theFolk.destination != null || this.theFolk.theEntity != null) {
                        // empty if block
                    }
                    if (System.currentTimeMillis() - this.startedGoing > 25000L) {
                        this.theStage = Stage.CHOPPINGTREE;
                        this.theFolk.stayPut = true;
                        this.theFolk.destination = null;
                        this.step = 1;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageChoppingTree() {
        block18: {
            try {
                int count;
                if (this.step == 1) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.Choppy", (Object[])new Object[0]);
                    this.theFolk.isWorking = true;
                    for (int i = 0; i < 20; ++i) {
                        int l = this.foundWoodAt.x.intValue();
                        int y = this.foundWoodAt.y.intValue() - 1;
                        int z = this.foundWoodAt.z.intValue();
                        if (this.jobWorld == null) {
                            this.theFolk.selfFire();
                            return;
                        }
                        if (this.jobWorld.func_147439_a(l, y, z) != Blocks.field_150364_r) break;
                        this.foundWoodAt.y = y;
                    }
                    this.step = 2;
                    break block18;
                }
                if (this.step == 2) {
                    if (this.jobWorld.func_147439_a(this.foundWoodAt.x.intValue(), this.foundWoodAt.y.intValue(), this.foundWoodAt.z.intValue()) == Blocks.field_150364_r) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                JobLumberjack.this.isChopping = true;
                                for (int d = 0; d < 12; ++d) {
                                    try {
                                        JobLumberjack.this.mc.field_71441_e.func_72980_b(JobLumberjack.this.theFolk.location.x.doubleValue(), JobLumberjack.this.theFolk.location.y.doubleValue(), JobLumberjack.this.theFolk.location.z.doubleValue(), "step.wood", 1.0f, 1.0f, false);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (JobLumberjack.this.theFolk.theEntity == null) continue;
                                    JobLumberjack.this.theFolk.theEntity.field_70733_aJ = 0.3f;
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    JobLumberjack.this.theFolk.theEntity.field_70733_aJ = 0.7f;
                                    try {
                                        Thread.sleep(100L);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                JobLumberjack.this.isChopping = false;
                            }
                        });
                        t.start();
                        this.step = 3;
                    } else {
                        this.step = 4;
                    }
                    break block18;
                }
                if (this.step == 3) {
                    if (this.isChopping) {
                        return;
                    }
                    ArrayList<ItemStack> log = this.translateBlockWhenMined(this.jobWorld, this.foundWoodAt);
                    this.jobWorld.func_147465_d(this.foundWoodAt.x.intValue(), this.foundWoodAt.y.intValue(), this.foundWoodAt.z.intValue(), Blocks.field_150350_a, 0, 3);
                    if (log != null) {
                        for (int l = 0; l < log.size(); ++l) {
                            ItemStack isl = log.get(l);
                            this.theFolk.inventory.add(isl);
                        }
                    }
                    int count2 = this.getInventoryCount(this.theFolk, Blocks.field_150364_r);
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.Got", (Object[])new Object[0]) + count2 + I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.logs_so_far", (Object[])new Object[0]);
                    this.theFolk.stayPut = false;
                    this.foundWoodAt.y = this.foundWoodAt.y + 1.0;
                    this.step = 2;
                    break block18;
                }
                if (this.step != 4) break block18;
                if (this.theFolk.isSpawned()) {
                    count = this.getInventoryCount(this.theFolk, Blocks.field_150345_g);
                    if (count > 0) {
                        for (int i = 0; i < this.theFolk.inventory.size(); ++i) {
                            ItemStack fis = this.theFolk.inventory.get(i);
                            if (fis == null || Block.func_149634_a((Item)fis.func_77973_b()) != Blocks.field_150345_g) continue;
                            this.theFolk.inventory.remove(i);
                            this.plantSapling(Block.func_149634_a((Item)fis.func_77973_b()));
                            break;
                        }
                    }
                } else {
                    this.plantSapling(Blocks.field_150345_g);
                }
                if ((count = this.getInventoryCount(this.theFolk, Blocks.field_150364_r)) < 12) {
                    this.theStage = Stage.SCANFORTREE;
                } else {
                    this.theStage = Stage.RETURNWOOD;
                    this.step = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageReturnWood() {
        try {
            this.theFolk.isWorking = false;
            if (this.step == 1) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.Delivering", (Object[])new Object[0]);
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                this.step = 2;
            } else if (this.step == 2) {
                int dist;
                if (this.theFolk.gotoMethod == GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1) {
                    this.step = 3;
                } else if (this.theFolk.destination == null && this.theFolk.theEntity != null) {
                    // empty if block
                }
            } else if (this.step == 3) {
                this.theFolk.stayPut = true;
                int dist = this.getInventoryCount(this.theFolk, Blocks.field_150364_r);
                this.millChests = JobLumberjack.inventoriesFindClosest(this.theFolk.employedAt, 6);
                this.inventoriesTransferFromFolk(this.theFolk.inventory, this.millChests, new ItemStack(Blocks.field_150364_r));
                this.pay = (float)dist * 0.03f;
                GameStates var10000 = ModSimReloaded.states;
                var10000.credits -= this.pay;
                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.delivered", (Object[])new Object[0]) + dist + I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.lumbermill", (Object[])new Object[0]));
                this.theStage = Stage.SCANFORTREE;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.lumberjack.farmer.a_lumberjack", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATMILL;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pickUpSaplings() {
        try {
            if (this.theFolk.isSpawned()) {
                List list1 = this.jobWorld.func_72839_b((Entity)this.theFolk.theEntity, AxisAlignedBB.func_72330_a((double)this.theFolk.theEntity.field_70165_t, (double)this.theFolk.theEntity.field_70163_u, (double)this.theFolk.theEntity.field_70161_v, (double)(this.theFolk.theEntity.field_70165_t + 1.0), (double)(this.theFolk.theEntity.field_70163_u + 1.0), (double)(this.theFolk.theEntity.field_70161_v + 1.0)).func_72314_b(3.0, 4.0, 3.0));
                Iterator iterator1 = list1.iterator();
                if (!list1.isEmpty()) {
                    while (iterator1.hasNext()) {
                        Entity entity1 = (Entity)iterator1.next();
                        if (!(entity1 instanceof EntityItem)) continue;
                        EntityItem entityitem = (EntityItem)entity1;
                        ItemStack is = entityitem.func_92059_d();
                        try {
                            Item ID = is.func_77973_b();
                            if (ID != Item.func_150898_a((Block)Blocks.field_150345_g)) continue;
                            this.theFolk.inventory.add(new ItemStack(Blocks.field_150345_g, is.func_77960_j(), 1));
                            entityitem.func_70106_y();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void plantSapling(Block is) {
        try {
            if (this.theFolk.isSpawned()) {
                if (this.jobWorld.func_147439_a((int)this.theFolk.theEntity.field_70165_t, (int)this.theFolk.theEntity.field_70163_u, (int)this.theFolk.theEntity.field_70161_v) == null) {
                    this.jobWorld.func_147449_b((int)this.theFolk.theEntity.field_70165_t, (int)this.theFolk.theEntity.field_70163_u, (int)this.theFolk.theEntity.field_70161_v, is);
                }
            } else {
                this.jobWorld.func_147465_d(this.theFolk.location.x.intValue(), this.theFolk.location.y.intValue(), this.theFolk.location.z.intValue(), Blocks.field_150345_g, 0, 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

