/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.block.functionality.MiningBox;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.common.loader.ModSimReloaded;
import com.trhsy.sim.util.GameMode;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobMiner
extends Job
implements Serializable {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient int step = 1;
    private long timeSinceLastChestFullMessage = 0L;
    transient Long timeSinceLastGoto = 0L;
    transient ArrayList<IInventory> miningChests = null;
    String mineDir = "";
    String mineHorizontalDir = "";
    V3 vNextMineableBlock = null;
    transient boolean swingToggle = true;
    private boolean isChestsFull = false;
    private MiningBox theMiningBox;
    private String lastMinedBlockName = "";

    public JobMiner() {
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JobMiner(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            this.theMiningBox = MiningBox.getMiningBlockByBoxXYZ(folk.employedAt);
            if (this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            if (this.theMiningBox == null) {
                ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.miner.farmer.There", (Object[])new Object[0]) + this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.using", (Object[])new Object[0]));
                this.theFolk.selfFire();
            } else if (this.theMiningBox.marker1XYZ != null && this.theMiningBox.marker2XYZ == null) {
                V3 xyz = this.theMiningBox.location;
                int mbX = xyz.x.intValue();
                int mbZ = xyz.z.intValue();
                xyz = this.theMiningBox.marker1XYZ;
                int mX = xyz.x.intValue();
                int mZ = xyz.z.intValue();
                if (mbX < mX) {
                    this.mineHorizontalDir = "+x";
                } else if (mbX > mX) {
                    this.mineHorizontalDir = "-x";
                } else if (mbZ < mZ) {
                    this.mineHorizontalDir = "+z";
                } else if (mbZ > mZ) {
                    this.mineHorizontalDir = "-z";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            try {
                if (!ModSimReloaded.isDayTime()) {
                    this.theStage = Stage.IDLE;
                    this.theFolk.action = FolkAction.WANDER;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Finished", (Object[])new Object[0]);
                    this.theFolk.isWorking = false;
                    return;
                }
                super.onUpdateGoingToWork(this.theFolk);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.theStage == Stage.WAITINGFORCHEST) {
                this.runDelay = 6000;
            }
            if (this.theStage == Stage.BEAMINGDOWN) {
                this.runDelay = 4000;
            }
            if (this.theStage == Stage.MINING) {
                this.runDelay = (int)(2000.0f / this.theFolk.levelMiner);
                if (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE) {
                    this.runDelay = 10;
                }
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
                return;
            }
            this.timeSinceLastRun = System.currentTimeMillis();
            if (this.theFolk.vocation != Vocation.MINER) {
                this.theFolk.selfFire();
                return;
            }
            if (this.theStage == Stage.IDLE && ModSimReloaded.isDayTime()) {
                this.theStage = Stage.WAITINGFORCHEST;
            } else if (this.theStage == Stage.WAITINGFORCHEST) {
                this.stageWaitingForChest();
            } else if (this.theStage == Stage.BEAMINGDOWN) {
                this.stageBeamingDown();
            } else if (this.theStage == Stage.MINING) {
                this.stageMining();
            } else if (this.theStage == Stage.BEAMINGUP) {
                this.stageBeamingUp();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = 0;
            dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Arrived", (Object[])new Object[0]);
                this.step = 1;
                this.theStage = Stage.WAITINGFORCHEST;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaitingForChest() {
        block9: {
            try {
                this.theFolk.stayPut = true;
                this.theFolk.isWorking = false;
                if (this.isChestsFull) {
                    if (System.currentTimeMillis() - this.timeSinceLastChestFullMessage > 120000L) {
                        ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.stopped", (Object[])new Object[0]));
                        this.timeSinceLastChestFullMessage = System.currentTimeMillis();
                    }
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.All", (Object[])new Object[0]);
                    this.miningChests = JobMiner.inventoriesFindClosest(this.theFolk.employedAt, 5);
                    ItemStack is = new ItemStack(Blocks.field_150346_d, 1);
                    Boolean placedOk = this.inventoriesPut(this.miningChests, is, true);
                    if (placedOk.booleanValue()) {
                        JobMiner.inventoriesGet(this.miningChests, is, false, false);
                        this.theFolk.inventory.clear();
                        this.isChestsFull = false;
                        this.theStage = Stage.BEAMINGDOWN;
                        this.setNextMineableBlock();
                    }
                    break block9;
                }
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Checking", (Object[])new Object[0]);
                this.miningChests = JobMiner.inventoriesFindClosest(this.theFolk.employedAt, 5);
                if (this.miningChests.size() == 0) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.mining", (Object[])new Object[0]);
                    break block9;
                }
                this.theStage = Stage.BEAMINGDOWN;
                if (this.theFolk.theEntity == null) break block9;
                try {
                    if (this.theFolk.gender == 0) {
                        this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readym", 1.0f, 1.0f, false);
                        break block9;
                    }
                    this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:readyf", 1.0f, 1.0f, false);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageBeamingDown() {
        block12: {
            try {
                if (this.vNextMineableBlock == null) {
                    this.setNextMineableBlock();
                }
                if (this.vNextMineableBlock != null) {
                    this.theFolk.updateLocationFromEntity();
                    if (this.theFolk.location.getDistanceTo(this.vNextMineableBlock) < 10 || !(this.vNextMineableBlock.y <= 20.0)) {
                        this.theStage = Stage.MINING;
                        this.theFolk.stayPut = true;
                        return;
                    }
                    if (this.step == 1) {
                        if (this.theFolk.beamingTo == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Beam", (Object[])new Object[0]);
                            if (this.theFolk.theEntity != null) {
                                if (this.theFolk.gender == 0) {
                                    this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:beamm", 1.0f, 1.0f, false);
                                } else {
                                    this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "sim:beamf", 1.0f, 1.0f, false);
                                }
                            }
                            this.theFolk.stayPut = true;
                            this.theFolk.beamMeTo(this.vNextMineableBlock.clone());
                            this.step = 2;
                        }
                    } else if (this.step == 2 && this.theFolk.destination == null) {
                        this.theStage = Stage.MINING;
                        return;
                    }
                    break block12;
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageBeamingUp() {
        try {
            this.theFolk.beamMeTo(this.theFolk.employedAt.clone());
            this.theStage = Stage.IDLE;
            this.theFolk.action = FolkAction.WANDER;
            ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.finished", (Object[])new Object[0]));
            this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setNextMineableBlock() {
        block57: {
            try {
                Double ltrCount2;
                Double ftbCount2;
                V3 idmeta2;
                int xxx = 0;
                int yyy = 0;
                int zzz = 0;
                V3 m1 = this.theMiningBox.marker1XYZ;
                V3 m2 = this.theMiningBox.marker2XYZ;
                V3 m3 = this.theMiningBox.marker3XYZ;
                if (m1 == null) {
                    ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.miner.farmer.markers", (Object[])new Object[0]));
                    return;
                }
                if (this.mineHorizontalDir.contentEquals("")) {
                    int mx = m1.x.intValue();
                    int my = m1.y.intValue() - 1;
                    int mz = m1.z.intValue();
                    if (m2.x.intValue() == m1.x.intValue()) {
                        this.mineDir = m2.z.intValue() > mz ? "z+" : "z-";
                    } else if (m2.z.intValue() == m1.z.intValue()) {
                        this.mineDir = m2.x.intValue() > mx ? "x+" : "x-";
                    }
                    Block id = null;
                    int idmeta2 = 0;
                    int ftbCount2 = 0;
                    int ltrCount2 = 0;
                    int xo = 0;
                    int zo = 0;
                    ltrCount2 = m1.x.intValue() == m2.x.intValue() ? Math.abs(m2.z.intValue() - m1.z.intValue()) - 1 : Math.abs(m2.x.intValue() - m1.x.intValue()) - 1;
                    ftbCount2 = m1.x.intValue() == m3.x.intValue() ? Math.abs(m3.z.intValue() - m1.z.intValue()) - 1 : Math.abs(m3.x.intValue() - m1.x.intValue()) - 1;
                    block10: for (int l = my; l > 0; --l) {
                        for (int ftb = 0; ftb <= ftbCount2; ++ftb) {
                            for (int ltr = 1; ltr <= ltrCount2; ++ltr) {
                                if (this.mineDir.contentEquals("x+")) {
                                    xo = ltr;
                                    zo = -ftb;
                                } else if (this.mineDir.contentEquals("x-")) {
                                    xo = -ltr;
                                    zo = ftb;
                                } else if (this.mineDir.contentEquals("z+")) {
                                    xo = ftb;
                                    zo = ltr;
                                } else if (this.mineDir.contentEquals("z-")) {
                                    xo = -ftb;
                                    zo = -ltr;
                                }
                                xxx = mx + xo;
                                yyy = l;
                                zzz = mz + zo;
                                id = this.jobWorld.func_147439_a(xxx, yyy, zzz);
                                idmeta2 = this.jobWorld.func_72805_g(xxx, yyy, zzz);
                                if (id == Blocks.field_150357_h) {
                                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.bedrock", (Object[])new Object[0]));
                                    this.theFolk.beamMeTo(this.theFolk.employedAt);
                                    this.theFolk.selfFire();
                                    return;
                                }
                                try {
                                    Block block = id;
                                    if (id == Blocks.field_150350_a || id == Blocks.field_150355_j || id == Blocks.field_150355_j || id == Blocks.field_150353_l || id == Blocks.field_150353_l || block.toString().toLowerCase().contains("oil")) continue;
                                }
                                catch (Exception var26) {}
                                break block10;
                            }
                        }
                    }
                    try {
                        this.vNextMineableBlock = new V3(Double.valueOf(xxx), Double.valueOf(yyy), Double.valueOf(zzz), this.theFolk.employedAt.theDimension);
                    }
                    catch (Exception l) {}
                    break block57;
                }
                V3 vMine = new V3(m1.x, m1.y, m1.z, this.theFolk.employedAt.theDimension);
                if (this.mineHorizontalDir.contentEquals("+x")) {
                    idmeta2 = vMine;
                    ftbCount2 = idmeta2.x;
                    ltrCount2 = idmeta2.x = Double.valueOf(idmeta2.x + 1.0);
                } else if (this.mineHorizontalDir.contentEquals("-x")) {
                    idmeta2 = vMine;
                    ftbCount2 = idmeta2.x;
                    ltrCount2 = idmeta2.x = Double.valueOf(idmeta2.x - 1.0);
                } else if (this.mineHorizontalDir.contentEquals("+z")) {
                    idmeta2 = vMine;
                    ftbCount2 = idmeta2.z;
                    ltrCount2 = idmeta2.z = Double.valueOf(idmeta2.z + 1.0);
                } else if (this.mineHorizontalDir.contentEquals("-z")) {
                    idmeta2 = vMine;
                    ftbCount2 = idmeta2.z;
                    ltrCount2 = idmeta2.z = Double.valueOf(idmeta2.z - 1.0);
                }
                V3 vMineable = new V3();
                Object id = null;
                int meta = 0;
                int xo = 0;
                int yo = 0;
                int zo = 0;
                boolean flagFound = false;
                block13: for (int ftb = 0; ftb < 1024; ++ftb) {
                    for (int btt = 0; btt < this.theMiningBox.size; ++btt) {
                        for (int ltr = 0; ltr < this.theMiningBox.size; ++ltr) {
                            if (this.mineHorizontalDir.contentEquals("+x")) {
                                xo = ftb;
                                zo = ltr;
                            } else if (this.mineHorizontalDir.contentEquals("-x")) {
                                xo = -ftb;
                                zo = -ltr;
                            } else if (this.mineHorizontalDir.contentEquals("+z")) {
                                xo = -ltr;
                                zo = ftb;
                            } else if (this.mineHorizontalDir.contentEquals("-z")) {
                                xo = ltr;
                                zo = -ftb;
                            }
                            yo = btt;
                            try {
                                if (this.theFolk.employedAt == null) {
                                    this.theStage = Stage.IDLE;
                                    return;
                                }
                                vMineable = new V3(vMine.x + (double)xo, vMine.y + (double)yo, vMine.z + (double)zo, this.theFolk.employedAt.theDimension);
                                id = this.jobWorld.func_147439_a(vMineable.x.intValue(), vMineable.y.intValue(), vMineable.z.intValue());
                                meta = this.jobWorld.func_72805_g(vMineable.x.intValue(), vMineable.y.intValue(), vMineable.z.intValue());
                                if (ftb % 10 == 0 && (double)btt == Math.floor(this.theMiningBox.size / 2) && ltr == 0) {
                                    Double d;
                                    V3 v3;
                                    V3 lightbox = vMineable.clone();
                                    if (this.mineHorizontalDir.contentEquals("+x")) {
                                        v3 = lightbox;
                                        d = v3.z;
                                        Double d2 = v3.z = Double.valueOf(v3.z - 1.0);
                                    } else if (this.mineHorizontalDir.contentEquals("-x")) {
                                        v3 = lightbox;
                                        d = v3.z;
                                        Double d3 = v3.z = Double.valueOf(v3.z + 1.0);
                                    } else if (this.mineHorizontalDir.contentEquals("+z")) {
                                        v3 = lightbox;
                                        d = v3.x;
                                        Double d4 = v3.x = Double.valueOf(v3.x + 1.0);
                                    } else if (this.mineHorizontalDir.contentEquals("-z")) {
                                        v3 = lightbox;
                                        d = v3.x;
                                        Double d5 = v3.x = Double.valueOf(v3.x - 1.0);
                                    }
                                    Block lbid = this.jobWorld.func_147439_a(lightbox.x.intValue(), lightbox.y.intValue(), lightbox.z.intValue());
                                    if (this.miningChests.size() > 0 && lbid != BlockLoader.lightBox) {
                                        ItemStack light = null;
                                        for (int lightmeta = 0; light == null && lightmeta < 8; ++lightmeta) {
                                            light = JobMiner.inventoriesGet(this.miningChests, new ItemStack(BlockLoader.lightBox, 1, lightmeta), false, true);
                                        }
                                        if (light != null) {
                                            ModSimReloaded.log.info("\u706f\u7bb1\u653e\u7f6e\u5728 " + lightbox.toString());
                                            this.jobWorld.func_147465_d(lightbox.x.intValue(), lightbox.y.intValue(), lightbox.z.intValue(), BlockLoader.lightBox, light.func_77960_j(), 3);
                                        }
                                    }
                                }
                            }
                            catch (Exception lightbox) {
                                // empty catch block
                            }
                            if (id == Blocks.field_150357_h) {
                                ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.retired", (Object[])new Object[0]));
                                this.theFolk.beamMeTo(this.theFolk.employedAt);
                                this.theFolk.selfFire();
                                return;
                            }
                            try {
                                Object block = id;
                                if (id == null || id == Blocks.field_150355_j || id == Blocks.field_150355_j || id == Blocks.field_150353_l || id == Blocks.field_150353_l || id.toString().toLowerCase().contains("oil")) continue;
                                flagFound = true;
                            }
                            catch (Exception var28) {
                                flagFound = true;
                            }
                            break block13;
                        }
                    }
                }
                if (!flagFound) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.horizontal", (Object[])new Object[0]));
                    this.theFolk.beamMeTo(this.theFolk.employedAt);
                    this.theFolk.isWorking = false;
                    this.theFolk.selfFire();
                    return;
                }
                this.vNextMineableBlock = vMineable.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stageMining() {
        try {
            this.theFolk.isWorking = true;
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.field_71093_bK = this.theFolk.employedAt.theDimension;
            } else {
                this.theFolk.location.theDimension = this.theFolk.employedAt.theDimension;
            }
            this.theFolk.action = FolkAction.ATWORK;
            if (this.theFolk.isSpawned() && System.currentTimeMillis() - this.timeSinceLastGoto > 7000L) {
                this.theFolk.updateLocationFromEntity();
                if (this.theFolk.location.y - this.vNextMineableBlock.y > 4.0) {
                    this.vNextMineableBlock.doNotTimeout = false;
                    if (this.vNextMineableBlock.y > 20.0) {
                        this.theFolk.gotoXYZ(this.vNextMineableBlock, GotoMethod.BEAM);
                    } else {
                        this.theFolk.stayPut = true;
                    }
                } else {
                    this.vNextMineableBlock.doNotTimeout = true;
                    if (this.vNextMineableBlock.y > 20.0) {
                        this.theFolk.stayPut = false;
                        this.theFolk.gotoXYZ(this.vNextMineableBlock, GotoMethod.WALK);
                    } else {
                        this.theFolk.stayPut = true;
                    }
                }
                this.timeSinceLastGoto = System.currentTimeMillis();
                this.theFolk.timeStartedGotoing = System.currentTimeMillis();
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int d = 0; d < 5; ++d) {
                        try {
                            JobMiner.this.jobWorld.func_72980_b(JobMiner.this.vNextMineableBlock.x.doubleValue(), JobMiner.this.vNextMineableBlock.y.doubleValue(), JobMiner.this.vNextMineableBlock.z.doubleValue(), "dig.stone", 1.0f, 1.0f, false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            t.start();
            if (this.lastMinedBlockName.contentEquals("")) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Diggy", (Object[])new Object[0]);
            }
            int id = Block.func_149682_b((Block)this.jobWorld.func_147439_a(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue()));
            int idmeta = this.jobWorld.func_72805_g(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue());
            if (this.jobWorld == null) return;
            ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, this.vNextMineableBlock);
            this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.vNextMineableBlock.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150350_a, 0, 3);
            if (this.theFolk.theEntity != null) {
                try {
                    this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), (double)0.1f, (double)0.3f, 0.0);
                    this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), 0.0, (double)0.2f, 0.0);
                    this.mc.field_71441_e.func_72869_a("explode", (double)this.vNextMineableBlock.x.intValue(), (double)this.vNextMineableBlock.y.intValue(), (double)this.vNextMineableBlock.z.intValue(), 0.0, (double)0.1f, (double)0.1f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                int aft;
                GameStates var10000 = ModSimReloaded.states;
                var10000.credits -= 0.012f;
                int b4 = (int)Math.floor(this.theFolk.levelMiner);
                if (this.theFolk.levelMiner < 10.0f) {
                    FolkData var16 = this.theFolk;
                    this.theFolk.levelMiner = (float)((double)this.theFolk.levelMiner + 0.001 / (double)b4);
                }
                if (b4 != (aft = (int)Math.floor(this.theFolk.levelMiner))) {
                    ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.miner.farmer.levelled", (Object[])new Object[0]) + aft);
                }
            } else {
                this.theFolk.levelMiner = 10.0f;
            }
            if (this.theFolk.employedAt == null) return;
            if (this.theFolk.employedAt.y - this.vNextMineableBlock.y > 3.0) {
                if (this.theMiningBox.addGlassCover && this.mineHorizontalDir.contentEquals("")) {
                    ItemStack glass;
                    Block gid = this.jobWorld.func_147439_a(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue());
                    if (gid == null && this.miningChests.size() > 0 && (glass = JobMiner.inventoriesGet(this.miningChests, new ItemStack(Blocks.field_150359_w, 1), false, false)) != null) {
                        this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150359_w, 0, 3);
                    }
                } else {
                    this.jobWorld.func_147465_d(this.vNextMineableBlock.x.intValue(), this.theFolk.employedAt.y.intValue(), this.vNextMineableBlock.z.intValue(), Blocks.field_150350_a, 0, 2);
                }
            }
            boolean keep = false;
            if (this.theMiningBox.discards == 0) {
                keep = true;
            }
            if (this.theMiningBox.discards == 1) {
                keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) && id != Block.func_149682_b((Block)Blocks.field_150349_c);
            }
            if (this.theMiningBox.discards == 2) {
                keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) || id != Block.func_149682_b((Block)Blocks.field_150349_c) || id != Block.func_149682_b((Block)Blocks.field_150348_b) || id != Block.func_149682_b((Block)Blocks.field_150347_e);
            }
            if (this.theMiningBox.discards == 3) {
                keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) || id != Block.func_149682_b((Block)Blocks.field_150349_c) || id != Block.func_149682_b((Block)Blocks.field_150354_m);
            }
            if (this.theMiningBox.discards == 4) {
                keep = id != Block.func_149682_b((Block)Blocks.field_150346_d) || id != Block.func_149682_b((Block)Blocks.field_150349_c) || id != Block.func_149682_b((Block)Blocks.field_150348_b) || id != Block.func_149682_b((Block)Blocks.field_150347_e) || id != Block.func_149682_b((Block)Blocks.field_150354_m);
            }
            try {
                Block block = Block.func_149729_e((int)id);
                if (id == Block.func_149682_b((Block)Blocks.field_150355_j) || id == Block.func_149682_b((Block)Blocks.field_150355_j) || id == Block.func_149682_b((Block)Blocks.field_150353_l) || id == Block.func_149682_b((Block)Blocks.field_150353_l) || id == Block.func_149682_b((Block)Blocks.field_150329_H) || block.toString().toLowerCase().contains("oil")) {
                    keep = false;
                }
            }
            catch (Exception var10) {
                keep = false;
            }
            boolean placedOk = true;
            if (keep && minedStacks != null) {
                this.miningChests = Job.inventoriesFindClosest(this.theFolk.employedAt, 5);
                for (int s = 0; s < minedStacks.size(); ++s) {
                    ItemStack stack = minedStacks.get(s);
                    if (stack == null) continue;
                    this.lastMinedBlockName = stack.func_82833_r();
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.miner.farmer.Diggy", (Object[])new Object[0]) + this.lastMinedBlockName + "!";
                    placedOk = this.inventoriesPut(this.miningChests, stack, false);
                }
            }
            if (!placedOk) {
                this.isChestsFull = true;
                this.theStage = Stage.WAITINGFORCHEST;
                this.theFolk.inventory.clear();
                this.theFolk.inventory.add(new ItemStack(Block.func_149729_e((int)id), idmeta, 1));
            }
            this.setNextMineableBlock();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

