/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.entity.enums.GotoMethod;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class JobShepherd
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112207904191941L;
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient EntitySheep sheepToShear = null;
    private transient boolean isShearing = false;

    public JobShepherd() {
    }

    public JobShepherd(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, GotoMethod.BEAM);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            this.runDelay = this.theStage == Stage.WAITINGFORWOOL ? 15000 : 2000;
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.ARRIVEDATFARM) {
                        this.theStage = Stage.WAITINGFORWOOL;
                    } else if (this.theStage == Stage.WAITINGFORWOOL) {
                        this.stageWaiting();
                    } else if (this.theStage == Stage.SHEARING) {
                        this.stageShearing();
                    } else if (this.theStage == Stage.CANTWORK) {
                        this.stageCantWork();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaiting() {
        try {
            int s;
            Random rand = new Random();
            this.theFolk.isWorking = false;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.Sharpening", (Object[])new Object[0]);
            this.theFolk.stayPut = false;
            List list = this.jobWorld.func_72872_a(EntitySheep.class, AxisAlignedBB.func_72330_a((double)this.theFolk.employedAt.x, (double)this.theFolk.employedAt.y, (double)this.theFolk.employedAt.z, (double)(this.theFolk.employedAt.x + 1.0), (double)(this.theFolk.employedAt.y + 1.0), (double)(this.theFolk.employedAt.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
            Double playerdist = this.mc.field_71439_g.func_70011_f(this.theFolk.employedAt.x.doubleValue(), this.theFolk.employedAt.y.doubleValue(), this.theFolk.employedAt.z.doubleValue());
            if (playerdist > 60.0) {
                try {
                    this.sheepToShear = (EntitySheep)list.get(0);
                    this.sheepToShear.func_70893_e(false);
                }
                catch (Exception var6) {
                    this.placeWoolIntoAChest(1, 1);
                }
            } else if (list.size() > 0) {
                try {
                    s = rand.nextInt(list.size() - 1);
                    this.sheepToShear = (EntitySheep)list.get(s);
                    this.sheepToShear.func_70893_e(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (s = 0; s < list.size(); ++s) {
                this.sheepToShear = (EntitySheep)list.get(s);
                if (this.sheepToShear.func_70892_o()) continue;
                this.theStage = Stage.SHEARING;
                this.step = 1;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageShearing() {
        try {
            this.theFolk.stayPut = false;
            if (this.step == 1) {
                if (this.theFolk.getDistanceToPlayer() < 50) {
                    this.theFolk.gotoXYZ(new V3(this.sheepToShear.field_70165_t, this.sheepToShear.field_70163_u, this.sheepToShear.field_70161_v, this.theFolk.employedAt.theDimension), GotoMethod.WALK);
                }
                this.step = 2;
            } else if (this.step == 2) {
                this.step = 3;
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
                }
            } else if (this.step == 3) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.Shearing", (Object[])new Object[0]) + FolkData.generateName(0, true, "") + I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.sheep", (Object[])new Object[0]);
                this.sheepToShear.func_70893_e(true);
                if (this.theFolk.theEntity != null) {
                    this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
                    this.theFolk.isWorking = true;
                    this.mc.field_71441_e.func_72980_b(this.theFolk.theEntity.field_70165_t, this.theFolk.theEntity.field_70163_u, this.theFolk.theEntity.field_70161_v, "sim:shears", 1.0f, 1.0f, false);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            JobShepherd.this.isShearing = true;
                            for (int d = 0; d < 12; ++d) {
                                JobShepherd.this.spawnExplosionParticle((Entity)JobShepherd.this.sheepToShear);
                                try {
                                    Thread.sleep(150L);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            JobShepherd.this.isShearing = false;
                            JobShepherd.this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.Watching", (Object[])new Object[0]);
                        }
                    });
                    t.start();
                    this.theFolk.theEntity.func_70625_a((Entity)this.sheepToShear, 1.0f, 1.0f);
                    this.step = 4;
                }
            } else if (this.step == 4) {
                Random ra = new Random();
                int count = ra.nextInt(3) + 1;
                this.placeWoolIntoAChest(this.sheepToShear.func_70896_n(), count);
                this.theStage = Stage.WAITINGFORWOOL;
                this.theFolk.isWorking = false;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void spawnExplosionParticle(Entity ent) {
        Random rand = new Random();
        for (int var1 = 0; var1 < 20; ++var1) {
            double var2 = rand.nextGaussian() * 0.02;
            double var4 = rand.nextGaussian() * 0.02;
            double var6 = rand.nextGaussian() * 0.02;
            double var8 = 10.0;
            try {
                ModSim.proxy.getClientWorld().func_72869_a("explode", ent.field_70165_t + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var2 * var8, ent.field_70163_u + (double)(rand.nextFloat() * 1.0f) - var4 * var8, ent.field_70161_v + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0 - var6 * var8, var2, var4, var6);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageCantWork() {
        try {
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.chests", (Object[])new Object[0]);
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean placeWoolIntoAChest(int metaColor, int amount) {
        try {
            GameStates var10000 = ModSimReloaded.states;
            var10000.credits -= 0.02f * (float)amount;
            this.farmChests = JobShepherd.inventoriesFindClosest(this.theFolk.employedAt, 4);
            this.inventoriesPut(this.farmChests, new ItemStack(Blocks.field_150325_L, amount, metaColor), true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void spawnSheepIfNeeded(V3 controlBox) {
        try {
            List list = this.jobWorld.func_72872_a(EntitySheep.class, AxisAlignedBB.func_72330_a((double)controlBox.x, (double)controlBox.y, (double)controlBox.z, (double)(controlBox.x + 1.0), (double)(controlBox.y + 1.0), (double)(controlBox.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
            Random ra = new Random();
            if (list.size() > 0 && list.size() < 6) {
                for (int fuck = 0; fuck < 6 - list.size(); ++fuck) {
                    EntitySheep sheep = new EntitySheep(this.jobWorld);
                    sheep.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
                    sheep.func_70891_b(ra.nextInt(12) + 1);
                    this.jobWorld.func_72838_d((Entity)sheep);
                }
            } else if (list.size() == 0) {
                EntitySheep sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x - 1.0, controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
                sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x.doubleValue(), controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
                sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z - 1.0, 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
                sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z.doubleValue(), 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
                sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x + 1.0, controlBox.y + 1.0, controlBox.z + 1.0, 0.0f, 0.0f);
                sheep.func_70891_b(ra.nextInt(12) + 1);
                this.jobWorld.func_72838_d((Entity)sheep);
                sheep = new EntitySheep(this.jobWorld);
                sheep.func_70012_b(controlBox.x + 2.0, controlBox.y + 1.0, controlBox.z + 2.0, 0.0f, 0.0f);
                this.jobWorld.func_72838_d((Entity)sheep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.shepherd.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.ARRIVEDATFARM;
                this.spawnSheepIfNeeded(this.theFolk.employedAt);
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, GotoMethod.BEAM);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

