/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.jobs;

import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.entity.enums.FolkAction;
import com.trhsy.sim.common.jobs.Job;
import com.trhsy.sim.common.jobs.Stage;
import com.trhsy.sim.common.jobs.TerraformerType;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.ModSimReloaded;
import com.trhsy.sim.util.GameMode;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobTerraformer
extends Job {
    public Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient TerraformerType theType;
    private transient int radius;
    private transient ArrayList<IInventory> constructorChests = new ArrayList();
    private transient int totalBlockCount = 0;
    private transient int counter = 0;
    private transient int buckets = 0;

    public JobTerraformer() {
    }

    public JobTerraformer(FolkData folk) {
        try {
            this.theFolk = folk;
            if (this.theStage == null) {
                this.theStage = Stage.IDLE;
            }
            if (this.theFolk != null && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetJob() {
        try {
            this.theStage = Stage.IDLE;
            this.theFolk.isWorking = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onUpdate() {
        try {
            super.onUpdate();
            if (!ModSimReloaded.isDayTime()) {
                this.theStage = Stage.IDLE;
            }
            super.onUpdateGoingToWork(this.theFolk);
            if (this.theStage == Stage.WAITINGFORRESOURCES) {
                this.runDelay = 4000;
            }
            if (this.theStage == Stage.INPROGRESS) {
                this.runDelay = GameMode.gameMode == GameMode.GAMEMODES.CREATIVE ? 1 : 300;
            }
            if (System.currentTimeMillis() - this.timeSinceLastRun >= (long)this.runDelay) {
                this.timeSinceLastRun = System.currentTimeMillis();
                if (this.theStage != Stage.IDLE || !ModSimReloaded.isDayTime()) {
                    if (this.theStage == Stage.WAITINGFORRESOURCES) {
                        this.stageWaitingForResources();
                    } else if (this.theStage == Stage.INPROGRESS) {
                        this.stageInProgress();
                    } else if (this.theStage == Stage.COMPLETE) {
                        this.stageComplete();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageWaitingForResources() {
        try {
            this.theFolk.isWorking = false;
            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.former.Checking", (Object[])new Object[0]);
            this.constructorChests = JobTerraformer.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.step == 1) {
                if (this.constructorChests.isEmpty()) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.Please", (Object[])new Object[0]);
                } else {
                    this.theType = this.theFolk.terraformerType;
                    this.radius = this.theFolk.terraformerRadius;
                    if (this.theType == null) {
                        this.step = 4;
                    } else {
                        this.step = 2;
                        this.constructorChests.get(0).func_70295_k_();
                    }
                }
            } else if (this.step == 2) {
                this.constructorChests.get(0).func_70305_f();
                this.theStage = Stage.INPROGRESS;
                this.step = 1;
            } else if (this.step == 3) {
                if (this.vocation != Vocation.TERRAFORMER) {
                    this.theFolk.selfFire();
                    return;
                }
                this.step = 4;
                this.theStage = Stage.INPROGRESS;
            } else if (this.step == 4) {
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.choose", (Object[])new Object[0]);
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageInProgress() {
        block91: {
            try {
                ItemStack gotDirt;
                this.theFolk.isWorking = true;
                Random rand = new Random();
                boolean hasPlacedTree = false;
                ItemStack is = null;
                this.constructorChests = JobTerraformer.inventoriesFindClosest(this.theFolk.employedAt, 5);
                if (this.step == 1) {
                    if (this.theType == TerraformerType.WATERTODIRT) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150355_j);
                        blockIDs.add(Blocks.field_150355_j);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, true, false);
                    } else if (this.theType == TerraformerType.NATURE) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150346_d);
                        blockIDs.add((Block)Blocks.field_150349_c);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, true, true, false);
                    } else if (this.theType == TerraformerType.LAWNMOWER) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add((Block)Blocks.field_150329_H);
                        blockIDs.add((Block)Blocks.field_150328_O);
                        blockIDs.add((Block)Blocks.field_150327_N);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, true, false);
                    } else if (this.theType == TerraformerType.FLATTENIZER) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add((Block)Blocks.field_150349_c);
                        blockIDs.add(Blocks.field_150346_d);
                        blockIDs.add((Block)Blocks.field_150329_H);
                        blockIDs.add(Blocks.field_150348_b);
                        blockIDs.add((Block)Blocks.field_150354_m);
                        blockIDs.add(Blocks.field_150322_A);
                        blockIDs.add(Blocks.field_150351_n);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(this.theFolk.employedAt, blockIDs, this.radius, false, false, false);
                    } else if (this.theType == TerraformerType.VALUEPACK) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150350_a);
                        blockIDs.add((Block)Blocks.field_150329_H);
                        blockIDs.add((Block)Blocks.field_150328_O);
                        blockIDs.add((Block)Blocks.field_150327_N);
                        V3 v = new V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y - 1.0, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, true);
                    } else if (this.theType == TerraformerType.GLACIAL) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150350_a);
                        blockIDs.add((Block)Blocks.field_150329_H);
                        blockIDs.add(Blocks.field_150355_j);
                        blockIDs.add(Blocks.field_150355_j);
                        V3 v = new V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(v, blockIDs, this.radius, true, true, false);
                    } else if (this.theType == TerraformerType.MOISTURIZER) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150353_l);
                        blockIDs.add(Blocks.field_150353_l);
                        V3 v = new V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
                    } else if (this.theType == TerraformerType.THERMALIZER) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150353_l);
                        V3 v = new V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
                    } else if (this.theType == TerraformerType.DEICER) {
                        ArrayList<Block> blockIDs = new ArrayList<Block>();
                        blockIDs.add(Blocks.field_150433_aE);
                        V3 v = new V3(this.theFolk.employedAt.x, this.theFolk.employedAt.y, this.theFolk.employedAt.z, this.theFolk.employedAt.theDimension);
                        this.closestBlocks = null;
                        this.setClosestBlocksOfType(v, blockIDs, this.radius, false, true, false);
                    }
                    this.step = 2;
                    break block91;
                }
                if (this.step == 2) {
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.Scanning", (Object[])new Object[0]);
                    break block91;
                }
                if (this.step == 3) {
                    this.totalBlockCount = this.closestBlocks.size();
                    if (this.totalBlockCount == 0) {
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.Nothing", (Object[])new Object[0]);
                        ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.job.terra.farmer.terraformed", (Object[])new Object[0]));
                        this.theFolk.selfFire();
                        return;
                    }
                    this.step = 4;
                    this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.process", (Object[])new Object[0]);
                    break block91;
                }
                if (this.step != 4) break block91;
                if (this.theType == TerraformerType.WATERTODIRT) {
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Blocks.field_150346_d, 1), false, false)) == null) {
                        this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.dirt", (Object[])new Object[0]);
                        this.theStage = Stage.WAITINGFORRESOURCES;
                        this.step = 1;
                        return;
                    }
                } else if (this.theType == TerraformerType.NATURE) {
                    ++this.counter;
                    hasPlacedTree = false;
                    if (this.counter % 15 == 0) {
                        hasPlacedTree = true;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            is = JobTerraformer.inventoriesGet(this.constructorChests, null, true, false);
                            if (is == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.saplings", (Object[])new Object[0]);
                                this.theStage = Stage.WAITINGFORRESOURCES;
                                this.step = 1;
                                return;
                            }
                        } else {
                            is = new ItemStack(Blocks.field_150345_g, 1, new Random().nextInt(4));
                        }
                    }
                } else if (this.theType != TerraformerType.LAWNMOWER && this.theType != TerraformerType.DEICER && this.theType != TerraformerType.FLATTENIZER) {
                    if (this.theType == TerraformerType.VALUEPACK) {
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Blocks.field_150346_d, 1), false, false)) == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.dirt", (Object[])new Object[0]);
                            this.theStage = Stage.WAITINGFORRESOURCES;
                            this.step = 1;
                            return;
                        }
                    } else if (this.theType != TerraformerType.GLACIAL && this.theType != TerraformerType.MOISTURIZER) {
                        if (this.theType == TerraformerType.THERMALIZER && GameMode.gameMode != GameMode.GAMEMODES.CREATIVE && (gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Items.field_151133_ar, 1), false, false)) == null) {
                            this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.buckets", (Object[])new Object[0]);
                            this.theStage = Stage.WAITINGFORRESOURCES;
                            this.step = 1;
                            return;
                        }
                    } else if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        if (this.buckets == 0) {
                            gotDirt = JobTerraformer.inventoriesGet(this.constructorChests, new ItemStack(Items.field_151131_as, 1), false, false);
                            if (gotDirt == null) {
                                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.water", (Object[])new Object[0]);
                                this.theStage = Stage.WAITINGFORRESOURCES;
                                this.step = 1;
                                return;
                            }
                            this.inventoriesPut(this.constructorChests, new ItemStack(Items.field_151133_ar, 1), true);
                            this.buckets = 1000;
                        } else {
                            --this.buckets;
                        }
                    }
                }
                Double x = this.totalBlockCount;
                Double y = this.closestBlocks.size();
                Double percent = (x - y) / x;
                percent = percent * 100.0;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.Terraforming", (Object[])new Object[0]) + ", " + percent.intValue() + " % " + I18n.func_135052_a((String)"container.sim.job.terra.farmer.complete", (Object[])new Object[0]);
                V3 v = (V3)this.closestBlocks.get(0);
                if (this.theType == TerraformerType.WATERTODIRT) {
                    this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150346_d, 0, 3);
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        GameStates var10000 = ModSimReloaded.states;
                        var10000.credits = (float)((double)var10000.credits - 0.009);
                    }
                } else if (this.theType == TerraformerType.NATURE) {
                    if (hasPlacedTree) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), Blocks.field_150345_g, is.func_77960_j(), 3);
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            GameStates var10000 = ModSimReloaded.states;
                            var10000.credits = (float)((double)var10000.credits - 0.009);
                        }
                        this.runDelay = 500;
                    } else {
                        int r = rand.nextInt(10);
                        if (r == 2) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), (Block)Blocks.field_150328_O, 0, 3);
                            this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue() + 1, v.z.intValue());
                        } else if (r == 5) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue() + 1, v.z.intValue(), (Block)Blocks.field_150327_N, 0, 3);
                        }
                        this.runDelay = 50;
                    }
                } else if (this.theType == TerraformerType.LAWNMOWER) {
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, v);
                    if (minedStacks != null) {
                        for (int s = 0; s < minedStacks.size(); ++s) {
                            ItemStack stack = minedStacks.get(s);
                            if (stack == null) continue;
                            this.inventoriesPut(this.constructorChests, stack, false);
                        }
                    }
                    if (this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                        GameStates var10000 = ModSimReloaded.states;
                        var10000.credits = (float)((double)var10000.credits - 0.009);
                    }
                } else if (this.theType != TerraformerType.FLATTENIZER) {
                    if (this.theType == TerraformerType.VALUEPACK) {
                        if (this.mc.field_71441_e.field_72995_K) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150346_d, 0, 3);
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                GameStates var10000 = ModSimReloaded.states;
                                var10000.credits = (float)((double)var10000.credits - 0.009);
                            }
                        }
                    } else if (this.theType == TerraformerType.GLACIAL) {
                        Block blockId = this.jobWorld.func_147439_a(v.x.intValue(), v.y.intValue(), v.z.intValue());
                        if (blockId != null && blockId != Blocks.field_150329_H) {
                            if ((blockId == Blocks.field_150355_j || blockId == Blocks.field_150355_j) && this.mc.field_71441_e.field_72995_K) {
                                this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150432_aD, 0, 3);
                                if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                    GameStates var10000 = ModSimReloaded.states;
                                    var10000.credits = (float)((double)var10000.credits - 0.009);
                                }
                            }
                        } else {
                            Block idBelow = this.jobWorld.func_147439_a(v.x.intValue(), v.y.intValue() - 1, v.z.intValue());
                            if (idBelow != null && idBelow != Blocks.field_150432_aD && idBelow != Blocks.field_150355_j && idBelow != Blocks.field_150355_j && idBelow != Blocks.field_150433_aE && this.mc.field_71441_e.field_72995_K) {
                                this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150433_aE, 0, 3);
                                if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                    GameStates var10000 = ModSimReloaded.states;
                                    var10000.credits = (float)((double)var10000.credits - 0.009);
                                }
                            }
                        }
                    } else if (this.theType == TerraformerType.MOISTURIZER) {
                        if (this.mc.field_71441_e.field_72995_K) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150343_Z, 0, 3);
                            this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                GameStates var10000 = ModSimReloaded.states;
                                var10000.credits = (float)((double)var10000.credits - 0.009);
                            }
                        }
                    } else if (this.theType == TerraformerType.THERMALIZER) {
                        if (this.mc.field_71441_e.field_72995_K) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                            this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                GameStates var10000 = ModSimReloaded.states;
                                var10000.credits = (float)((double)var10000.credits - 0.009);
                            }
                            this.inventoriesPut(this.constructorChests, new ItemStack(Items.field_151129_at, 1), false);
                        }
                    } else if (this.theType == TerraformerType.DEICER && this.mc.field_71441_e.field_72995_K) {
                        this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), (Block)Blocks.field_150349_c, 0, 3);
                        this.jobWorld.func_147471_g(v.x.intValue(), v.y.intValue(), v.z.intValue());
                        ++this.counter;
                        if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                            GameStates var10000 = ModSimReloaded.states;
                            var10000.credits = (float)((double)var10000.credits - 0.009);
                        }
                        if (this.counter % 4 == 0) {
                            this.inventoriesPut(this.constructorChests, new ItemStack(Blocks.field_150433_aE, 1, 0), false);
                        }
                    }
                } else {
                    ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, v);
                    if (minedStacks != null) {
                        for (int s = 0; s < minedStacks.size(); ++s) {
                            ItemStack stack = minedStacks.get(s);
                            if (stack == null) continue;
                            this.inventoriesPut(this.constructorChests, stack, false);
                        }
                    }
                    try {
                        if (this.mc.field_71441_e.field_72995_K) {
                            this.jobWorld.func_147465_d(v.x.intValue(), v.y.intValue(), v.z.intValue(), Blocks.field_150350_a, 0, 3);
                            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                GameStates var10000 = ModSimReloaded.states;
                                var10000.credits = (float)((double)var10000.credits - 0.009);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.closestBlocks.remove(0);
                if (this.closestBlocks.size() == 0) {
                    this.theStage = Stage.COMPLETE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stageComplete() {
        try {
            this.theFolk.isWorking = false;
            ModSimReloaded.sendChat(this.theFolk.name + I18n.func_135052_a((String)"container.sim.job.terra.farmer.has_completed", (Object[])new Object[0]));
            this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
            this.theFolk.stayPut = false;
            this.theFolk.terraformerRadius = 1;
            this.theFolk.terraformerType = null;
            this.theFolk.selfFire();
            this.theStage = Stage.IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onArrivedAtWork() {
        try {
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist <= 1) {
                this.theFolk.action = FolkAction.ATWORK;
                this.theFolk.stayPut = true;
                this.theFolk.statusText = I18n.func_135052_a((String)"container.sim.job.terra.farmer.Arrived", (Object[])new Object[0]);
                this.theStage = Stage.WAITINGFORRESOURCES;
            } else {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

