/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.loader;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    public static Configuration config;
    public static int configPopulationLimit;
    public static int configLumberArea;
    public static boolean configDisableBeamEffect;
    public static boolean configFolkTalking;
    public static boolean configEnableMarkerAlignmentBeams;
    public static boolean configUseExpensiveRecipies;
    public static int configMaterialReminderInterval;
    public static int configHUDoffset;
    public static boolean configStopRain;
    public static boolean configFolkTalkingEnglish;
    public static String[] configMaleNames;
    public static String[] configFemaleNames;
    public static String[] configSurnames;
    private static Logger logger;

    public ConfigLoader(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigLoader.load();
    }

    public static void load() {
        logger.info("\u5f00\u59cb\u52a0\u8f7d\u914d\u7f6e... ");
        try {
            config.addCustomCategoryComment("Blocks", "Blocks");
            Property p = config.get("Settings", "DisableBeamingEffect", false);
            configDisableBeamEffect = p.getBoolean(false);
            p.comment = "This enables or disables the beaming effect (purple particles) - Set to true to turn them off.";
            p = config.get("Settings", "FolkTalking", true);
            configFolkTalking = p.getBoolean(true);
            p.comment = "If the folks BLARG talking gets annoying, set this to false";
            p = config.get("Settings", "FolkTalkingEnglish", true);
            configFolkTalkingEnglish = p.getBoolean(true);
            p.comment = "If the folks ENGLISH talking gets annoying, set this to false";
            p = config.get("Settings", "LumbermillArea", 40);
            configLumberArea = p.getInt();
            p.comment = "The radius in blocks that the lumberjack will look for trees from the starting point, don't set this too high, otherwise it will slow down MC every time they scan for the nearest tree, so 30 to 1000 should be ok (1000 is 1 Kilometre)";
            p = config.get("Settings", "PopulationLimit", 200);
            configPopulationLimit = p.getInt();
            p.comment = "Limit the population from growing beyond this number if you have an older computer";
            p = config.get("Settings", "EnableMarkerAlignmentBeams", false);
            configEnableMarkerAlignmentBeams = p.getBoolean(true);
            p.comment = "When placing a marker it fires out 4 alignment beams, setting this to false will turn those beams off";
            p = config.get("Settings", "UseExpensiveRecipes", true);
            configUseExpensiveRecipies = p.getBoolean(false);
            p.comment = "If you think the mining/farming boxes are too cheap/overpowered, set this to true to make the recipies require diamond tools instead of stone tools";
            p = config.get("Settings", "MaterialReminderInterval", 3);
            configMaterialReminderInterval = p.getInt(3);
            p.comment = "When a builder runs out of materials, they will let you know about it every 3 minutes, set to 0 for no further reminders.";
            if (configMaterialReminderInterval <= 0) {
                configMaterialReminderInterval = 2000;
            }
            p = config.get("Settings", "HUDoffset", 0);
            configHUDoffset = p.getInt(0);
            p.comment = "This positions the HUD (population and money text at the top of the screen) - default is 0, which is the top, value is in pixels, so setting 320 will display it 320 pixels from the top of the screen. Alter this to suit your screen resolution and avoid clashing with other text, setting to minus 10 will display it offscreen.";
            p = config.get("Settings", "StopRain", false);
            configStopRain = p.getBoolean(false);
            p.comment = "This is just a personal mod :-) If you too find it rains ALL THE F***ING TIME in your world and it annoys you/causes lag, set this to true and you'll only have brief showers instead";
            p = config.get("Names", "MaleNames", I18n.func_135052_a((String)"container.sim.MaleNames", (Object[])new Object[0]));
            p.setValue(I18n.func_135052_a((String)"container.sim.MaleNames", (Object[])new Object[0]));
            String temp = p.getString();
            p.comment = "These are the male first names used by the random name generator, keep the format the same or bad things will happen.";
            configMaleNames = temp.split(",");
            p = config.get("Names", "FemaleNames", I18n.func_135052_a((String)"container.sim.FemaleNames", (Object[])new Object[0]));
            p.setValue(I18n.func_135052_a((String)"container.sim.FemaleNames", (Object[])new Object[0]));
            temp = p.getString();
            p.comment = "These are the female first names used by the random name generator, keep the format the same or bad things will happen.";
            configFemaleNames = temp.split(",");
            p = config.get("Names", "LastNames", I18n.func_135052_a((String)"container.sim.LastNames", (Object[])new Object[0]));
            p.setValue(I18n.func_135052_a((String)"container.sim.LastNames", (Object[])new Object[0]));
            temp = p.getString();
            p.comment = "These are the last names used by the random name generator, keep the format the same or bad things will happen.";
            configSurnames = temp.split(",");
        }
        catch (Exception var7) {
            logger.error("\u65e0\u6cd5\u5206\u914d block/item ID - " + var7.toString());
        }
        finally {
            config.save();
            config.load();
            logger.info("\u5df2\u5b8c\u6210\u52a0\u8f7d\u914d\u7f6e... ");
        }
    }

    public static Logger logger() {
        return logger;
    }

    static {
        configPopulationLimit = 100;
        configLumberArea = 30;
        configDisableBeamEffect = false;
        configFolkTalking = true;
        configEnableMarkerAlignmentBeams = true;
        configUseExpensiveRecipies = false;
        configMaterialReminderInterval = 3;
        configHUDoffset = 0;
        configStopRain = false;
        configFolkTalkingEnglish = true;
    }
}

