/*
 * Decompiled with CFR 0.152.
 */
package com.trhsy.sim.common.loader;

import com.trhsy.sim.ModSim;
import com.trhsy.sim.client.gui.other.GuiRunMod;
import com.trhsy.sim.common.Commodity;
import com.trhsy.sim.common.block.functionality.FarmingBox;
import com.trhsy.sim.common.block.functionality.MiningBox;
import com.trhsy.sim.common.entity.Building;
import com.trhsy.sim.common.entity.CourierTask;
import com.trhsy.sim.common.entity.FolkData;
import com.trhsy.sim.common.entity.GameStates;
import com.trhsy.sim.common.entity.PricesForBlocks;
import com.trhsy.sim.common.entity.Relationship;
import com.trhsy.sim.common.entity.V3;
import com.trhsy.sim.common.jobs.JobSoldier;
import com.trhsy.sim.common.jobs.Vocation;
import com.trhsy.sim.common.loader.BlockLoader;
import com.trhsy.sim.util.GameMode;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ModSimReloaded {
    public static Logger log = Logger.getLogger("Sim-U Trhsy Reloaded");
    public static String currentSavePath = "";
    public static ArrayList<FolkData> theFolks = new ArrayList();
    public static ArrayList<Building> theBuildings = new ArrayList();
    public static ArrayList<CourierTask> theCourierTasks = new ArrayList();
    public static ArrayList<V3> theCourierPoints = new ArrayList();
    public static ArrayList<MiningBox> theMiningBoxes = new ArrayList();
    public static ArrayList<FarmingBox> theFarmingBoxes = new ArrayList();
    public static ArrayList<Relationship> theRelationships = new ArrayList();
    public static GameStates states = new GameStates();
    public static ArrayList<Commodity> theCommodities = new ArrayList();
    public static FarmingBox farmToUpgrade = null;
    public static int farmToUpgradeCounter = 0;
    private static ArrayList<V3> farmToUpgradePoints = null;
    public static boolean isDay = true;
    public static ArrayList<V3> demolishBlocks = new ArrayList();
    public static World demolishWorld = null;
    private static GuiRunMod runModui = null;
    int highest = 0;
    int m1 = 0;

    public static void resetAndLoadNewWorld() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        log.info("\u91cd\u7f6e\u5e76\u52a0\u8f7d\u4e16\u754c " + side.toString() + " SIDE");
        theBuildings.clear();
        theCourierPoints.clear();
        theCourierTasks.clear();
        theMiningBoxes.clear();
        theFarmingBoxes.clear();
        theFolks.clear();
        theRelationships.clear();
        File f = new File(ModSimReloaded.getSavesDataFolder() + "settings.sk2");
        if (!f.exists()) {
            f = new File(ModSimReloaded.getSavesDataFolder() + "settings.suk");
        }
        if (f.exists()) {
            states.loadStates();
            try {
                GameMode.setGameModeFromNumber(ModSimReloaded.states.gameModeNumber);
            }
            catch (Exception var3) {
                GameMode.setGameModeFromNumber(0);
            }
        } else {
            states = new GameStates();
            states.saveStates();
        }
        if (states == null) {
            new File(ModSimReloaded.getSavesDataFolder() + "settings.sk2").delete();
            states = new GameStates();
            states.saveStates();
            String sim_settings = I18n.func_135052_a((String)"container.sim.sim_settings", (Object[])new Object[0]);
            ModSimReloaded.sendChat(sim_settings);
        }
        if (ModSimReloaded.states.gameModeNumber == -1) {
            if (runModui == null) {
                GuiRunMod runModui = new GuiRunMod();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)runModui);
            }
        } else {
            if (ModSimReloaded.states.gameModeNumber >= 0) {
                log.info("\u542f\u52a8\u7a0b\u5e8f\u5df2\u7ecf\u8fd0\u884c");
                ModSim.proxy.ranStartup = true;
            }
            String welcome = I18n.func_135052_a((String)"container.sim.welcome", (Object[])new Object[0]);
            String welcomes = I18n.func_135052_a((String)"container.sim.welcomes", (Object[])new Object[0]);
            ModSimReloaded.sendChat(welcome + "1.0.5 Beta" + welcomes);
            theFolks.clear();
            Building.initialiseAllBuildings();
            Building.loadAllBuildings();
            CourierTask.loadCourierTasksAndPoints();
            MiningBox.loadMiningBoxes();
            FarmingBox.loadFarmingBoxes();
            FolkData.loadAndSpawnFolks();
            Relationship.loadRelationships();
            isDay = ModSimReloaded.isDayTime();
            Building.checkTenants();
            ModSim.proxy.ranStartup = true;
        }
    }

    public static void sendChat(String theText) {
        for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
            if (w.field_72995_K) continue;
            for (int k = 0; k < w.field_73010_i.size(); ++k) {
                EntityPlayer p = (EntityPlayer)w.field_73010_i.get(k);
                p.func_146105_b((IChatComponent)new ChatComponentText(theText));
            }
        }
    }

    public static String getSavesDataFolder() {
        String worldname = MinecraftServer.func_71276_C().func_71270_I();
        String strmc = new File(".").getAbsolutePath();
        strmc = strmc.substring(0, strmc.length() - 1);
        File test = new File(strmc + "saves");
        String ret = "";
        if (test.exists()) {
            ret = new File(strmc + File.separator + "saves" + File.separator + worldname + File.separator + "simukraft" + File.separator).getAbsolutePath() + File.separator;
        } else {
            strmc = strmc + worldname + File.separator + "simukraft" + File.separator;
            ret = new File(strmc).getAbsolutePath();
        }
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return ret;
    }

    public static boolean isDayTime() {
        return MinecraftServer.func_71276_C().field_71305_c[0].func_72912_H().func_76073_f() % 24000L <= 11999L;
    }

    public static String displayMoney(float moneyin) {
        DecimalFormat myFormatter = new DecimalFormat("#,##0.00");
        String output = myFormatter.format(moneyin);
        return output;
    }

    private String getTheirId() {
        return null;
    }

    public static void dayTransitionHandler() {
        int f1;
        FolkData folk12;
        int homeless;
        if (ModSimReloaded.isDayTime() && !isDay) {
            EntityClientPlayerMP p;
            isDay = true;
            log.info("\u5929\u4eae\u4e86");
            World world = ModSim.proxy.getClientWorld();
            if (world != null && (p = Minecraft.func_71410_x().field_71439_g) != null) {
                ModSim.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "sim:rooster", 1.0f, 1.0f, false);
            }
            ++ModSimReloaded.states.dayOfWeek;
            if (ModSimReloaded.states.dayOfWeek > 6) {
                ModSimReloaded.states.dayOfWeek = 0;
                homeless = 0;
                for (FolkData folk12 : theFolks) {
                    if (folk12.getHome() != null) continue;
                    ++homeless;
                }
                if (homeless > 1) {
                    String sim_residential = I18n.func_135052_a((String)"container.sim.sim_residential", (Object[])new Object[0]);
                    String sim_residentials = I18n.func_135052_a((String)"container.sim.sim_residentials", (Object[])new Object[0]);
                    ModSimReloaded.sendChat(sim_residential + homeless + sim_residentials);
                }
            }
            ModSimReloaded.evolveFolks();
            if (theFolks.size() > 1) {
                Random rand = new Random();
                int f2 = f1 = rand.nextInt(theFolks.size());
                while (f2 == f1) {
                    f2 = rand.nextInt(theFolks.size());
                }
                folk12 = theFolks.get(f1);
                FolkData folk2 = theFolks.get(f2);
                Relationship.meddleWithRelationship(folk12, folk2);
            }
        }
        if (!ModSimReloaded.isDayTime() && isDay) {
            isDay = false;
            log.info("\u6e21\u8fc7\u4e00\u665a");
            if (theFolks.size() > 1) {
                Random rand = new Random();
                f1 = homeless = rand.nextInt(theFolks.size());
                while (f1 == homeless) {
                    f1 = rand.nextInt(theFolks.size());
                }
                folk12 = theFolks.get(homeless);
                FolkData folk2 = theFolks.get(f1);
                Relationship.meddleWithRelationship(folk12, folk2);
            }
            for (FolkData folk : theFolks) {
                folk.destination = null;
                if (folk.theEntity == null) continue;
                folk.theEntity.func_70661_as().func_75499_g();
            }
        }
    }

    private static void evolveFolks() {
        if (theFolks.size() > 0) {
            int f;
            FolkData folk;
            int fl;
            Random rand = new Random();
            log.info("\u8fdb\u5316\u7684\u4eba");
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    float totalRent = 0.0f;
                    float totalCorpTax = 0.0f;
                    if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        for (int b = 0; b < theBuildings.size(); ++b) {
                            Building building = theBuildings.get(b);
                            if (!building.type.contentEquals("residential") || building.tenants.size() <= 0) continue;
                            if (building.rent == null || building.rent.floatValue() == 0.0f) {
                                building.rent = Float.valueOf(1.0f);
                            }
                            log.info("\u623f\u5c4b\u79df\u91d1 " + building.displayNameWithoutPK + ": " + building.rent + "(" + building.blocksInBuilding + ")");
                            totalRent += building.rent.floatValue();
                        }
                    }
                    if (totalRent > 0.0f) {
                        ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.main_Collected", (Object[])new Object[0]) + ModSimReloaded.displayMoney(totalRent) + I18n.func_135052_a((String)"container.sim.main_rent_today", (Object[])new Object[0]));
                        ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.main_Collected", (Object[])new Object[0]) + ModSimReloaded.displayMoney(totalCorpTax) + I18n.func_135052_a((String)"container.sim.main_tax_today", (Object[])new Object[0]));
                        GameStates var10000 = states;
                        var10000.credits += totalRent;
                        var10000 = states;
                        var10000.credits += totalCorpTax;
                        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
                        if (p != null) {
                            ModSim.proxy.getClientWorld().func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "sim:cash", 1.0f, 1.0f, false);
                        }
                    } else if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                        ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.main_No_rent", (Object[])new Object[0]));
                    }
                }
            });
            t.start();
            for (fl = 0; fl < theFolks.size(); ++fl) {
                folk = theFolks.get(fl);
                folk.greetedToday = false;
                folk.shaggingStage = -1.0f;
                if (folk.pregnancyStage > 0.0f) {
                    folk.pregnancyStage += 0.1f;
                }
                if ((f = folk.age++) >= 18) {
                    if (ModSimReloaded.states.dayOfWeek == 6) {
                        // empty if block
                    }
                } else if (ModSimReloaded.states.dayOfWeek == 3 || ModSimReloaded.states.dayOfWeek == 6) {
                    ++folk.age;
                    if (f == 17 && folk.age == 18) {
                        folk.evictThem();
                        ModSimReloaded.sendChat(folk.name + I18n.func_135052_a((String)"container.sim.main_is_now", (Object[])new Object[0]));
                    }
                }
                if (folk.age <= 110 || rand.nextInt(10) != 5) continue;
                ModSimReloaded.sendChat(folk.name + I18n.func_135052_a((String)"container.sim.main_is_old", (Object[])new Object[0]));
                folk.eventDied(DamageSource.field_76377_j);
            }
            if (GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                fl = rand.nextInt(theFolks.size());
                for (f = 0; f < theFolks.size(); ++f) {
                    folk = theFolks.get(f);
                    if (f != fl) continue;
                    --folk.levelFood;
                    if (folk.levelFood != 0) continue;
                    ModSimReloaded.sendChat(folk.name + I18n.func_135052_a((String)"container.sim.main_is_VERY", (Object[])new Object[0]));
                }
                for (f = 0; f < theFolks.size(); ++f) {
                    folk = theFolks.get(f);
                    if (folk.theirJob == null || folk.vocation != Vocation.SOLDIER) continue;
                    JobSoldier job = (JobSoldier)folk.theirJob;
                    float pay = (float)job.kills * 0.2f;
                    if (job.kills <= 0) continue;
                    ModSimReloaded.sendChat(I18n.func_135052_a((String)"container.sim.main_Paid1", (Object[])new Object[0]) + folk.name + " " + ModSimReloaded.displayMoney(pay) + I18n.func_135052_a((String)"container.sim.main_Paid2", (Object[])new Object[0]) + job.kills + I18n.func_135052_a((String)"container.sim.main_Paid3", (Object[])new Object[0]));
                    GameStates var10000 = states;
                    var10000.credits -= pay;
                    job.kills = 0;
                }
                boolean updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150344_f, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150347_e, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150348_b, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150359_w, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150325_L, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150336_V, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150417_aV, updown);
                updown = rand.nextBoolean();
                PricesForBlocks.adjustPrice(Blocks.field_150422_aJ, updown);
            }
            states.saveStates();
            Commodity.refreshAvailableCommoditities();
        }
    }

    public static void demolishBlocks() {
        if (demolishBlocks.size() >= 1) {
            int count = demolishBlocks.size();
            if (count > 10) {
                count = 10;
            }
            for (int i = 0; i < count; ++i) {
                V3 blockLoc = demolishBlocks.get(0);
                try {
                    Block block = Block.func_149684_b((String)blockLoc.name);
                    block.func_149697_b(demolishWorld, blockLoc.x.intValue(), blockLoc.y.intValue() + 10 + new Random().nextInt(20), blockLoc.z.intValue(), 0, 0);
                    demolishBlocks.remove(0);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void upgradeFarm() {
        if (ModSimReloaded.farmToUpgrade.level == 0) {
            ModSimReloaded.farmToUpgrade.level = 1;
        }
        if (ModSimReloaded.farmToUpgrade.level == 1) {
            if (farmToUpgradePoints == null) {
                farmToUpgradePoints = farmToUpgrade.getPerimeterPoints();
            }
            V3 point = farmToUpgradePoints.get(farmToUpgradeCounter);
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(point.theDimension);
            Block id = theWorld.func_147439_a(point.x.intValue(), point.y.intValue(), point.z.intValue());
            boolean destroy = false;
            if (id != null) {
                TileEntity te = theWorld.func_147438_o(point.x.intValue(), point.y.intValue(), point.z.intValue());
                if (te == null) {
                    destroy = true;
                } else if (!(te instanceof IInventory)) {
                    destroy = true;
                }
            } else {
                destroy = true;
            }
            if (destroy) {
                theWorld.func_147480_a(point.x.intValue(), point.y.intValue(), point.z.intValue(), true);
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue(), point.z.intValue(), Blocks.field_150422_aJ, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue(), point.z.intValue());
            }
            if (farmToUpgradeCounter % 6 == 0) {
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 1, point.z.intValue(), BlockLoader.lightBox, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 1, point.z.intValue());
            }
        } else if (ModSimReloaded.farmToUpgrade.level == 2) {
            if (farmToUpgradePoints == null) {
                farmToUpgradePoints = farmToUpgrade.getSoilBlockPoints();
            }
            V3 point = farmToUpgradePoints.get(farmToUpgradeCounter);
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(point.theDimension);
            if (point.x.intValue() % 5 == 0 && point.z.intValue() % 5 == 0) {
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 1, point.z.intValue(), Blocks.field_150355_j, 0, 3);
                theWorld.func_147465_d(point.x.intValue(), point.y.intValue() - 2, point.z.intValue(), BlockLoader.lightBox, 0, 3);
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 1, point.z.intValue());
                theWorld.func_147471_g(point.x.intValue(), point.y.intValue() - 2, point.z.intValue());
            }
        }
        if (++farmToUpgradeCounter > farmToUpgradePoints.size() - 1) {
            ++ModSimReloaded.farmToUpgrade.level;
            farmToUpgradePoints = null;
            farmToUpgrade = null;
            farmToUpgradeCounter = 0;
            log.info("\u5b8c\u6210\u519c\u573a\u5347\u7ea7");
        }
    }

    public static String getDayOfWeek() {
        String simSun = I18n.func_135052_a((String)"container.sim.simSun", (Object[])new Object[0]);
        String simMon = I18n.func_135052_a((String)"container.sim.simMon", (Object[])new Object[0]);
        String simTue = I18n.func_135052_a((String)"container.sim.simTue", (Object[])new Object[0]);
        String simWed = I18n.func_135052_a((String)"container.sim.simWed", (Object[])new Object[0]);
        String simThu = I18n.func_135052_a((String)"container.sim.simThu", (Object[])new Object[0]);
        String simFri = I18n.func_135052_a((String)"container.sim.simFri", (Object[])new Object[0]);
        String simSat = I18n.func_135052_a((String)"container.sim.simSat", (Object[])new Object[0]);
        String[] dow = new String[]{simSun, simMon, simTue, simWed, simThu, simFri, simSat};
        return dow[ModSimReloaded.states.dayOfWeek];
    }

    public static ArrayList<String> loadSK2(String fullFilename) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(fullFilename));
            String line = br.readLine();
            while (line != null) {
                ret.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void saveSK2(String fullFilename, ArrayList<String> strings) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fullFilename));
            for (String line : strings) {
                bw.write(line + "\r\n");
            }
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

